/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.Record;
import db.RecordIterator;
import db.Schema;
import ghidra.program.database.data.CompositeDBAdapterV0;
import ghidra.program.database.data.CompositeDBAdapterV1;
import ghidra.program.database.data.CompositeDBAdapterV2V3;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class CompositeDBAdapter {
    static final String COMPOSITE_TABLE_NAME = "Composite Data Types";
    static final Schema COMPOSITE_SCHEMA = CompositeDBAdapterV2V3.V2_COMPOSITE_SCHEMA;
    static final int COMPOSITE_NAME_COL = 0;
    static final int COMPOSITE_COMMENT_COL = 1;
    static final int COMPOSITE_IS_UNION_COL = 2;
    static final int COMPOSITE_CAT_COL = 3;
    static final int COMPOSITE_LENGTH_COL = 4;
    static final int COMPOSITE_NUM_COMPONENTS_COL = 5;
    static final int COMPOSITE_SOURCE_ARCHIVE_ID_COL = 6;
    static final int COMPOSITE_UNIVERSAL_DT_ID = 7;
    static final int COMPOSITE_SOURCE_SYNC_TIME_COL = 8;
    static final int COMPOSITE_LAST_CHANGE_TIME_COL = 9;
    static final int COMPOSITE_INTERNAL_ALIGNMENT_COL = 10;
    static final int COMPOSITE_EXTERNAL_ALIGNMENT_COL = 11;
    static final byte UNALIGNED = -1;
    static final byte ALIGNED_NO_PACKING = 0;
    static final byte MACHINE_ALIGNED = -1;
    static final byte DEFAULT_ALIGNED = 0;

    CompositeDBAdapter() {
    }

    static CompositeDBAdapter getAdapter(DBHandle handle, int openMode, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        try {
            return new CompositeDBAdapterV2V3(handle, openMode);
        }
        catch (VersionException e) {
            if (openMode == 0) {
                throw new AssertException();
            }
            if (openMode == 3) {
                CompositeDBAdapter adapter = CompositeDBAdapter.findReadOnlyAdapter(handle);
                return CompositeDBAdapter.upgrade(handle, adapter, monitor);
            }
            throw e;
        }
    }

    static CompositeDBAdapter findReadOnlyAdapter(DBHandle handle) throws VersionException, IOException {
        try {
            return new CompositeDBAdapterV2V3(handle);
        }
        catch (VersionException versionException) {
            try {
                return new CompositeDBAdapterV1(handle);
            }
            catch (VersionException versionException2) {
                return new CompositeDBAdapterV0(handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CompositeDBAdapter upgrade(DBHandle handle, CompositeDBAdapter oldAdapter, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        DBHandle tmpHandle = new DBHandle();
        long id = tmpHandle.startTransaction();
        CompositeDBAdapterV2V3 tmpAdapter = null;
        try {
            tmpAdapter = new CompositeDBAdapterV2V3(tmpHandle, 0);
            RecordIterator it = oldAdapter.getRecords();
            while (it.hasNext()) {
                monitor.checkCanceled();
                Record rec = it.next();
                ((CompositeDBAdapter)tmpAdapter).updateRecord(rec, false);
            }
            oldAdapter.deleteTable(handle);
            CompositeDBAdapterV2V3 newAdapter = new CompositeDBAdapterV2V3(handle, 0);
            it = ((CompositeDBAdapter)tmpAdapter).getRecords();
            while (it.hasNext()) {
                monitor.checkCanceled();
                Record rec = it.next();
                ((CompositeDBAdapter)newAdapter).updateRecord(rec, false);
            }
            CompositeDBAdapterV2V3 compositeDBAdapterV2V3 = newAdapter;
            return compositeDBAdapterV2V3;
        }
        finally {
            tmpHandle.endTransaction(id, true);
            tmpHandle.close();
        }
    }

    abstract Record createRecord(String var1, String var2, boolean var3, long var4, int var6, long var7, long var9, long var11, int var13, int var14) throws IOException;

    abstract Record getRecord(long var1) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    abstract void updateRecord(Record var1, boolean var2) throws IOException;

    abstract boolean removeRecord(long var1) throws IOException;

    abstract void deleteTable(DBHandle var1) throws IOException;

    abstract long[] getRecordIdsInCategory(long var1) throws IOException;

    abstract long[] getRecordIdsForSourceArchive(long var1) throws IOException;

    abstract Record getRecordWithIDs(UniversalID var1, UniversalID var2) throws IOException;
}

