/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.properties;

import db.DBHandle;
import db.LongField;
import db.Record;
import db.util.ErrorHandler;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.properties.PropertyMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.util.LongPropertyMap;
import ghidra.program.util.ChangeManager;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NoValueException;
import ghidra.util.exception.NotYetImplementedException;
import ghidra.util.exception.VersionException;
import ghidra.util.prop.PropertyVisitor;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class LongPropertyMapDB
extends PropertyMapDB
implements LongPropertyMap {
    public LongPropertyMapDB(DBHandle dbHandle, int openMode, ErrorHandler errHandler, ChangeManager changeMgr, AddressMap addrMap, String name, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        super(dbHandle, errHandler, changeMgr, addrMap, name);
        this.checkMapVersion(openMode, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Address addr, long value) {
        Long oldValue = null;
        this.lock.acquire();
        try {
            Record rec;
            long key = this.addrMap.getKey(addr, true);
            if (this.propertyTable == null) {
                this.createTable(LongField.class);
            } else {
                oldValue = (Long)this.cache.get(key);
                if (oldValue == null && (rec = this.propertyTable.getRecord(key)) != null) {
                    oldValue = new Long(rec.getLongValue(0));
                }
            }
            rec = this.schema.createRecord(key);
            rec.setLongValue(0, value);
            this.propertyTable.putRecord(rec);
            this.cache.put(key, (Object)new Long(value));
            this.changeMgr.setPropertyChanged(this.name, addr, oldValue, new Long(value));
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(Address addr) throws NoValueException {
        if (this.propertyTable == null) {
            throw NO_VALUE_EXCEPTION;
        }
        this.lock.acquire();
        try {
            long key = this.addrMap.getKey(addr, false);
            if (key == -1L) {
                long l = 0L;
                return l;
            }
            Object obj = this.cache.get(key);
            if (obj != null) {
                long l = (Long)obj;
                return l;
            }
            Record rec = this.propertyTable.getRecord(key);
            if (rec == null) {
                throw NO_VALUE_EXCEPTION;
            }
            long l = rec.getLongValue(0);
            return l;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return 0L;
    }

    @Override
    public Object getObject(Address addr) {
        try {
            return new Long(this.getLong(addr));
        }
        catch (NoValueException e) {
            return null;
        }
    }

    @Override
    public void applyValue(PropertyVisitor visitor, Address addr) {
        throw new NotYetImplementedException();
    }
}

