/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.ant.model;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ant.model.JpsAntBuildFileOptions;
import org.jetbrains.jps.ant.model.JpsAntConfiguration;
import org.jetbrains.jps.ant.model.JpsAntInstallation;
import org.jetbrains.jps.ant.model.artifacts.JpsAntArtifactExtension;
import org.jetbrains.jps.ant.model.impl.JpsAntBuildFileOptionsImpl;
import org.jetbrains.jps.ant.model.impl.JpsAntConfigurationImpl;
import org.jetbrains.jps.ant.model.impl.JpsAntInstallationImpl;
import org.jetbrains.jps.ant.model.impl.artifacts.JpsAntArtifactExtensionImpl;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.artifact.JpsArtifact;

public class JpsAntExtensionService {
    public static final String BUNDLED_ANT_PATH_PROPERTY = "jps.bundled.ant.path";
    private static final Logger LOG = Logger.getInstance(JpsAntExtensionService.class);

    @Nullable
    public static JpsAntArtifactExtension getPreprocessingExtension(@NotNull JpsArtifact artifact) {
        if (artifact == null) {
            JpsAntExtensionService.$$$reportNull$$$0(0);
        }
        return (JpsAntArtifactExtension)artifact.getContainer().getChild(JpsAntArtifactExtensionImpl.PREPROCESSING_ROLE);
    }

    @Nullable
    public static JpsAntArtifactExtension getPostprocessingExtension(@NotNull JpsArtifact artifact) {
        if (artifact == null) {
            JpsAntExtensionService.$$$reportNull$$$0(1);
        }
        return (JpsAntArtifactExtension)artifact.getContainer().getChild(JpsAntArtifactExtensionImpl.POSTPROCESSING_ROLE);
    }

    public static void addAntInstallation(JpsGlobal global, JpsAntInstallation antInstallation) {
        ((JpsElementCollection)global.getContainer().getOrSetChild(JpsAntInstallationImpl.COLLECTION_ROLE)).addChild((JpsElement)antInstallation);
    }

    @NotNull
    public static JpsAntBuildFileOptions getOptions(@NotNull JpsProject project, @NotNull String buildFileUrl) {
        JpsAntConfiguration configuration;
        if (project == null) {
            JpsAntExtensionService.$$$reportNull$$$0(2);
        }
        if (buildFileUrl == null) {
            JpsAntExtensionService.$$$reportNull$$$0(3);
        }
        if ((configuration = JpsAntExtensionService.getAntConfiguration(project)) != null) {
            JpsAntBuildFileOptions jpsAntBuildFileOptions = configuration.getOptions(buildFileUrl);
            if (jpsAntBuildFileOptions == null) {
                JpsAntExtensionService.$$$reportNull$$$0(4);
            }
            return jpsAntBuildFileOptions;
        }
        return new JpsAntBuildFileOptionsImpl();
    }

    @Nullable
    private static JpsAntConfiguration getAntConfiguration(JpsProject project) {
        return (JpsAntConfiguration)project.getContainer().getChild(JpsAntConfigurationImpl.ROLE);
    }

    @NotNull
    public static JpsAntConfiguration getOrCreateAntConfiguration(@NotNull JpsProject project) {
        JpsAntConfiguration configuration;
        if (project == null) {
            JpsAntExtensionService.$$$reportNull$$$0(5);
        }
        if ((configuration = JpsAntExtensionService.getAntConfiguration(project)) != null) {
            JpsAntConfiguration jpsAntConfiguration = configuration;
            if (jpsAntConfiguration == null) {
                JpsAntExtensionService.$$$reportNull$$$0(6);
            }
            return jpsAntConfiguration;
        }
        JpsAntConfigurationImpl antConfiguration = new JpsAntConfigurationImpl(new HashMap<String, JpsAntBuildFileOptions>(), null);
        JpsAntConfiguration jpsAntConfiguration = (JpsAntConfiguration)project.getContainer().setChild(JpsAntConfigurationImpl.ROLE, (JpsElement)antConfiguration);
        if (jpsAntConfiguration == null) {
            JpsAntExtensionService.$$$reportNull$$$0(7);
        }
        return jpsAntConfiguration;
    }

    @Nullable
    private static JpsAntInstallation getBundledAntInstallation() {
        File antHome;
        String antPath = System.getProperty(BUNDLED_ANT_PATH_PROPERTY);
        if (antPath != null) {
            antHome = new File(antPath);
        } else {
            File communityAntHome;
            String appHome = PathManager.getHomePath((boolean)false);
            if (appHome == null) {
                LOG.debug("idea.home.path and jps.bundled.ant.path aren't specified, bundled Ant won't be configured");
                return null;
            }
            antHome = new File(appHome, "lib" + File.separator + "ant");
            if (!antHome.exists() && (communityAntHome = new File(appHome, "community" + File.separator + "lib" + File.separator + "ant")).exists()) {
                antHome = communityAntHome;
            }
        }
        if (!antHome.exists()) {
            LOG.debug("Bundled Ant not found at " + antHome.getAbsolutePath());
            return null;
        }
        String antLib = new File(antHome, "lib").getAbsolutePath();
        return new JpsAntInstallationImpl(antHome, "Bundled Ant", Collections.emptyList(), Collections.singletonList(antLib));
    }

    @Nullable
    public static JpsAntInstallation getAntInstallationForBuildFile(@NotNull JpsModel model, @NotNull String buildFileUrl) {
        JpsAntConfiguration antConfiguration;
        JpsAntBuildFileOptions options;
        String antInstallationName;
        if (model == null) {
            JpsAntExtensionService.$$$reportNull$$$0(8);
        }
        if (buildFileUrl == null) {
            JpsAntExtensionService.$$$reportNull$$$0(9);
        }
        if ((antInstallationName = (options = JpsAntExtensionService.getOptions(model.getProject(), buildFileUrl)).isUseProjectDefaultAnt() ? ((antConfiguration = JpsAntExtensionService.getAntConfiguration(model.getProject())) != null ? antConfiguration.getProjectDefaultAntName() : null) : options.getAntInstallationName()) == null) {
            return JpsAntExtensionService.getBundledAntInstallation();
        }
        return JpsAntExtensionService.findAntInstallation(model, antInstallationName);
    }

    @Nullable
    public static JpsAntInstallation findAntInstallation(@NotNull JpsModel model, @NotNull String antInstallationName) {
        JpsElementCollection antInstallations;
        if (model == null) {
            JpsAntExtensionService.$$$reportNull$$$0(10);
        }
        if (antInstallationName == null) {
            JpsAntExtensionService.$$$reportNull$$$0(11);
        }
        if ((antInstallations = (JpsElementCollection)model.getGlobal().getContainer().getChild(JpsAntInstallationImpl.COLLECTION_ROLE)) != null) {
            for (JpsAntInstallation installation : antInstallations.getElements()) {
                if (!antInstallationName.equals(installation.getName())) continue;
                return installation;
            }
            LOG.debug("Ant installation '" + antInstallationName + "' not found");
        } else {
            LOG.debug("Ant installations weren't loaded");
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFileUrl";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/ant/model/JpsAntExtensionService";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "antInstallationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/ant/model/JpsAntExtensionService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateAntConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPreprocessingExtension";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPostprocessingExtension";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOptions";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateAntConfiguration";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAntInstallationForBuildFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findAntInstallation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

