/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.NumberAssert;

public class IntAssert
extends GenericAssert<IntAssert, Integer>
implements NumberAssert {
    private static final int ZERO = 0;

    protected IntAssert(int actual) {
        super(IntAssert.class, actual);
    }

    protected IntAssert(@Nullable Integer actual) {
        super(IntAssert.class, actual);
    }

    @Override
    @Nonnull
    public IntAssert isEqualTo(int expected) {
        return (IntAssert)this.isEqualTo(Integer.valueOf(expected));
    }

    @Override
    @Nonnull
    public IntAssert isNotEqualTo(int other) {
        return (IntAssert)this.isNotEqualTo(Integer.valueOf(other));
    }

    @Nonnull
    public IntAssert isGreaterThan(int other) {
        if ((Integer)this.actual > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    @Nonnull
    public IntAssert isLessThan(int other) {
        if ((Integer)this.actual < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    @Nonnull
    public IntAssert isGreaterThanOrEqualTo(int other) {
        if ((Integer)this.actual >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    @Nonnull
    public IntAssert isLessThanOrEqualTo(int other) {
        if ((Integer)this.actual <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    @Override
    @Nonnull
    public IntAssert isZero() {
        return this.isEqualTo(0);
    }

    @Override
    @Nonnull
    public IntAssert isPositive() {
        return this.isGreaterThan(0);
    }

    @Override
    @Nonnull
    public IntAssert isNegative() {
        return this.isLessThan(0);
    }
}

