/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.NumberAssert;

public class LongAssert
extends GenericAssert<LongAssert, Long>
implements NumberAssert {
    private static final long ZERO = 0L;

    protected LongAssert(long actual) {
        super(LongAssert.class, actual);
    }

    protected LongAssert(@Nullable Long actual) {
        super(LongAssert.class, actual);
    }

    @Override
    @Nonnull
    public LongAssert isEqualTo(long expected) {
        return (LongAssert)this.isEqualTo(Long.valueOf(expected));
    }

    @Override
    @Nonnull
    public LongAssert isNotEqualTo(long other) {
        return (LongAssert)this.isNotEqualTo(Long.valueOf(other));
    }

    @Nonnull
    public LongAssert isGreaterThan(long other) {
        if ((Long)this.actual > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    @Nonnull
    public LongAssert isLessThan(long other) {
        if ((Long)this.actual < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    @Nonnull
    public LongAssert isGreaterThanOrEqualTo(long other) {
        if ((Long)this.actual >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    @Nonnull
    public LongAssert isLessThanOrEqualTo(long other) {
        if ((Long)this.actual <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    @Override
    @Nonnull
    public LongAssert isZero() {
        return this.isEqualTo(0L);
    }

    @Override
    @Nonnull
    public LongAssert isPositive() {
        return this.isGreaterThan(0L);
    }

    @Override
    @Nonnull
    public LongAssert isNegative() {
        return this.isLessThan(0L);
    }
}

