/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira;

import com.intellij.util.text.VersionComparatorUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class JiraVersion
implements Comparable<JiraVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)(?:[^\\d]+(\\d+))?(?:[^\\d]+(\\d+))?.*");
    private final int myMajorNumber;
    private final int myMinorNumber;
    private final int myMicroNumber;

    public JiraVersion(int majorNumber) {
        this(majorNumber, 0, 0);
    }

    public JiraVersion(int majorNumber, int minorNumber) {
        this(majorNumber, minorNumber, 0);
    }

    public JiraVersion(int majorNumber, int minorNumber, int microNumber) {
        this.myMajorNumber = majorNumber;
        this.myMinorNumber = minorNumber;
        this.myMicroNumber = microNumber;
    }

    public JiraVersion(@NotNull String version) {
        if (version == null) {
            JiraVersion.$$$reportNull$$$0(0);
        }
        Matcher m = VERSION_PATTERN.matcher(version);
        if (!m.matches()) {
            throw new IllegalArgumentException("Illegal JIRA version number: " + version);
        }
        this.myMajorNumber = m.group(1) == null ? 0 : Integer.parseInt(m.group(1));
        this.myMinorNumber = m.group(2) == null ? 0 : Integer.parseInt(m.group(2));
        this.myMicroNumber = m.group(3) == null ? 0 : Integer.parseInt(m.group(3));
    }

    public int getMajorNumber() {
        return this.myMajorNumber;
    }

    public int getMinorNumber() {
        return this.myMinorNumber;
    }

    public int getMicroNumber() {
        return this.myMicroNumber;
    }

    public String toString() {
        return String.format("%d.%d.%d", this.myMajorNumber, this.myMinorNumber, this.myMicroNumber);
    }

    @Override
    public int compareTo(@NotNull JiraVersion o) {
        if (o == null) {
            JiraVersion.$$$reportNull$$$0(1);
        }
        return VersionComparatorUtil.compare((String)this.toString(), (String)o.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tasks/jira/JiraVersion";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "compareTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

