/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.gradle.internal.impldep.org.bouncycastle.asn1.x9.X9ECParameters;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.MPInteger;
import org.gradle.internal.impldep.org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.gradle.internal.impldep.org.bouncycastle.crypto.EphemeralKeyPair;
import org.gradle.internal.impldep.org.bouncycastle.crypto.InvalidCipherTextException;
import org.gradle.internal.impldep.org.bouncycastle.crypto.KeyEncoder;
import org.gradle.internal.impldep.org.bouncycastle.crypto.Wrapper;
import org.gradle.internal.impldep.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.gradle.internal.impldep.org.bouncycastle.crypto.generators.EphemeralKeyPairGenerator;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.ECDomainParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.KeyParameter;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.ParametersWithRandom;
import org.gradle.internal.impldep.org.bouncycastle.math.ec.ECPoint;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PGPPad;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc.RFC6637KDFCalculator;

public class BcPublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private SecureRandom random;
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    public BcPublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        super(pGPPublicKey);
    }

    public BcPublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    protected byte[] encryptSessionInfo(PGPPublicKey pGPPublicKey, byte[] byArray) throws PGPException {
        try {
            if (pGPPublicKey.getAlgorithm() != 18) {
                AsymmetricBlockCipher asymmetricBlockCipher = BcImplProvider.createPublicKeyCipher(pGPPublicKey.getAlgorithm());
                AsymmetricKeyParameter asymmetricKeyParameter = this.keyConverter.getPublicKey(pGPPublicKey);
                if (this.random == null) {
                    this.random = new SecureRandom();
                }
                asymmetricBlockCipher.init(true, new ParametersWithRandom(asymmetricKeyParameter, this.random));
                return asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
            }
            ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)pGPPublicKey.getPublicKeyPacket().getKey();
            X9ECParameters x9ECParameters = BcUtil.getX9Parameters(eCDHPublicBCPGKey.getCurveOID());
            ECDomainParameters eCDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
            ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
            eCKeyPairGenerator.init(new ECKeyGenerationParameters(eCDomainParameters, this.random));
            EphemeralKeyPairGenerator ephemeralKeyPairGenerator = new EphemeralKeyPairGenerator(eCKeyPairGenerator, new KeyEncoder(){

                public byte[] getEncoded(AsymmetricKeyParameter asymmetricKeyParameter) {
                    return ((ECPublicKeyParameters)asymmetricKeyParameter).getQ().getEncoded(false);
                }
            });
            EphemeralKeyPair ephemeralKeyPair = ephemeralKeyPairGenerator.generate();
            ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)ephemeralKeyPair.getKeyPair().getPrivate();
            ECPoint eCPoint = BcUtil.decodePoint(eCDHPublicBCPGKey.getEncodedPoint(), x9ECParameters.getCurve()).multiply(eCPrivateKeyParameters.getD()).normalize();
            RFC6637KDFCalculator rFC6637KDFCalculator = new RFC6637KDFCalculator(new BcPGPDigestCalculatorProvider().get(eCDHPublicBCPGKey.getHashAlgorithm()), eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
            KeyParameter keyParameter = new KeyParameter(rFC6637KDFCalculator.createKey(eCPoint, RFC6637Utils.createUserKeyingMaterial(pGPPublicKey.getPublicKeyPacket(), new BcKeyFingerprintCalculator())));
            Wrapper wrapper = BcImplProvider.createWrapper(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
            wrapper.init(true, new ParametersWithRandom(keyParameter, this.random));
            byte[] byArray2 = PGPPad.padSessionData(byArray);
            byte[] byArray3 = wrapper.wrap(byArray2, 0, byArray2.length);
            byte[] byArray4 = new MPInteger(new BigInteger(1, ephemeralKeyPair.getEncodedPublicKey())).getEncoded();
            byte[] byArray5 = new byte[byArray4.length + 1 + byArray3.length];
            System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
            byArray5[byArray4.length] = (byte)byArray3.length;
            System.arraycopy(byArray3, 0, byArray5, byArray4.length + 1, byArray3.length);
            return byArray5;
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("exception encrypting session info: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
        catch (IOException iOException) {
            throw new PGPException("exception encrypting session info: " + iOException.getMessage(), iOException);
        }
    }
}

