/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.codehaus.classworlds;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.gradle.internal.impldep.org.codehaus.classworlds.BytesURLStreamHandler;
import org.gradle.internal.impldep.org.codehaus.classworlds.ClassRealm;
import org.gradle.internal.impldep.org.codehaus.classworlds.ClassRealmAdapter;
import org.gradle.internal.impldep.org.codehaus.classworlds.ClassWorld;
import org.gradle.internal.impldep.org.codehaus.classworlds.ClassWorldReverseAdapter;
import org.gradle.internal.impldep.org.codehaus.classworlds.DuplicateRealmException;
import org.gradle.internal.impldep.org.codehaus.classworlds.NoSuchRealmException;

public class DefaultClassRealm
implements ClassRealm {
    private ClassRealmAdapter adapter;

    public DefaultClassRealm(ClassWorld world, String id) {
        this(world, id, null);
    }

    public DefaultClassRealm(ClassWorld world, String id, ClassLoader foreignClassLoader) {
        this.adapter = ClassRealmAdapter.getInstance(new org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.ClassRealm(ClassWorldReverseAdapter.getInstance(world), id, foreignClassLoader));
    }

    public URL[] getConstituents() {
        return this.adapter.getConstituents();
    }

    public ClassRealm getParent() {
        return this.adapter.getParentRealm();
    }

    public void setParent(ClassRealm parent) {
        this.adapter.setParent(parent);
    }

    public String getId() {
        return this.adapter.getId();
    }

    public ClassWorld getWorld() {
        return this.adapter.getWorld();
    }

    public void importFrom(String realmId, String packageName) throws NoSuchRealmException {
        this.adapter.importFrom(realmId, packageName);
    }

    public void addConstituent(URL constituent) {
        this.adapter.addConstituent(constituent);
    }

    public void addConstituent(String constituent, byte[] b) throws ClassNotFoundException {
        try {
            File file;
            if (constituent.lastIndexOf(46) != -1) {
                File path = new File("byteclass/" + constituent.substring(0, constituent.lastIndexOf(46) + 1).replace('.', File.separatorChar));
                file = new File(path, constituent.substring(constituent.lastIndexOf(46) + 1) + ".class");
            } else {
                File path = new File("byteclass/");
                file = new File(path, constituent + ".class");
            }
            this.addConstituent(new URL(null, file.toURI().toURL().toExternalForm(), new BytesURLStreamHandler(b)));
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Couldn't load byte stream.", e);
        }
    }

    public ClassRealm locateSourceRealm(String classname) {
        return this.adapter.locateSourceRealm(classname);
    }

    public ClassLoader getClassLoader() {
        return this.adapter.getClassLoader();
    }

    public ClassRealm createChildRealm(String id) throws DuplicateRealmException {
        return this.adapter.createChildRealm(id);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.adapter.loadClass(name);
    }

    public URL getResource(String name) {
        return this.adapter.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.adapter.getResourceAsStream(name);
    }

    public Enumeration findResources(String name) throws IOException {
        return this.adapter.findResources(name);
    }

    public void display() {
        this.adapter.display();
    }
}

