/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.blame;

import java.io.IOException;
import org.gradle.internal.impldep.org.eclipse.jgit.blame.BlameGenerator;
import org.gradle.internal.impldep.org.eclipse.jgit.diff.RawText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.PersonIdent;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevCommit;

public class BlameResult {
    private final String resultPath;
    private final RevCommit[] sourceCommits;
    private final PersonIdent[] sourceAuthors;
    private final PersonIdent[] sourceCommitters;
    private final String[] sourcePaths;
    private final int[] sourceLines;
    private RawText resultContents;
    private BlameGenerator generator;
    private int lastLength;

    public static BlameResult create(BlameGenerator gen) throws IOException {
        String path = gen.getResultPath();
        RawText contents = gen.getResultContents();
        if (contents == null) {
            gen.close();
            return null;
        }
        return new BlameResult(gen, path, contents);
    }

    BlameResult(BlameGenerator bg, String path, RawText text) {
        this.generator = bg;
        this.resultPath = path;
        this.resultContents = text;
        int cnt = text.size();
        this.sourceCommits = new RevCommit[cnt];
        this.sourceAuthors = new PersonIdent[cnt];
        this.sourceCommitters = new PersonIdent[cnt];
        this.sourceLines = new int[cnt];
        this.sourcePaths = new String[cnt];
    }

    public String getResultPath() {
        return this.resultPath;
    }

    public RawText getResultContents() {
        return this.resultContents;
    }

    public void discardResultContents() {
        this.resultContents = null;
    }

    public boolean hasSourceData(int idx) {
        return this.sourceLines[idx] != 0;
    }

    public boolean hasSourceData(int start, int end) {
        while (start < end) {
            if (this.sourceLines[start] == 0) {
                return false;
            }
            ++start;
        }
        return true;
    }

    public RevCommit getSourceCommit(int idx) {
        return this.sourceCommits[idx];
    }

    public PersonIdent getSourceAuthor(int idx) {
        return this.sourceAuthors[idx];
    }

    public PersonIdent getSourceCommitter(int idx) {
        return this.sourceCommitters[idx];
    }

    public String getSourcePath(int idx) {
        return this.sourcePaths[idx];
    }

    public int getSourceLine(int idx) {
        return this.sourceLines[idx] - 1;
    }

    /*
     * Exception decompiling
     */
    public void computeAll() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int computeNext() throws IOException {
        BlameGenerator gen = this.generator;
        if (gen == null) {
            return -1;
        }
        if (gen.next()) {
            this.loadFrom(gen);
            this.lastLength = gen.getRegionLength();
            return gen.getResultStart();
        }
        gen.close();
        this.generator = null;
        return -1;
    }

    public int lastLength() {
        return this.lastLength;
    }

    /*
     * Unable to fully structure code
     */
    public void computeRange(int start, int end) throws IOException {
        gen = this.generator;
        if (gen == null) {
            return;
        }
        if (start != 0 || end != this.resultContents.size()) ** GOTO lbl20
        this.computeAll();
        return;
lbl-1000:
        // 1 sources

        {
            if (this.hasSourceData(start, end)) {
                return;
            }
            if (!gen.next()) {
                gen.close();
                this.generator = null;
                return;
            }
            this.loadFrom(gen);
            resLine = gen.getResultStart();
            resEnd = gen.getResultEnd();
            if (resLine <= start && start < resEnd) {
                start = resEnd;
            }
            if (resLine > end || end >= resEnd) continue;
            end = resLine;
lbl20:
            // 3 sources

            ** while (start < end)
        }
lbl21:
        // 1 sources

    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("BlameResult: ");
        r.append(this.getResultPath());
        return r.toString();
    }

    private void loadFrom(BlameGenerator gen) {
        RevCommit srcCommit = gen.getSourceCommit();
        PersonIdent srcAuthor = gen.getSourceAuthor();
        PersonIdent srcCommitter = gen.getSourceCommitter();
        String srcPath = gen.getSourcePath();
        int srcLine = gen.getSourceStart();
        int resLine = gen.getResultStart();
        int resEnd = gen.getResultEnd();
        while (resLine < resEnd) {
            if (this.sourceLines[resLine] == 0) {
                this.sourceCommits[resLine] = srcCommit;
                this.sourceAuthors[resLine] = srcAuthor;
                this.sourceCommitters[resLine] = srcCommitter;
                this.sourcePaths[resLine] = srcPath;
                this.sourceLines[resLine] = ++srcLine;
            }
            ++resLine;
        }
    }
}

