/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.internal.management;

import java.lang.reflect.InvocationTargetException;
import org.gradle.internal.impldep.org.junit.internal.Classes;
import org.gradle.internal.impldep.org.junit.internal.management.FakeRuntimeMXBean;
import org.gradle.internal.impldep.org.junit.internal.management.FakeThreadMXBean;
import org.gradle.internal.impldep.org.junit.internal.management.ReflectiveRuntimeMXBean;
import org.gradle.internal.impldep.org.junit.internal.management.ReflectiveThreadMXBean;
import org.gradle.internal.impldep.org.junit.internal.management.RuntimeMXBean;
import org.gradle.internal.impldep.org.junit.internal.management.ThreadMXBean;

public class ManagementFactory {
    public static RuntimeMXBean getRuntimeMXBean() {
        return RuntimeHolder.RUNTIME_MX_BEAN;
    }

    public static ThreadMXBean getThreadMXBean() {
        return ThreadHolder.THREAD_MX_BEAN;
    }

    private static final class ThreadHolder {
        private static final ThreadMXBean THREAD_MX_BEAN = ThreadHolder.getBean(FactoryHolder.getBeanObject("getThreadMXBean"));

        private ThreadHolder() {
        }

        private static final ThreadMXBean getBean(Object threadMxBean) {
            return threadMxBean != null ? new ReflectiveThreadMXBean(threadMxBean) : new FakeThreadMXBean();
        }
    }

    private static final class RuntimeHolder {
        private static final RuntimeMXBean RUNTIME_MX_BEAN = RuntimeHolder.getBean(FactoryHolder.getBeanObject("getRuntimeMXBean"));

        private RuntimeHolder() {
        }

        private static final RuntimeMXBean getBean(Object runtimeMxBean) {
            return runtimeMxBean != null ? new ReflectiveRuntimeMXBean(runtimeMxBean) : new FakeRuntimeMXBean();
        }
    }

    private static final class FactoryHolder {
        private static final Class<?> MANAGEMENT_FACTORY_CLASS;

        private FactoryHolder() {
        }

        static Object getBeanObject(String methodName) {
            if (MANAGEMENT_FACTORY_CLASS != null) {
                try {
                    return MANAGEMENT_FACTORY_CLASS.getMethod(methodName, new Class[0]).invoke(null, new Object[0]);
                }
                catch (IllegalAccessException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (InvocationTargetException e) {
                }
                catch (NoSuchMethodException e) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            return null;
        }

        static {
            Class<?> managementFactoryClass = null;
            try {
                managementFactoryClass = Classes.getClass("java.lang.management.ManagementFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            MANAGEMENT_FACTORY_CLASS = managementFactoryClass;
        }
    }
}

