/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine.discovery;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.gradle.internal.impldep.org.junit.platform.engine.FilterResult;
import org.gradle.internal.impldep.org.junit.platform.engine.discovery.AbstractClassNameFilter;

class IncludeClassNameFilter
extends AbstractClassNameFilter {
    IncludeClassNameFilter(String ... patterns) {
        super(patterns);
    }

    @Override
    public FilterResult apply(String className) {
        return this.findMatchingPattern(className).map(pattern -> FilterResult.included(this.formatInclusionReason(className, (Pattern)pattern))).orElseGet(() -> FilterResult.excluded(this.formatExclusionReason(className)));
    }

    private String formatInclusionReason(String className, Pattern pattern) {
        return String.format("Class name [%s] matches included pattern: '%s'", className, pattern);
    }

    private String formatExclusionReason(String className) {
        return String.format("Class name [%s] does not match any included pattern: %s", className, this.patternDescription);
    }

    @Override
    public Predicate<String> toPredicate() {
        return className -> this.findMatchingPattern((String)className).isPresent();
    }

    public String toString() {
        return String.format("%s that includes class names that match one of the following regular expressions: %s", this.getClass().getSimpleName(), this.patternDescription);
    }
}

