/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.maven.polyglot;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.maven.model.io.ModelReader;
import org.gradle.internal.impldep.org.apache.maven.model.io.ModelWriter;
import org.gradle.internal.impldep.org.apache.maven.model.locator.ModelLocator;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Component;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Requirement;
import org.gradle.internal.impldep.org.codehaus.plexus.logging.Logger;
import org.gradle.internal.impldep.org.sonatype.maven.polyglot.mapping.Mapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=PolyglotModelManager.class)
public class PolyglotModelManager
implements ModelLocator {
    @Requirement
    protected Logger log;
    @Requirement(role=Mapping.class)
    private List<Mapping> mappings;

    public void addMapping(Mapping mapping) {
        assert (mapping != null);
        this.mappings.add(mapping);
    }

    public ModelReader getReaderFor(Map<String, ?> options) {
        for (Mapping mapping : this.mappings) {
            if (!mapping.accept(options)) continue;
            return mapping.getReader();
        }
        throw new RuntimeException("Unable determine model input format; options=" + options);
    }

    public ModelWriter getWriterFor(Map<String, ?> options) {
        for (Mapping mapping : this.mappings) {
            if (!mapping.accept(options)) continue;
            return mapping.getWriter();
        }
        throw new RuntimeException("Unable determine model output format; options=" + options);
    }

    @Override
    public File locatePom(File dir2) {
        assert (dir2 != null);
        File pomFile = null;
        float mappingPriority = Float.MIN_VALUE;
        for (Mapping mapping : this.mappings) {
            File file = mapping.locatePom(dir2);
            if (file == null || pomFile != null && !(mappingPriority < mapping.getPriority())) continue;
            pomFile = file;
            mappingPriority = mapping.getPriority();
        }
        return pomFile;
    }
}

