/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.nio.DoubleBuffer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.BaseStreamEx;
import one.util.streamex.ConstSpliterator;
import one.util.streamex.DoubleCollector;
import one.util.streamex.EmitterSpliterator;
import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.Internals;
import one.util.streamex.LongStreamEx;
import one.util.streamex.PairSpliterator;
import one.util.streamex.PrefixOps;
import one.util.streamex.RangeBasedSpliterator;
import one.util.streamex.StreamContext;
import one.util.streamex.StreamEx;
import one.util.streamex.TakeDrop;
import one.util.streamex.UnknownSizeSpliterator;
import one.util.streamex.VerSpec;

public class DoubleStreamEx
extends BaseStreamEx<Double, DoubleStream, Spliterator.OfDouble, DoubleStreamEx>
implements DoubleStream {
    DoubleStreamEx(DoubleStream stream, StreamContext context) {
        super(stream, context);
    }

    DoubleStreamEx(Spliterator.OfDouble spliterator, StreamContext context) {
        super(spliterator, context);
    }

    @Override
    DoubleStream createStream() {
        return StreamSupport.doubleStream((Spliterator.OfDouble)this.spliterator, this.isParallel());
    }

    private static DoubleStreamEx seq(DoubleStream stream) {
        return new DoubleStreamEx(stream, StreamContext.SEQUENTIAL);
    }

    final DoubleStreamEx delegate(Spliterator.OfDouble spliterator) {
        return new DoubleStreamEx(spliterator, this.context);
    }

    @Override
    public DoubleStreamEx unordered() {
        return (DoubleStreamEx)super.unordered();
    }

    @Override
    public DoubleStreamEx onClose(Runnable closeHandler) {
        return (DoubleStreamEx)super.onClose(closeHandler);
    }

    @Override
    public DoubleStreamEx filter(DoublePredicate predicate) {
        return new DoubleStreamEx(((DoubleStream)this.stream()).filter(predicate), this.context);
    }

    public DoubleStreamEx remove(DoublePredicate predicate) {
        return this.filter(predicate.negate());
    }

    public DoubleStreamEx greater(double value) {
        return this.filter(val -> val > value);
    }

    public DoubleStreamEx less(double value) {
        return this.filter(val -> val < value);
    }

    public DoubleStreamEx atLeast(double value) {
        return this.filter(val -> val >= value);
    }

    public DoubleStreamEx atMost(double value) {
        return this.filter(val -> val <= value);
    }

    @Override
    public DoubleStreamEx map(DoubleUnaryOperator mapper) {
        return new DoubleStreamEx(((DoubleStream)this.stream()).map(mapper), this.context);
    }

    public DoubleStreamEx mapFirst(DoubleUnaryOperator mapper) {
        return this.delegate(new PairSpliterator.PSOfDouble((a, b) -> b, mapper, (Spliterator.OfDouble)this.spliterator(), 1));
    }

    public DoubleStreamEx mapLast(DoubleUnaryOperator mapper) {
        return this.delegate(new PairSpliterator.PSOfDouble((a, b) -> a, mapper, (Spliterator.OfDouble)this.spliterator(), 2));
    }

    public <U> StreamEx<U> mapToObj(DoubleFunction<? extends U> mapper) {
        return new StreamEx<U>(((DoubleStream)this.stream()).mapToObj(mapper), this.context);
    }

    @Override
    public IntStreamEx mapToInt(DoubleToIntFunction mapper) {
        return new IntStreamEx(((DoubleStream)this.stream()).mapToInt(mapper), this.context);
    }

    @Override
    public LongStreamEx mapToLong(DoubleToLongFunction mapper) {
        return new LongStreamEx(((DoubleStream)this.stream()).mapToLong(mapper), this.context);
    }

    public <K, V> EntryStream<K, V> mapToEntry(DoubleFunction<? extends K> keyMapper, DoubleFunction<? extends V> valueMapper) {
        return new EntryStream(((DoubleStream)this.stream()).mapToObj((double t) -> new AbstractMap.SimpleImmutableEntry(keyMapper.apply(t), valueMapper.apply(t))), this.context);
    }

    @Override
    public DoubleStreamEx flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        return new DoubleStreamEx(((DoubleStream)this.stream()).flatMap(mapper), this.context);
    }

    public IntStreamEx flatMapToInt(DoubleFunction<? extends IntStream> mapper) {
        return new IntStreamEx(((DoubleStream)this.stream()).mapToObj(mapper).flatMapToInt(Function.identity()), this.context);
    }

    public LongStreamEx flatMapToLong(DoubleFunction<? extends LongStream> mapper) {
        return new LongStreamEx(((DoubleStream)this.stream()).mapToObj(mapper).flatMapToLong(Function.identity()), this.context);
    }

    public <R> StreamEx<R> flatMapToObj(DoubleFunction<? extends Stream<R>> mapper) {
        return new StreamEx(((DoubleStream)this.stream()).mapToObj(mapper).flatMap(Function.identity()), this.context);
    }

    public DoubleStreamEx intersperse(int delimiter) {
        return new DoubleStreamEx(((DoubleStream)this.stream()).flatMap((double s) -> DoubleStreamEx.of(delimiter, s)).skip(1L), this.context);
    }

    @Override
    public DoubleStreamEx distinct() {
        return new DoubleStreamEx(((DoubleStream)this.stream()).distinct(), this.context);
    }

    @Override
    public DoubleStreamEx sorted() {
        return new DoubleStreamEx(((DoubleStream)this.stream()).sorted(), this.context);
    }

    public DoubleStreamEx sorted(Comparator<Double> comparator) {
        return new DoubleStreamEx(((DoubleStream)this.stream()).boxed().sorted(comparator).mapToDouble(Double::doubleValue), this.context);
    }

    public DoubleStreamEx reverseSorted() {
        return new DoubleStreamEx(((DoubleStream)this.stream()).mapToLong(d -> {
            long l = Double.doubleToRawLongBits(d);
            return l ^ ((l >>> 63) - 1L | Long.MIN_VALUE);
        }).sorted().mapToDouble(l -> Double.longBitsToDouble(l ^ (-(l >>> 63) | Long.MIN_VALUE))), this.context);
    }

    public <V extends Comparable<? super V>> DoubleStreamEx sortedBy(DoubleFunction<V> keyExtractor) {
        return this.sorted(Comparator.comparing(keyExtractor::apply));
    }

    public DoubleStreamEx sortedByInt(DoubleToIntFunction keyExtractor) {
        return this.sorted(Comparator.comparingInt(keyExtractor::applyAsInt));
    }

    public DoubleStreamEx sortedByLong(DoubleToLongFunction keyExtractor) {
        return this.sorted(Comparator.comparingLong(keyExtractor::applyAsLong));
    }

    public DoubleStreamEx sortedByDouble(DoubleUnaryOperator keyExtractor) {
        return this.sorted(Comparator.comparingDouble(keyExtractor::applyAsDouble));
    }

    @Override
    public DoubleStreamEx peek(DoubleConsumer action) {
        return new DoubleStreamEx(((DoubleStream)this.stream()).peek(action), this.context);
    }

    public DoubleStreamEx peekFirst(DoubleConsumer action) {
        return this.mapFirst(x -> {
            action.accept(x);
            return x;
        });
    }

    public DoubleStreamEx peekLast(DoubleConsumer action) {
        return this.mapLast(x -> {
            action.accept(x);
            return x;
        });
    }

    @Override
    public DoubleStreamEx limit(long maxSize) {
        return new DoubleStreamEx(((DoubleStream)this.stream()).limit(maxSize), this.context);
    }

    @Override
    public DoubleStreamEx skip(long n) {
        return new DoubleStreamEx(((DoubleStream)this.stream()).skip(n), this.context);
    }

    @Override
    public void forEach(DoubleConsumer action) {
        if (this.spliterator != null && !this.isParallel()) {
            ((Spliterator.OfDouble)this.spliterator()).forEachRemaining(action);
        } else if (this.context.fjp != null) {
            this.context.terminate(() -> {
                ((DoubleStream)this.stream()).forEach(action);
                return null;
            });
        } else {
            ((DoubleStream)this.stream()).forEach(action);
        }
    }

    @Override
    public void forEachOrdered(DoubleConsumer action) {
        if (this.spliterator != null && !this.isParallel()) {
            ((Spliterator.OfDouble)this.spliterator()).forEachRemaining(action);
        } else if (this.context.fjp != null) {
            this.context.terminate(() -> {
                ((DoubleStream)this.stream()).forEachOrdered(action);
                return null;
            });
        } else {
            ((DoubleStream)this.stream()).forEachOrdered(action);
        }
    }

    @Override
    public double[] toArray() {
        if (this.context.fjp != null) {
            return this.context.terminate(((DoubleStream)this.stream())::toArray);
        }
        return ((DoubleStream)this.stream()).toArray();
    }

    public float[] toFloatArray() {
        Internals.FloatBuffer buf;
        if (this.isParallel()) {
            return this.collect(DoubleCollector.toFloatArray());
        }
        Spliterator.OfDouble spliterator = (Spliterator.OfDouble)this.spliterator();
        long size = spliterator.getExactSizeIfKnown();
        if (size >= 0L && size <= Integer.MAX_VALUE) {
            buf = new Internals.FloatBuffer((int)size);
            spliterator.forEachRemaining(buf::addUnsafe);
        } else {
            buf = new Internals.FloatBuffer();
            spliterator.forEachRemaining(buf::add);
        }
        return buf.toArray();
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator op) {
        if (this.context.fjp != null) {
            return this.context.terminate(() -> ((DoubleStream)this.stream()).reduce(identity, op));
        }
        return ((DoubleStream)this.stream()).reduce(identity, op);
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator op) {
        if (this.context.fjp != null) {
            return this.context.terminate(op, ((DoubleStream)this.stream())::reduce);
        }
        return ((DoubleStream)this.stream()).reduce(op);
    }

    public OptionalDouble foldLeft(DoubleBinaryOperator accumulator) {
        Internals.PrimitiveBox b = new Internals.PrimitiveBox();
        this.forEachOrdered(t -> {
            if (b.b) {
                b.d = accumulator.applyAsDouble(b.d, t);
            } else {
                b.d = t;
                b.b = true;
            }
        });
        return b.asDouble();
    }

    public double foldLeft(double seed, DoubleBinaryOperator accumulator) {
        double[] box = new double[]{seed};
        this.forEachOrdered(t -> {
            box[0] = accumulator.applyAsDouble(box[0], t);
        });
        return box[0];
    }

    public double[] scanLeft(DoubleBinaryOperator accumulator) {
        Spliterator.OfDouble spliterator = (Spliterator.OfDouble)this.spliterator();
        double size = spliterator.getExactSizeIfKnown();
        Internals.DoubleBuffer buf = new Internals.DoubleBuffer(size >= 0.0 && size <= 2.147483647E9 ? (int)size : 128);
        this.delegate(spliterator).forEachOrdered(i -> buf.add(buf.size == 0 ? i : accumulator.applyAsDouble(buf.data[buf.size - 1], i)));
        return buf.toArray();
    }

    public double[] scanLeft(double seed, DoubleBinaryOperator accumulator) {
        return this.prepend(seed).scanLeft(accumulator);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        if (this.context.fjp != null) {
            return (R)this.context.terminate(() -> ((DoubleStream)this.stream()).collect(supplier, accumulator, combiner));
        }
        return ((DoubleStream)this.stream()).collect(supplier, accumulator, combiner);
    }

    public <A, R> R collect(DoubleCollector<A, R> collector) {
        if (collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return (R)this.collect(collector.supplier(), collector.doubleAccumulator(), collector.merger());
        }
        return collector.finisher().apply(this.collect(collector.supplier(), collector.doubleAccumulator(), collector.merger()));
    }

    @Override
    public double sum() {
        if (this.context.fjp != null) {
            return this.context.terminate(((DoubleStream)this.stream())::sum);
        }
        return ((DoubleStream)this.stream()).sum();
    }

    @Override
    public OptionalDouble min() {
        return this.reduce(Math::min);
    }

    public OptionalDouble min(Comparator<Double> comparator) {
        return this.reduce((a, b) -> comparator.compare(a, b) > 0 ? b : a);
    }

    public <V extends Comparable<? super V>> OptionalDouble minBy(DoubleFunction<V> keyExtractor) {
        Internals.ObjDoubleBox result = this.collect(() -> new Internals.ObjDoubleBox<Object>(null, 0.0), (box, i) -> {
            Comparable val = Objects.requireNonNull((Comparable)keyExtractor.apply(i));
            if (box.a == null || ((Comparable)box.a).compareTo(val) > 0) {
                box.a = val;
                box.b = i;
            }
        }, (box1, box2) -> {
            if (box2.a != null && (box1.a == null || ((Comparable)box1.a).compareTo(box2.a) > 0)) {
                box1.a = box2.a;
                box1.b = box2.b;
            }
        });
        return result.a == null ? OptionalDouble.empty() : OptionalDouble.of(result.b);
    }

    public OptionalDouble minByInt(DoubleToIntFunction keyExtractor) {
        return this.collect(Internals.PrimitiveBox::new, (box, d) -> {
            int key = keyExtractor.applyAsInt(d);
            if (!box.b || box.i > key) {
                box.b = true;
                box.i = key;
                box.d = d;
            }
        }, Internals.PrimitiveBox.MIN_INT).asDouble();
    }

    public OptionalDouble minByLong(DoubleToLongFunction keyExtractor) {
        return this.collect(Internals.PrimitiveBox::new, (box, d) -> {
            long key = keyExtractor.applyAsLong(d);
            if (!box.b || box.l > key) {
                box.b = true;
                box.l = key;
                box.d = d;
            }
        }, Internals.PrimitiveBox.MIN_LONG).asDouble();
    }

    public OptionalDouble minByDouble(DoubleUnaryOperator keyExtractor) {
        double[] result = this.collect(() -> new double[3], (acc, d) -> {
            double key = keyExtractor.applyAsDouble(d);
            if (acc[2] == 0.0 || Double.compare(acc[1], key) > 0) {
                acc[0] = d;
                acc[1] = key;
                acc[2] = 1.0;
            }
        }, (acc1, acc2) -> {
            if (acc2[2] == 1.0 && (acc1[2] == 0.0 || Double.compare(acc1[1], acc2[1]) > 0)) {
                System.arraycopy(acc2, 0, acc1, 0, 3);
            }
        });
        return result[2] == 1.0 ? OptionalDouble.of(result[0]) : OptionalDouble.empty();
    }

    @Override
    public OptionalDouble max() {
        return this.reduce(Math::max);
    }

    public OptionalDouble max(Comparator<Double> comparator) {
        return this.reduce((a, b) -> comparator.compare(a, b) >= 0 ? a : b);
    }

    public <V extends Comparable<? super V>> OptionalDouble maxBy(DoubleFunction<V> keyExtractor) {
        Internals.ObjDoubleBox result = this.collect(() -> new Internals.ObjDoubleBox<Object>(null, 0.0), (box, i) -> {
            Comparable val = Objects.requireNonNull((Comparable)keyExtractor.apply(i));
            if (box.a == null || ((Comparable)box.a).compareTo(val) < 0) {
                box.a = val;
                box.b = i;
            }
        }, (box1, box2) -> {
            if (box2.a != null && (box1.a == null || ((Comparable)box1.a).compareTo(box2.a) < 0)) {
                box1.a = box2.a;
                box1.b = box2.b;
            }
        });
        return result.a == null ? OptionalDouble.empty() : OptionalDouble.of(result.b);
    }

    public OptionalDouble maxByInt(DoubleToIntFunction keyExtractor) {
        return this.collect(Internals.PrimitiveBox::new, (box, d) -> {
            int key = keyExtractor.applyAsInt(d);
            if (!box.b || box.i < key) {
                box.b = true;
                box.i = key;
                box.d = d;
            }
        }, Internals.PrimitiveBox.MAX_INT).asDouble();
    }

    public OptionalDouble maxByLong(DoubleToLongFunction keyExtractor) {
        return this.collect(Internals.PrimitiveBox::new, (box, d) -> {
            long key = keyExtractor.applyAsLong(d);
            if (!box.b || box.l < key) {
                box.b = true;
                box.l = key;
                box.d = d;
            }
        }, Internals.PrimitiveBox.MAX_LONG).asDouble();
    }

    public OptionalDouble maxByDouble(DoubleUnaryOperator keyExtractor) {
        double[] result = this.collect(() -> new double[3], (acc, d) -> {
            double key = keyExtractor.applyAsDouble(d);
            if (acc[2] == 0.0 || Double.compare(acc[1], key) < 0) {
                acc[0] = d;
                acc[1] = key;
                acc[2] = 1.0;
            }
        }, (acc1, acc2) -> {
            if (acc2[2] == 1.0 && (acc1[2] == 0.0 || Double.compare(acc1[1], acc2[1]) < 0)) {
                System.arraycopy(acc2, 0, acc1, 0, 3);
            }
        });
        return result[2] == 1.0 ? OptionalDouble.of(result[0]) : OptionalDouble.empty();
    }

    @Override
    public long count() {
        if (this.context.fjp != null) {
            return this.context.terminate(((DoubleStream)this.stream())::count);
        }
        return ((DoubleStream)this.stream()).count();
    }

    @Override
    public OptionalDouble average() {
        if (this.context.fjp != null) {
            return this.context.terminate(((DoubleStream)this.stream())::average);
        }
        return ((DoubleStream)this.stream()).average();
    }

    @Override
    public DoubleSummaryStatistics summaryStatistics() {
        return this.collect(DoubleSummaryStatistics::new, DoubleSummaryStatistics::accept, DoubleSummaryStatistics::combine);
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        if (this.context.fjp != null) {
            return this.context.terminate(predicate, ((DoubleStream)this.stream())::anyMatch);
        }
        return ((DoubleStream)this.stream()).anyMatch(predicate);
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        if (this.context.fjp != null) {
            return this.context.terminate(predicate, ((DoubleStream)this.stream())::allMatch);
        }
        return ((DoubleStream)this.stream()).allMatch(predicate);
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public OptionalDouble findFirst() {
        if (this.context.fjp != null) {
            return this.context.terminate(((DoubleStream)this.stream())::findFirst);
        }
        return ((DoubleStream)this.stream()).findFirst();
    }

    public OptionalDouble findFirst(DoublePredicate predicate) {
        return this.filter(predicate).findFirst();
    }

    @Override
    public OptionalDouble findAny() {
        if (this.context.fjp != null) {
            return this.context.terminate(((DoubleStream)this.stream())::findAny);
        }
        return ((DoubleStream)this.stream()).findAny();
    }

    public OptionalDouble findAny(DoublePredicate predicate) {
        return this.filter(predicate).findAny();
    }

    public OptionalLong indexOf(DoublePredicate predicate) {
        return ((AbstractStreamEx)this.boxed()).indexOf(predicate::test);
    }

    public StreamEx<Double> boxed() {
        return new StreamEx<Double>(((DoubleStream)this.stream()).boxed(), this.context);
    }

    @Override
    public DoubleStreamEx sequential() {
        return (DoubleStreamEx)super.sequential();
    }

    @Override
    public DoubleStreamEx parallel() {
        return (DoubleStreamEx)super.parallel();
    }

    @Override
    public DoubleStreamEx parallel(ForkJoinPool fjp) {
        return (DoubleStreamEx)super.parallel(fjp);
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        return Spliterators.iterator((Spliterator.OfDouble)this.spliterator());
    }

    public DoubleStreamEx append(double ... values) {
        if (values.length == 0) {
            return this;
        }
        return new DoubleStreamEx(DoubleStream.concat((DoubleStream)this.stream(), DoubleStream.of(values)), this.context);
    }

    public DoubleStreamEx append(DoubleStream other) {
        return new DoubleStreamEx(DoubleStream.concat((DoubleStream)this.stream(), other), this.context.combine(other));
    }

    public DoubleStreamEx prepend(double ... values) {
        if (values.length == 0) {
            return this;
        }
        return new DoubleStreamEx(DoubleStream.concat(DoubleStream.of(values), (DoubleStream)this.stream()), this.context);
    }

    public DoubleStreamEx prepend(DoubleStream other) {
        return new DoubleStreamEx(DoubleStream.concat(other, (DoubleStream)this.stream()), this.context.combine(other));
    }

    public DoubleStreamEx pairMap(DoubleBinaryOperator mapper) {
        return this.delegate(new PairSpliterator.PSOfDouble(mapper, null, (Spliterator.OfDouble)this.spliterator(), 0));
    }

    public String joining(CharSequence delimiter) {
        return this.collect(DoubleCollector.joining(delimiter));
    }

    public String joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.collect(DoubleCollector.joining(delimiter, prefix, suffix));
    }

    @Override
    public DoubleStreamEx takeWhile(DoublePredicate predicate) {
        return VerSpec.VER_SPEC.callWhile(this, Objects.requireNonNull(predicate), false);
    }

    public DoubleStreamEx takeWhileInclusive(DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        return this.delegate(new TakeDrop.TDOfDouble((Spliterator.OfDouble)this.spliterator(), false, true, predicate));
    }

    @Override
    public DoubleStreamEx dropWhile(DoublePredicate predicate) {
        return VerSpec.VER_SPEC.callWhile(this, Objects.requireNonNull(predicate), true);
    }

    public DoubleStreamEx prefix(DoubleBinaryOperator op) {
        return this.delegate(new PrefixOps.OfDouble((Spliterator.OfDouble)this.spliterator(), op));
    }

    @Override
    public <U> U chain(Function<? super DoubleStreamEx, U> mapper) {
        return mapper.apply(this);
    }

    public static DoubleStreamEx empty() {
        return DoubleStreamEx.of(Spliterators.emptyDoubleSpliterator());
    }

    public static DoubleStreamEx of(double element) {
        return DoubleStreamEx.of(new ConstSpliterator.OfDouble(element, 1L, true));
    }

    public static DoubleStreamEx of(double ... elements) {
        return DoubleStreamEx.of(Arrays.spliterator(elements));
    }

    public static DoubleStreamEx of(double[] array, int startInclusive, int endExclusive) {
        return DoubleStreamEx.of(Arrays.spliterator(array, startInclusive, endExclusive));
    }

    public static DoubleStreamEx of(Double[] array) {
        return DoubleStreamEx.seq(Arrays.stream(array).mapToDouble(Double::doubleValue));
    }

    public static DoubleStreamEx of(DoubleBuffer buf) {
        return IntStreamEx.range(buf.position(), buf.limit()).mapToDouble(buf::get);
    }

    public static DoubleStreamEx of(float ... elements) {
        return DoubleStreamEx.of(elements, 0, elements.length);
    }

    public static DoubleStreamEx of(float[] array, int startInclusive, int endExclusive) {
        Internals.rangeCheck(array.length, startInclusive, endExclusive);
        return DoubleStreamEx.of(new RangeBasedSpliterator.OfFloat(startInclusive, endExclusive, array));
    }

    public static DoubleStreamEx of(DoubleStream stream) {
        return stream instanceof DoubleStreamEx ? (DoubleStreamEx)stream : new DoubleStreamEx(stream, StreamContext.of(stream));
    }

    public static DoubleStreamEx of(Spliterator.OfDouble spliterator) {
        return new DoubleStreamEx(spliterator, StreamContext.SEQUENTIAL);
    }

    public static DoubleStreamEx of(PrimitiveIterator.OfDouble iterator) {
        return DoubleStreamEx.of(new UnknownSizeSpliterator.USOfDouble(iterator));
    }

    public static DoubleStreamEx of(OptionalDouble optional) {
        return optional.isPresent() ? DoubleStreamEx.of(optional.getAsDouble()) : DoubleStreamEx.empty();
    }

    public static DoubleStreamEx of(Collection<Double> collection) {
        return DoubleStreamEx.seq(collection.stream().mapToDouble(Double::doubleValue));
    }

    public static DoubleStreamEx of(Random random) {
        return DoubleStreamEx.seq(random.doubles());
    }

    public static DoubleStreamEx of(Random random, long streamSize) {
        return DoubleStreamEx.seq(random.doubles(streamSize));
    }

    public static DoubleStreamEx of(Random random, double randomNumberOrigin, double randomNumberBound) {
        return DoubleStreamEx.seq(random.doubles(randomNumberOrigin, randomNumberBound));
    }

    public static DoubleStreamEx of(Random random, long streamSize, double randomNumberOrigin, double randomNumberBound) {
        return DoubleStreamEx.seq(random.doubles(streamSize, randomNumberOrigin, randomNumberBound));
    }

    public static DoubleStreamEx iterate(double seed, DoubleUnaryOperator f) {
        return DoubleStreamEx.iterate(seed, x -> true, f);
    }

    public static DoubleStreamEx iterate(final double seed, final DoublePredicate predicate, final DoubleUnaryOperator f) {
        Objects.requireNonNull(f);
        Objects.requireNonNull(predicate);
        Spliterators.AbstractDoubleSpliterator spliterator = new Spliterators.AbstractDoubleSpliterator(Long.MAX_VALUE, 1296){
            double prev;
            boolean started;
            boolean finished;

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                double t;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return false;
                }
                if (this.started) {
                    t = f.applyAsDouble(this.prev);
                } else {
                    t = seed;
                    this.started = true;
                }
                if (!predicate.test(t)) {
                    this.finished = true;
                    return false;
                }
                this.prev = t;
                action.accept(this.prev);
                return true;
            }

            @Override
            public void forEachRemaining(DoubleConsumer action) {
                double t;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return;
                }
                this.finished = true;
                double d = t = this.started ? f.applyAsDouble(this.prev) : seed;
                while (predicate.test(t)) {
                    action.accept(t);
                    t = f.applyAsDouble(t);
                }
            }
        };
        return DoubleStreamEx.of(spliterator);
    }

    public static DoubleStreamEx generate(DoubleSupplier s) {
        return DoubleStreamEx.seq(DoubleStream.generate(s));
    }

    public static DoubleStreamEx produce(Predicate<DoubleConsumer> producer) {
        Internals.Box box = new Internals.Box();
        box.a = action -> producer.test(action) ? (DoubleEmitter)box.a : null;
        return box.a.stream();
    }

    public static DoubleStreamEx constant(double value, long length) {
        return DoubleStreamEx.of(new ConstSpliterator.OfDouble(value, length, false));
    }

    public static DoubleStreamEx zip(double[] first, double[] second, DoubleBinaryOperator mapper) {
        return DoubleStreamEx.of(new RangeBasedSpliterator.ZipDouble(0, Internals.checkLength(first.length, second.length), mapper, first, second));
    }

    @FunctionalInterface
    public static interface DoubleEmitter {
        public DoubleEmitter next(DoubleConsumer var1);

        default public Spliterator.OfDouble spliterator() {
            return new EmitterSpliterator.OfDouble(this);
        }

        default public DoubleStreamEx stream() {
            return DoubleStreamEx.of(this.spliterator());
        }
    }
}

