/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.chrome;

import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.chrome.ChromeSettingsConfigurable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XMap;
import gnu.trove.THashMap;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChromeSettings
extends BrowserSpecificSettings {
    public static final String USER_DATA_DIR_ARG = "--user-data-dir=";
    public static final String NO_FIRST_RUN_ARG = "--no-first-run";
    public static final String NO_DEFAULT_BROWSER_CHECK_ARG = "--no-default-browser-check";
    public static final String DISABLE_FIRST_RUN_EXPERIENCE_ARG = "--disable-fre";
    @Nullable
    private String myCommandLineOptions;
    @Nullable
    private String myUserDataDirectoryPath;
    private boolean myUseCustomProfile;
    @NotNull
    private Map<String, String> myEnvironmentVariables = new THashMap();

    @Tag(value="user-data-dir")
    @Nullable
    public String getUserDataDirectoryPath() {
        return this.myUserDataDirectoryPath;
    }

    @Tag(value="use-custom-profile")
    public boolean isUseCustomProfile() {
        return this.myUseCustomProfile;
    }

    @Tag(value="command-line-options")
    @Nullable
    public String getCommandLineOptions() {
        return this.myCommandLineOptions;
    }

    public void setCommandLineOptions(@Nullable String value) {
        this.myCommandLineOptions = StringUtil.nullize((String)value);
    }

    public void setUserDataDirectoryPath(@Nullable String value) {
        this.myUserDataDirectoryPath = PathUtil.toSystemIndependentName(StringUtil.nullize((String)value));
    }

    public void setUseCustomProfile(boolean useCustomProfile) {
        this.myUseCustomProfile = useCustomProfile;
    }

    @Override
    @NotNull
    public List<String> getAdditionalParameters() {
        if (this.myCommandLineOptions == null) {
            if (this.myUseCustomProfile && this.myUserDataDirectoryPath != null) {
                List<CallSite> list = Collections.singletonList(USER_DATA_DIR_ARG + FileUtilRt.toSystemDependentName((String)this.myUserDataDirectoryPath));
                if (list == null) {
                    ChromeSettings.$$$reportNull$$$0(0);
                }
                return list;
            }
            List<String> list = Collections.emptyList();
            if (list == null) {
                ChromeSettings.$$$reportNull$$$0(1);
            }
            return list;
        }
        List cliOptions = ParametersListUtil.parse((String)this.myCommandLineOptions);
        if (this.myUseCustomProfile && this.myUserDataDirectoryPath != null) {
            cliOptions.add(USER_DATA_DIR_ARG + FileUtilRt.toSystemDependentName((String)this.myUserDataDirectoryPath));
        }
        List list = cliOptions;
        if (list == null) {
            ChromeSettings.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @XMap(propertyElementName="environment-variables")
    @NotNull
    public Map<String, String> getEnvironmentVariables() {
        Map<String, String> map = this.myEnvironmentVariables;
        if (map == null) {
            ChromeSettings.$$$reportNull$$$0(3);
        }
        return map;
    }

    public void setEnvironmentVariables(@NotNull Map<String, String> environmentVariables) {
        if (environmentVariables == null) {
            ChromeSettings.$$$reportNull$$$0(4);
        }
        this.myEnvironmentVariables = environmentVariables;
    }

    @Override
    @NotNull
    public ChromeSettingsConfigurable createConfigurable() {
        return new ChromeSettingsConfigurable(this);
    }

    @Override
    public ChromeSettings clone() {
        ChromeSettings clone = (ChromeSettings)super.clone();
        clone.myEnvironmentVariables = new THashMap(this.myEnvironmentVariables);
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChromeSettings settings = (ChromeSettings)o;
        return this.myUseCustomProfile == settings.myUseCustomProfile && Objects.equals(this.myCommandLineOptions, settings.myCommandLineOptions) && (!this.myUseCustomProfile || Objects.equals(this.myUserDataDirectoryPath, settings.myUserDataDirectoryPath)) && this.myEnvironmentVariables.equals(settings.myEnvironmentVariables);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/browsers/chrome/ChromeSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalParameters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentVariables";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/browsers/chrome/ChromeSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setEnvironmentVariables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

