/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class ServiceDescriptor {
    @Attribute
    public String serviceInterface;
    @Attribute
    @RequiredElement
    public String serviceImplementation;
    @Attribute
    public String testServiceImplementation;
    @Attribute
    public String headlessImplementation;
    @Attribute
    public boolean overrides;
    @Attribute
    @Nullable
    public String configurationSchemaKey;
    @Attribute
    @ApiStatus.Internal
    public PreloadMode preload = PreloadMode.FALSE;

    public String getInterface() {
        return this.serviceInterface != null ? this.serviceInterface : this.getImplementation();
    }

    @Nullable
    public String getImplementation() {
        if (this.testServiceImplementation != null && ApplicationManager.getApplication().isUnitTestMode()) {
            return this.testServiceImplementation;
        }
        if (this.headlessImplementation != null && ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return this.headlessImplementation;
        }
        return this.serviceImplementation;
    }

    public String toString() {
        return "ServiceDescriptor(interface=" + this.getInterface() + ", implementation=" + this.getImplementation() + ")";
    }

    public static enum PreloadMode {
        TRUE,
        FALSE,
        AWAIT,
        NOT_HEADLESS,
        NOT_LIGHT_EDIT;

    }
}

