/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.hover;

import com.intellij.openapi.util.Key;
import com.intellij.ui.hover.HoverListener;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToIntFunction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public abstract class TreeHoverListener
extends HoverListener {
    private final AtomicInteger rowHolder = new AtomicInteger(-1);
    private static final Key<Integer> HOVERED_ROW_KEY = Key.create((String)"TreeHoveredRow");
    public static final HoverListener DEFAULT = new TreeHoverListener(){

        @Override
        public void onHover(@NotNull JTree tree, int row) {
            if (tree == null) {
                1.$$$reportNull$$$0(0);
            }
            1.setHoveredRow(tree, row);
            Object property = tree.getClientProperty(RenderingUtil.FOCUSABLE_SIBLING);
            if (property instanceof JTable) {
                TableHoverListener.setHoveredRow((JTable)property, row);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ui/hover/TreeHoverListener$1", "onHover"));
        }
    };

    public abstract void onHover(@NotNull JTree var1, int var2);

    @Override
    public final void mouseEntered(@NotNull Component component, int x, int y) {
        if (component == null) {
            TreeHoverListener.$$$reportNull$$$0(0);
        }
        this.mouseMoved(component, x, y);
    }

    @Override
    public final void mouseMoved(@NotNull Component component, int x, int y) {
        if (component == null) {
            TreeHoverListener.$$$reportNull$$$0(1);
        }
        this.update(component, tree -> TreeUtil.getRowForLocation(tree, x, y));
    }

    @Override
    public final void mouseExited(@NotNull Component component) {
        if (component == null) {
            TreeHoverListener.$$$reportNull$$$0(2);
        }
        this.update(component, tree -> -1);
    }

    private void update(@NotNull Component component, @NotNull ToIntFunction<JTree> rowFunc) {
        int rowOld;
        JTree tree;
        int rowNew;
        if (component == null) {
            TreeHoverListener.$$$reportNull$$$0(3);
        }
        if (rowFunc == null) {
            TreeHoverListener.$$$reportNull$$$0(4);
        }
        if (component instanceof JTree && (rowNew = rowFunc.applyAsInt(tree = (JTree)component)) != (rowOld = this.rowHolder.getAndSet(rowNew))) {
            this.onHover(tree, rowNew);
        }
    }

    @ApiStatus.Internal
    static void setHoveredRow(@NotNull JTree tree, int rowNew) {
        int rowOld;
        if (tree == null) {
            TreeHoverListener.$$$reportNull$$$0(5);
        }
        if (rowNew == (rowOld = TreeHoverListener.getHoveredRow(tree))) {
            return;
        }
        tree.putClientProperty(HOVERED_ROW_KEY, rowNew < 0 ? null : Integer.valueOf(rowNew));
        if (RenderingUtil.isHoverPaintingDisabled((JComponent)tree)) {
            return;
        }
        TreeUtil.repaintRow(tree, rowOld);
        TreeUtil.repaintRow(tree, rowNew);
    }

    public static int getHoveredRow(@NotNull JTree tree) {
        Object property;
        if (tree == null) {
            TreeHoverListener.$$$reportNull$$$0(6);
        }
        return (property = tree.getClientProperty(HOVERED_ROW_KEY)) instanceof Integer ? (Integer)property : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowFunc";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/hover/TreeHoverListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseEntered";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseMoved";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseExited";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setHoveredRow";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getHoveredRow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

