/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class AnimatedIcon
extends JComponent
implements Disposable {
    private final Icon[] myIcons;
    private final Dimension myPrefSize;
    private int myCurrentIconIndex;
    protected final Icon myPassiveIcon;
    private final Icon myEmptyPassiveIcon;
    private boolean myPaintPassive = true;
    private boolean myRunning = true;
    protected final Animator myAnimator;
    private final String myName;

    public AnimatedIcon(@NonNls String name, Icon[] icons, Icon passiveIcon, int cycleLength) {
        Icon[] iconArray;
        this.myName = name;
        if (icons.length == 0) {
            Icon[] iconArray2 = new Icon[1];
            iconArray = iconArray2;
            iconArray2[0] = passiveIcon;
        } else {
            iconArray = icons;
        }
        this.myIcons = iconArray;
        this.myPassiveIcon = passiveIcon;
        this.myPrefSize = this.calcPreferredSize();
        this.myAnimator = new Animator(this.myName, icons.length, cycleLength, true){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                int len = AnimatedIcon.this.myIcons.length;
                AnimatedIcon.this.myCurrentIconIndex = frame < 0 ? 0 : (frame >= len ? len - 1 : frame);
                AnimatedIcon.this.paintImmediately(0, 0, AnimatedIcon.this.getWidth(), AnimatedIcon.this.getHeight());
            }
        };
        this.myEmptyPassiveIcon = icons.length > 0 ? EmptyIcon.create((Icon)icons[0]) : EmptyIcon.ICON_0;
        this.setOpaque(false);
        new UiNotifyConnector(this, new Activatable(){

            @Override
            public void showNotify() {
                if (AnimatedIcon.this.myRunning) {
                    AnimatedIcon.this.ensureAnimation(true);
                }
            }

            @Override
            public void hideNotify() {
                AnimatedIcon.this.ensureAnimation(false);
            }
        });
    }

    protected Dimension calcPreferredSize() {
        Dimension dimension = new Dimension();
        for (Icon each : this.myIcons) {
            dimension.width = Math.max(each.getIconWidth(), dimension.width);
            dimension.height = Math.max(each.getIconHeight(), dimension.height);
        }
        return new Dimension(Math.max(this.myPassiveIcon.getIconWidth(), dimension.width), Math.max(this.myPassiveIcon.getIconHeight(), dimension.height));
    }

    public void setPaintPassiveIcon(boolean paintPassive) {
        this.myPaintPassive = paintPassive;
    }

    private boolean ensureAnimation(boolean running) {
        boolean changes;
        boolean bl = changes = this.myAnimator.isRunning() != running;
        if (running) {
            this.myAnimator.resume();
        } else {
            this.myAnimator.suspend();
        }
        return changes;
    }

    public void resume() {
        this.myRunning = true;
        this.ensureAnimation(true);
    }

    public void suspend() {
        this.myRunning = false;
        if (this.ensureAnimation(false)) {
            this.repaint();
        }
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myAnimator);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.myPrefSize.width + insets.left + insets.right, this.myPrefSize.height + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            Container parent = this.getParent();
            JComponent opaque = null;
            if (parent instanceof JComponent) {
                opaque = (JComponent)UIUtil.findNearestOpaque((Component)parent);
            }
            Color bg = opaque != null ? opaque.getBackground() : UIUtil.getPanelBackground();
            g.setColor(bg);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Icon icon = this.myAnimator.isRunning() ? this.myIcons[this.myCurrentIconIndex] : this.getPassiveIcon();
        Dimension size = this.getSize();
        int x = (size.width - icon.getIconWidth()) / 2;
        int y = (size.height - icon.getIconHeight()) / 2;
        this.paintIcon(g, icon, x, y);
    }

    protected void paintIcon(Graphics g, Icon icon, int x, int y) {
        icon.paintIcon(this, g, x, y);
    }

    protected Icon getPassiveIcon() {
        return this.myPaintPassive ? this.myPassiveIcon : this.myEmptyPassiveIcon;
    }

    public boolean isRunning() {
        return this.myAnimator.isRunning();
    }

    @Override
    public String toString() {
        return this.myName + " isRunning=" + this.myRunning + " isOpaque=" + this.isOpaque() + " paintPassive=" + this.myPaintPassive;
    }
}

