/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction;

import com.intellij.filePrediction.FilePredictionEventFieldEncoder$WhenMappings;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n\u00a8\u0006\u000e"}, d2={"Lcom/intellij/filePrediction/FilePredictionEventFieldEncoder;", "", "()V", "encodeBool", "", "value", "", "encodeDouble", "", "encodeFileType", "", "isFileTypeValid", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "feature", "intellij.filePrediction"})
public final class FilePredictionEventFieldEncoder {
    public static final FilePredictionEventFieldEncoder INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final double encodeDouble(double value) {
        double d = value;
        boolean bl = false;
        double d2 = d;
        boolean bl2 = false;
        if (Double.isInfinite(d2)) return -1.0;
        d2 = d;
        bl2 = false;
        if (Double.isNaN(d2)) return -1.0;
        boolean bl3 = true;
        if (!bl3) {
            return -1.0;
        }
        d = value * (double)100000;
        return Math.rint(d) / (double)100000;
    }

    public final int encodeBool(boolean value) {
        return value ? 1 : 0;
    }

    @NotNull
    public final String encodeFileType(@NotNull String value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (FilePredictionEventFieldEncoder$WhenMappings.$EnumSwitchMapping$0[this.isFileTypeValid(value).ordinal()]) {
            case 1: {
                string = value;
                break;
            }
            case 2: {
                string = ValidationResultType.THIRD_PARTY.toString();
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    @NotNull
    public final ValidationResultType isFileTypeValid(@NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        FileType fileType = FileTypeManager.getInstance().findFileTypeByName(feature);
        if (fileType == null || !StringUtil.equals((CharSequence)fileType.getName(), (CharSequence)feature)) {
            return ValidationResultType.REJECTED;
        }
        boolean isByJB = PluginInfoDetectorKt.getPluginInfo(fileType.getClass()).isDevelopedByJetBrains();
        return isByJB ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
    }

    private FilePredictionEventFieldEncoder() {
    }

    static {
        FilePredictionEventFieldEncoder filePredictionEventFieldEncoder;
        INSTANCE = filePredictionEventFieldEncoder = new FilePredictionEventFieldEncoder();
    }
}

