/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.generator;

import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.xerces.xs.XSObject;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.devkit.dom.generator.FieldDesc;

public class Util {
    @NonNls
    public static final String ANONYMOUS_ELEM_TYPE_SUFFIX = "ElemType";
    @NonNls
    public static final String ANONYMOUS_ATTR_TYPE_SUFFIX = "AttrType";
    @NonNls
    public static final String TYPE_SUFFIX = "Type";
    @NonNls
    public static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    @NonNls
    public static final String[] RESERVED_NAMES_TABLE = new String[]{"abstract", "default", "if", "private", "this", "boolean", "do", "implements", "protected", "throw", "break", "double", "import", "public", "throws", "byte", "else", "instanceof", "return", "transient", "case", "extends", "int", "short", "try", "catch", "final", "interface", "static", "void", "char", "finally", "long", "strictfp", "volatile", "class", "float", "native", "super", "while", "const", "for", "new", "switch", "continue", "goto", "package", "synchronized"};
    public static final HashMap<String, String> RESERVED_NAMES_MAP = new HashMap();

    static void log(@NonNls String str) {
        System.out.println(str);
    }

    static void logwarn(@NonNls String str) {
        System.out.println("[warn] " + str);
    }

    static void logerr(@NonNls String str) {
        System.out.println("[error] " + str);
    }

    public static String pluralize(String suggestion) {
        String VOWELS = "aeiouy";
        if (((String)suggestion).endsWith("s") || ((String)suggestion).endsWith("x") || ((String)suggestion).endsWith("ch")) {
            suggestion = (String)suggestion + "es";
        } else {
            int len = ((String)suggestion).length();
            suggestion = ((String)suggestion).endsWith("y") && len > 1 && "aeiouy".indexOf(((String)suggestion).charAt(len - 2)) < 0 ? ((String)suggestion).substring(0, len - 1) + "ies" : (String)suggestion + "s";
        }
        return suggestion;
    }

    public static String toJavaFieldName(String xmlName) {
        String rc = Util.toJavaName(xmlName);
        if (RESERVED_NAMES_MAP.containsKey(rc)) {
            rc = RESERVED_NAMES_MAP.get(rc);
        }
        return rc;
    }

    public static String computeEnumConstantName(String val, String typeName) {
        Object id = val;
        for (int i = 1; i < ((String)id).length(); ++i) {
            if (!Character.isUpperCase(((String)id).charAt(i)) || !Character.isLowerCase(((String)id).charAt(i - 1))) continue;
            id = ((String)id).substring(0, i) + "_" + ((String)id).substring(i);
            ++i;
        }
        id = StringUtil.toUpperCase((String)id);
        if (((String)(id = ((String)id).replace('.', '_').replace('-', '_'))).length() < 2 || !Character.isJavaIdentifierStart(((String)id).charAt(0))) {
            id = typeName + "_" + (String)id;
        }
        return id;
    }

    public static String capitalize(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String decapitalize(String str) {
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static String toJavaName(String xmlName) {
        xmlName = xmlName.substring(xmlName.lastIndexOf(58) + 1);
        StringTokenizer st = new StringTokenizer(xmlName, "-");
        StringBuilder sb = new StringBuilder(st.nextToken());
        while (st.hasMoreTokens()) {
            sb.append(Util.capitalize(st.nextToken()));
        }
        return sb.toString();
    }

    public static String toDefXmlTagName(XSObject xs) {
        String xmlName = xs.getName();
        if (xmlName.endsWith(TYPE_SUFFIX)) {
            xmlName = xmlName.substring(0, xmlName.length() - 4);
        }
        return xmlName;
    }

    public static String toDefXmlTagName(String tname) {
        String xmlName = tname;
        xmlName = StringUtil.trimEnd((String)xmlName, (String)TYPE_SUFFIX);
        return xmlName;
    }

    public static boolean addToNameMap(Map<String, FieldDesc> fdMap, FieldDesc fd1, boolean merge) {
        boolean duplicates = false;
        FieldDesc fd2 = fdMap.remove(fd1.name);
        if (fd2 != null) {
            if (fd2.clType == 4) {
                fd2.name = fd1.name + "Attr";
                fdMap.put(fd2.name, fd2);
            } else {
                if (merge) {
                    fdMap.put(fd2.name, fd2);
                    return false;
                }
                duplicates = true;
                fd2.name = fd1.name + "1";
                fd2.duplicateIndex = 1;
                fdMap.put(fd2.name, fd2);
                fd1.name = fd1.name + "2";
                fd1.duplicateIndex = 2;
            }
        } else {
            fd2 = fdMap.get(fd1.name + "1");
            if (fd2 != null) {
                int id = 2;
                while (fdMap.containsKey(fd1.name + id)) {
                    ++id;
                }
                fd1.name = fd1.name + id;
                fd1.duplicateIndex = id;
            }
        }
        fdMap.put(fd1.name, fd1);
        return duplicates;
    }

    public static String expandProperties(String str, Map<String, String> map) {
        if (!str.contains("${")) {
            return str;
        }
        int state = 0;
        StringBuilder result = new StringBuilder();
        StringBuilder variable = new StringBuilder();
        block5: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (state) {
                case 0: {
                    if (ch == '$') {
                        state = 1;
                        continue block5;
                    }
                    result.append(ch);
                    continue block5;
                }
                case 1: {
                    if (ch == '{') {
                        state = 2;
                        variable.setLength(0);
                        continue block5;
                    }
                    state = 0;
                    result.append('$').append(ch);
                    continue block5;
                }
                case 2: {
                    if (ch == '}') {
                        String value = map.get(variable.toString());
                        result.append(value == null ? variable : value);
                        state = 0;
                        continue block5;
                    }
                    variable.append(ch);
                }
            }
        }
        return result.toString();
    }

    static {
        for (String aRESERVED_NAMES_TABLE : RESERVED_NAMES_TABLE) {
            RESERVED_NAMES_MAP.put(aRESERVED_NAMES_TABLE, aRESERVED_NAMES_TABLE);
        }
    }
}

