/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class UseVirtualFileEqualsInspection
extends DevKitUastInspectionBase {
    @Override
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UseVirtualFileEqualsInspection.$$$reportNull$$$0(0);
        }
        return UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                UseVirtualFileEqualsInspection.inspectBinaryExpression(node, holder);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/idea/devkit/inspections/internal/UseVirtualFileEqualsInspection$1", "visitBinaryExpression"));
            }
        }, (Class[])new Class[]{UBinaryExpression.class});
    }

    private static void inspectBinaryExpression(@NotNull UBinaryExpression uBinaryExpression, ProblemsHolder holder) {
        UastBinaryOperator operator;
        if (uBinaryExpression == null) {
            UseVirtualFileEqualsInspection.$$$reportNull$$$0(1);
        }
        if ((operator = uBinaryExpression.getOperator()) != UastBinaryOperator.IDENTITY_EQUALS && operator != UastBinaryOperator.IDENTITY_NOT_EQUALS) {
            return;
        }
        UExpression lhs = uBinaryExpression.getLeftOperand();
        UExpression rhs = uBinaryExpression.getRightOperand();
        if (lhs instanceof ULiteralExpression || rhs instanceof ULiteralExpression || lhs instanceof UThisExpression || rhs instanceof UThisExpression) {
            return;
        }
        if (InheritanceUtil.isInheritor((PsiType)lhs.getExpressionType(), (String)VirtualFile.class.getName()) || InheritanceUtil.isInheritor((PsiType)rhs.getExpressionType(), (String)VirtualFile.class.getName())) {
            PsiElement sourcePsi = uBinaryExpression.getSourcePsi();
            if (sourcePsi == null) {
                return;
            }
            holder.registerProblem(sourcePsi, DevKitBundle.message("inspections.use.virtual.file.equals", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uBinaryExpression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UseVirtualFileEqualsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildInternalVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "inspectBinaryExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

