/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.internal;

import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ApplicationComponents;
import org.jetbrains.idea.devkit.dom.Component;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.ModuleComponents;
import org.jetbrains.idea.devkit.dom.ProjectComponents;
import org.jetbrains.idea.devkit.internal.AnalyzeUnloadablePluginsAction;
import org.jetbrains.idea.devkit.internal.PluginUnloadabilityStatus;
import org.jetbrains.idea.devkit.internal.UnloadabilityStatus;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J^\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/idea/devkit/internal/AnalyzeUnloadablePluginsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "analyzePluginFile", "ideaPlugin", "Lorg/jetbrains/idea/devkit/dom/IdeaPlugin;", "analysisErrors", "", "", "components", "nonDynamicEPs", "", "unspecifiedDynamicEPs", "serviceOverrides", "allowOwnEPs", "", "analyzeUnloadable", "Lorg/jetbrains/idea/devkit/internal/PluginUnloadabilityStatus;", "allPlugins", "", "Lcom/intellij/psi/xml/XmlFile;", "resolvePluginDependency", "dependency", "Lorg/jetbrains/idea/devkit/dom/Dependency;", "showReport", "project", "Lcom/intellij/openapi/project/Project;", "result", "intellij.devkit"})
public final class AnalyzeUnloadablePluginsAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        IdeView view;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        IdeView ideView = view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        PsiDirectory dir = ideView != null ? ideView.getOrChooseDirectory() : null;
        boolean bl = false;
        List result = new ArrayList();
        ProgressManager progressManager = ProgressManager.getInstance();
        Runnable runnable = new Runnable(this, dir, project2, result){
            final /* synthetic */ AnalyzeUnloadablePluginsAction this$0;
            final /* synthetic */ PsiDirectory $dir;
            final /* synthetic */ Project $project;
            final /* synthetic */ List $result;

            public final void run() {
                boolean $i$f$runReadAction = false;
                ApplicationManager.getApplication().runReadAction((Computable)new Computable<T>(this){
                    final /* synthetic */ actionPerformed.show.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final T compute() {
                        void $this$filterIsInstanceTo$iv$iv;
                        PsiFile[] psiFileArray;
                        ProgressIndicator pi;
                        boolean bl = false;
                        ProgressManager progressManager = ProgressManager.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                        ProgressIndicator progressIndicator = pi = progressManager.getProgressIndicator();
                        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"pi");
                        progressIndicator.setIndeterminate(false);
                        PsiDirectory psiDirectory = this.this$0.$dir;
                        GlobalSearchScope globalSearchScope = psiDirectory == null ? GlobalSearchScopesCore.projectProductionScope((Project)this.this$0.$project) : GlobalSearchScopesCore.directoryScope((PsiDirectory)this.this$0.$dir, (boolean)true);
                        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"when (dir) {\n           \u2026pe(dir, true)\n          }");
                        GlobalSearchScope searchScope = globalSearchScope;
                        PsiFile[] psiFileArray2 = FilenameIndex.getFilesByName((Project)this.this$0.$project, (String)"plugin.xml", (GlobalSearchScope)searchScope);
                        boolean bl2 = false;
                        Object object = psiFileArray2;
                        boolean bl3 = false;
                        if (((PsiFile[])object).length == 0) {
                            boolean bl4 = false;
                            psiFileArray = FilenameIndex.getFilesByName((Project)this.this$0.$project, (String)"plugin.xml", (GlobalSearchScope)GlobalSearchScopesCore.projectProductionScope((Project)this.this$0.$project));
                        } else {
                            psiFileArray = psiFileArray2;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"FilenameIndex.getFilesBy\u2026oductionScope(project)) }");
                        Object[] $this$filterIsInstance$iv22 = psiFileArray;
                        boolean $i$f$filterIsInstance = false;
                        object = $this$filterIsInstance$iv22;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof XmlFile)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List pluginXmlFiles = (List)destination$iv$iv;
                        boolean $this$filterIsInstance$iv22 = false;
                        for (XmlFile pluginXmlFile : (Iterable)pluginXmlFiles) {
                            void processed;
                            pi.checkCanceled();
                            pi.setFraction((double)processed / (double)pluginXmlFiles.size());
                            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.this$0.$project);
                            Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                            if (projectRootManager.getFileIndex().isUnderSourceRootOfType(pluginXmlFile.getVirtualFile(), JavaModuleSourceRootTypes.PRODUCTION)) {
                                if (DescriptorUtil.getIdeaPlugin(pluginXmlFile) == null) {
                                } else {
                                    IdeaPlugin ideaPlugin;
                                    Intrinsics.checkNotNullExpressionValue((Object)ideaPlugin, (String)"DescriptorUtil.getIdeaPl\u2026luginXmlFile) ?: continue");
                                    GenericAttributeValue<Boolean> genericAttributeValue = ideaPlugin.getRequireRestart();
                                    Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"ideaPlugin.requireRestart");
                                    if (!Intrinsics.areEqual((Object)((Boolean)genericAttributeValue.getValue()), (Object)true)) {
                                        PluginUnloadabilityStatus status = AnalyzeUnloadablePluginsAction.access$analyzeUnloadable(this.this$0.this$0, ideaPlugin, pluginXmlFiles);
                                        this.this$0.$result.add(status);
                                        pi.setText(status.getPluginId());
                                    }
                                }
                            }
                            ++processed;
                        }
                        return (T)Unit.INSTANCE;
                    }
                });
            }
            {
                this.this$0 = analyzeUnloadablePluginsAction;
                this.$dir = psiDirectory;
                this.$project = project;
                this.$result = list;
            }
        };
        Object[] objectArray = new Object[1];
        Object object = dir;
        if (object == null || (object = object.getName()) == null) {
            object = "Project";
        }
        objectArray[0] = object;
        boolean show2 = progressManager.runProcessWithProgressSynchronously(runnable, DevKitBundle.message("action.AnalyzeUnloadablePlugins.progress.title", objectArray), true, e.getProject());
        if (show2) {
            this.showReport(project2, result);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showReport(Project project, List<PluginUnloadabilityStatus> result) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv32222;
        boolean bl;
        void $this$filterTo$iv$iv42222;
        void $this$filterTo$iv$iv52222;
        void $this$filterTo$iv$iv8222;
        void $this$filterTo$iv$iv62222;
        Object it;
        boolean bl2;
        Object $this$any$iv;
        StringBuilder $this$buildString;
        StringBuilder stringBuilder;
        block32: {
            boolean bl3 = false;
            boolean bl4 = false;
            stringBuilder = new StringBuilder();
            boolean bl5 = false;
            boolean bl6 = false;
            $this$buildString = stringBuilder;
            boolean bl7 = false;
            $this$any$iv = result;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    it = (PluginUnloadabilityStatus)element$iv;
                    boolean bl8 = false;
                    Collection collection = ((PluginUnloadabilityStatus)it).getAnalysisErrors();
                    boolean bl9 = false;
                    if (!(!collection.isEmpty())) continue;
                    bl2 = true;
                    break block32;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            void $this$filterTo$iv$iv72222;
            $this$any$iv = $this$buildString;
            String $i$f$any = "Analysis errors:";
            boolean bl10 = false;
            StringBuilder stringBuilder2 = ((StringBuilder)$this$any$iv).append($i$f$any);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder2);
            Object $this$filter$iv = result;
            boolean $i$f$filter222 = false;
            it = $this$filter$iv;
            Collection destination$iv$iv22 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object t : $this$filterTo$iv$iv72222) {
                PluginUnloadabilityStatus it2 = (PluginUnloadabilityStatus)t;
                boolean bl11 = false;
                Collection collection = it2.getAnalysisErrors();
                boolean bl3 = false;
                if (!(!collection.isEmpty())) continue;
                destination$iv$iv22.add(t);
            }
            for (PluginUnloadabilityStatus status : (List)destination$iv$iv22) {
                $this$filter$iv = $this$buildString;
                String $i$f$filter222 = status.getPluginId();
                boolean $this$filterTo$iv$iv72222 = false;
                StringBuilder stringBuilder3 = ((StringBuilder)$this$filter$iv).append($i$f$filter222);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder3);
                for (String analysisError : status.getAnalysisErrors()) {
                    StringBuilder $this$filterTo$iv$iv72222 = $this$buildString;
                    boolean destination$iv$iv22 = false;
                    StringBuilder stringBuilder4 = $this$filterTo$iv$iv72222.append(analysisError);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder4);
                }
                StringsKt.appendln((StringBuilder)$this$buildString);
            }
        }
        Object $this$filter$iv = result;
        boolean $i$f$filter242 = false;
        Iterable $i$f$filter222 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv62222) {
            PluginUnloadabilityStatus pluginUnloadabilityStatus = (PluginUnloadabilityStatus)element$iv$iv;
            boolean bl13 = false;
            if (!(pluginUnloadabilityStatus.getStatus() == UnloadabilityStatus.UNLOADABLE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unloadablePlugins = (List)destination$iv$iv;
        $this$filter$iv = $this$buildString;
        String $i$f$filter242 = "Can unload " + unloadablePlugins.size() + " plugins out of " + result.size();
        boolean $this$filterTo$iv$iv62222 = false;
        StringBuilder stringBuilder5 = ((StringBuilder)$this$filter$iv).append($i$f$filter242);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder5);
        for (PluginUnloadabilityStatus status : unloadablePlugins) {
            StringBuilder $this$filterTo$iv$iv62222 = $this$buildString;
            destination$iv$iv = status.getPluginId();
            $i$f$filterTo = false;
            StringBuilder stringBuilder6 = $this$filterTo$iv$iv62222.append((String)destination$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder6);
        }
        StringsKt.appendln((StringBuilder)$this$buildString);
        Iterable $this$filter$iv2 = result;
        boolean $i$f$filter3 = false;
        destination$iv$iv = $this$filter$iv2;
        Iterator<String> destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo222 = false;
        for (Object t : $this$filterTo$iv$iv8222) {
            PluginUnloadabilityStatus it4 = (PluginUnloadabilityStatus)t;
            boolean bl14 = false;
            if (!(it4.getStatus() == UnloadabilityStatus.USES_COMPONENTS)) continue;
            destination$iv$iv3.add((String)t);
        }
        Object $this$sortedByDescending$iv = (List)((Object)destination$iv$iv3);
        boolean $i$f$sortedByDescending232 = false;
        boolean $this$filterTo$iv$iv8222 = false;
        List pluginsUsingComponents = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getComponents().size());
                it = (PluginUnloadabilityStatus)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getComponents().size();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        $this$sortedByDescending$iv = $this$buildString;
        String $i$f$sortedByDescending232 = "Plugins using components (" + pluginsUsingComponents.size() + "):";
        $this$filterTo$iv$iv8222 = false;
        StringBuilder stringBuilder7 = ((StringBuilder)$this$sortedByDescending$iv).append($i$f$sortedByDescending232);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder7);
        for (PluginUnloadabilityStatus status : pluginsUsingComponents) {
            StringBuilder $this$filterTo$iv$iv8222 = $this$buildString;
            destination$iv$iv3 = status.getPluginId() + " (" + status.getComponents().size() + ')';
            $i$f$filterTo222 = false;
            StringBuilder stringBuilder8 = $this$filterTo$iv$iv8222.append((String)((Object)destination$iv$iv3));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder8);
            for (String componentName : status.getComponents()) {
                StringBuilder $i$f$filterTo222 = $this$buildString;
                String element$iv$iv = "  " + componentName;
                boolean bl4 = false;
                StringBuilder stringBuilder9 = $i$f$filterTo222.append(element$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder9);
            }
        }
        StringsKt.appendln((StringBuilder)$this$buildString);
        Iterable $this$filter$iv3 = result;
        boolean $i$f$filter = false;
        destination$iv$iv3 = $this$filter$iv3;
        Object destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv52222) {
            PluginUnloadabilityStatus it5 = (PluginUnloadabilityStatus)element$iv$iv;
            boolean bl15 = false;
            if (!(it5.getStatus() == UnloadabilityStatus.USES_SERVICE_OVERRIDES)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        Object $this$sortedByDescending$iv2 = (List)destination$iv$iv4;
        boolean $i$f$sortedByDescending332 = false;
        boolean $this$filterTo$iv$iv52222 = false;
        List pluginsUsingServiceOverrides = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getServiceOverrides().size());
                it = (PluginUnloadabilityStatus)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getServiceOverrides().size();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        $this$sortedByDescending$iv2 = $this$buildString;
        String $i$f$sortedByDescending332 = "Plugins using service overrides (" + pluginsUsingServiceOverrides.size() + "):";
        $this$filterTo$iv$iv52222 = false;
        StringBuilder stringBuilder10 = ((StringBuilder)$this$sortedByDescending$iv2).append($i$f$sortedByDescending332);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder10);
        for (PluginUnloadabilityStatus status : pluginsUsingServiceOverrides) {
            StringBuilder $this$filterTo$iv$iv52222 = $this$buildString;
            destination$iv$iv4 = status.getPluginId() + " (" + CollectionsKt.joinToString$default((Iterable)status.getServiceOverrides(), null, null, null, (int)0, null, null, (int)63, null) + ')';
            $i$f$filterTo3 = false;
            StringBuilder stringBuilder11 = $this$filterTo$iv$iv52222.append((String)destination$iv$iv4);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder11);
        }
        StringsKt.appendln((StringBuilder)$this$buildString);
        Object $this$filter$iv4 = result;
        boolean $i$f$filter432 = false;
        destination$iv$iv4 = $this$filter$iv4;
        Iterator<Map.Entry<String, Set<String>>> destination$iv$iv5 = new ArrayList();
        boolean bl5 = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv42222) {
            PluginUnloadabilityStatus it232 = (PluginUnloadabilityStatus)element$iv$iv3;
            bl = false;
            if (!(it232.getStatus() == UnloadabilityStatus.NON_DYNAMIC_IN_DEPENDENCIES)) continue;
            destination$iv$iv5.add((Map.Entry<String, Set<String>>)element$iv$iv3);
        }
        List pluginsWithOptionalDependencies = (List)((Object)destination$iv$iv5);
        $this$filter$iv4 = $this$buildString;
        String $i$f$filter432 = "Plugins not unloadable because of optional dependencies (" + pluginsWithOptionalDependencies.size() + "):";
        boolean $this$filterTo$iv$iv42222 = false;
        StringBuilder stringBuilder12 = ((StringBuilder)$this$filter$iv4).append($i$f$filter432);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder12);
        for (PluginUnloadabilityStatus status : pluginsWithOptionalDependencies) {
            Object $this$filterTo$iv$iv42222 = $this$buildString;
            destination$iv$iv5 = status.getPluginId();
            boolean bl6 = false;
            StringBuilder stringBuilder13 = ((StringBuilder)$this$filterTo$iv$iv42222).append((String)((Object)destination$iv$iv5));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder13);
            Map<String, Set<String>> map = status.getNonDynamicEPsInDependencies();
            boolean element$iv$iv = false;
            destination$iv$iv5 = map.entrySet().iterator();
            while (destination$iv$iv5.hasNext()) {
                Object element$iv$iv3 = $this$filterTo$iv$iv42222 = destination$iv$iv5.next();
                boolean it232 = false;
                String string = (String)element$iv$iv3.getKey();
                element$iv$iv3 = $this$filterTo$iv$iv42222;
                it232 = false;
                Set eps = (Set)element$iv$iv3.getValue();
                element$iv$iv3 = $this$buildString;
                String it232 = "  " + string + " - " + CollectionsKt.joinToString$default((Iterable)eps, null, null, null, (int)0, null, null, (int)63, null);
                bl = false;
                StringBuilder stringBuilder14 = ((StringBuilder)element$iv$iv3).append(it232);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder14);
            }
        }
        StringsKt.appendln((StringBuilder)$this$buildString);
        Object $this$filter$iv5 = result;
        boolean $i$f$filter522 = false;
        destination$iv$iv5 = $this$filter$iv5;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo522 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv32222) {
            PluginUnloadabilityStatus it6 = (PluginUnloadabilityStatus)element$iv$iv;
            boolean bl16 = false;
            if (!(it6.getStatus() == UnloadabilityStatus.USES_NON_DYNAMIC_EPS)) continue;
            collection.add(element$iv$iv);
        }
        List nonDynamicPlugins = (List)collection;
        $this$filter$iv5 = nonDynamicPlugins;
        $i$f$filter522 = false;
        if (!$this$filter$iv5.isEmpty()) {
            $this$filter$iv5 = $this$buildString;
            String $i$f$filter522 = "Plugins with EPs explicitly marked as dynamic=false:";
            boolean $this$filterTo$iv$iv32222 = false;
            StringBuilder stringBuilder15 = ((StringBuilder)$this$filter$iv5).append($i$f$filter522);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder15);
            for (PluginUnloadabilityStatus nonDynamicPlugin : nonDynamicPlugins) {
                StringBuilder $this$filterTo$iv$iv32222 = $this$buildString;
                String string = nonDynamicPlugin.getPluginId() + " (" + nonDynamicPlugin.getNonDynamicEPs().size() + ')';
                $i$f$filterTo522 = false;
                StringBuilder stringBuilder16 = $this$filterTo$iv$iv32222.append(string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder16);
                for (String ep : nonDynamicPlugin.getNonDynamicEPs()) {
                    StringBuilder $i$f$filterTo522 = $this$buildString;
                    String element$iv$iv3 = "  " + ep;
                    boolean element$iv$iv = false;
                    StringBuilder stringBuilder17 = $i$f$filterTo522.append(element$iv$iv3);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder17);
                }
            }
            StringsKt.appendln((StringBuilder)$this$buildString);
        }
        Object $this$filter$iv6 = result;
        boolean $i$f$filter622 = false;
        Iterable iterable = $this$filter$iv6;
        Collection destination$iv$iv7 = new ArrayList();
        boolean $i$f$filterTo622 = false;
        for (Object element$iv$iv4 : iterable) {
            boolean bl7;
            block33: {
                PluginUnloadabilityStatus it7 = (PluginUnloadabilityStatus)element$iv$iv4;
                boolean bl18 = false;
                Iterable $this$any$iv2 = it7.getUnspecifiedDynamicEPs();
                boolean $i$f$any = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl7 = false;
                } else {
                    for (Object element$iv : $this$any$iv2) {
                        String it8 = (String)element$iv;
                        boolean bl19 = false;
                        if (!(!StringsKt.startsWith$default((String)it8, (String)"cidr", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)it8, (String)"appcode", (boolean)false, (int)2, null))) continue;
                        bl7 = true;
                        break block33;
                    }
                    bl7 = false;
                }
            }
            if (!bl7) continue;
            destination$iv$iv7.add(element$iv$iv4);
        }
        List closePlugins = (List)destination$iv$iv7;
        $this$filter$iv6 = closePlugins;
        $i$f$filter622 = false;
        if (!$this$filter$iv6.isEmpty()) {
            $this$filter$iv6 = $this$buildString;
            String $i$f$filter622 = "Plugins with non-dynamic EPs (" + closePlugins.size() + "):";
            boolean bl8 = false;
            StringBuilder stringBuilder18 = ((StringBuilder)$this$filter$iv6).append($i$f$filter622);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder18);
            Iterable iterable2 = closePlugins;
            boolean $i$f$sortedBy22 = false;
            $i$f$filterTo622 = false;
            for (PluginUnloadabilityStatus status : CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getUnspecifiedDynamicEPs().size());
                    it = (PluginUnloadabilityStatus)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getUnspecifiedDynamicEPs().size();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            })) {
                StringBuilder stringBuilder19 = $this$buildString;
                String $i$f$sortedBy22 = status.getPluginId() + " (" + status.getUnspecifiedDynamicEPs().size() + ')';
                $i$f$filterTo622 = false;
                StringBuilder stringBuilder20 = stringBuilder19.append($i$f$sortedBy22);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder20, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder20);
                for (String string : status.getUnspecifiedDynamicEPs()) {
                    StringBuilder $i$f$filterTo622 = $this$buildString;
                    String element$iv$iv = "  " + string;
                    boolean element$iv$iv4 = false;
                    StringBuilder stringBuilder21 = $i$f$filterTo622.append(element$iv$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder21, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder21);
                }
            }
            StringsKt.appendln((StringBuilder)$this$buildString);
        }
        boolean $i$f$filter622 = false;
        Map epUsagesMap = new LinkedHashMap();
        for (PluginUnloadabilityStatus pluginUnloadabilityStatus : result) {
            for (String ep : pluginUnloadabilityStatus.getUnspecifiedDynamicEPs()) {
                epUsagesMap.put(ep, ((Number)epUsagesMap.getOrDefault(ep, 0)).intValue() + 1);
            }
        }
        Iterable iterable3 = MapsKt.toList((Map)epUsagesMap);
        boolean $i$f$filter7 = false;
        Iterable $i$f$filterTo622 = iterable3;
        Collection destination$iv$iv8 = new ArrayList();
        boolean $i$f$filterTo7 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it9 = (Pair)element$iv$iv;
            boolean bl20 = false;
            if (!(!StringsKt.startsWith$default((String)((String)it9.getFirst()), (String)"cidr", (boolean)false, (int)2, null))) continue;
            destination$iv$iv8.add(element$iv$iv);
        }
        Iterable iterable4 = (List)destination$iv$iv8;
        boolean $i$f$sortedByDescending = false;
        boolean bl9 = false;
        List epUsagesList = CollectionsKt.sortedWith((Iterable)iterable4, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)b;
                boolean bl2 = false;
                Comparable comparable = (Integer)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = (Integer)it.getSecond();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        StringBuilder stringBuilder22 = $this$buildString;
        String string = "EP usage statistics (" + epUsagesList.size() + " non-dynamic EPs remaining):";
        bl9 = false;
        StringBuilder stringBuilder23 = stringBuilder22.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder23, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder23);
        for (Pair pair : epUsagesList) {
            $this$buildString.append(((Number)pair.getSecond()).intValue() + ": " + (String)pair.getFirst());
            StringsKt.appendln((StringBuilder)$this$buildString);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String report = string2;
        stringBuilder = StringCompanionObject.INSTANCE;
        String string3 = "AnalyzeUnloadablePlugins-Report-%s.txt";
        Object[] objectArray = new Object[]{DateFormatUtil.formatDateTime((long)System.currentTimeMillis())};
        boolean bl22 = false;
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
        String fileName = string4;
        LightVirtualFile file = new LightVirtualFile(fileName, (CharSequence)report);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, (VirtualFile)file);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }

    /*
     * WARNING - void declaration
     */
    private final PluginUnloadabilityStatus analyzeUnloadable(IdeaPlugin ideaPlugin, List<? extends XmlFile> allPlugins) {
        void $this$mapNotNullTo$iv$iv;
        boolean bl = false;
        Set unspecifiedDynamicEPs = new LinkedHashSet();
        boolean bl2 = false;
        Set nonDynamicEPs = new LinkedHashSet();
        boolean bl3 = false;
        List analysisErrors = new ArrayList();
        boolean bl4 = false;
        List serviceOverrides = new ArrayList();
        boolean bl5 = false;
        List components = new ArrayList();
        this.analyzePluginFile(ideaPlugin, analysisErrors, components, nonDynamicEPs, unspecifiedDynamicEPs, serviceOverrides, true);
        Function1<IdeaPlugin, Unit> $fun$analyzeDependencies$1 = new Function1<IdeaPlugin, Unit>(this, analysisErrors, components, nonDynamicEPs, unspecifiedDynamicEPs, serviceOverrides){
            final /* synthetic */ AnalyzeUnloadablePluginsAction this$0;
            final /* synthetic */ List $analysisErrors;
            final /* synthetic */ List $components;
            final /* synthetic */ Set $nonDynamicEPs;
            final /* synthetic */ Set $unspecifiedDynamicEPs;
            final /* synthetic */ List $serviceOverrides;

            public final void invoke(@NotNull IdeaPlugin ideaPlugin) {
                Intrinsics.checkNotNullParameter((Object)ideaPlugin, (String)"ideaPlugin");
                Iterator<Dependency> iterator = ideaPlugin.getDependencies().iterator();
                while (iterator.hasNext()) {
                    String configFileName;
                    Dependency dependency;
                    Dependency dependency2 = dependency = iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)dependency2, (String)"dependency");
                    GenericAttributeValue<PathReference> genericAttributeValue = dependency2.getConfigFile();
                    Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"dependency.configFile");
                    if (genericAttributeValue.getStringValue() == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)configFileName, (String)"dependency.configFile.stringValue ?: continue");
                    IdeaPlugin depIdeaPlugin = AnalyzeUnloadablePluginsAction.access$resolvePluginDependency(this.this$0, dependency);
                    if (depIdeaPlugin == null) {
                        this.$analysisErrors.add("Failed to resolve dependency descriptor file " + configFileName);
                        continue;
                    }
                    AnalyzeUnloadablePluginsAction.access$analyzePluginFile(this.this$0, depIdeaPlugin, this.$analysisErrors, this.$components, this.$nonDynamicEPs, this.$unspecifiedDynamicEPs, this.$serviceOverrides, true);
                    this.invoke(depIdeaPlugin);
                }
            }
            {
                this.this$0 = analyzeUnloadablePluginsAction;
                this.$analysisErrors = list;
                this.$components = list2;
                this.$nonDynamicEPs = set;
                this.$unspecifiedDynamicEPs = set2;
                this.$serviceOverrides = list3;
                super(1);
            }
        };
        $fun$analyzeDependencies$1.invoke(ideaPlugin);
        boolean bl6 = false;
        List componentsInOptionalDependencies = new ArrayList();
        boolean bl7 = false;
        Map nonDynamicEPsInOptionalDependencies = new LinkedHashMap();
        boolean bl8 = false;
        List serviceOverridesInDependencies = new ArrayList();
        Iterable $this$mapNotNull$iv = allPlugins;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            IdeaPlugin ideaPlugin2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl9 = false;
            XmlFile it = (XmlFile)element$iv$iv;
            boolean bl10 = false;
            if (DescriptorUtil.getIdeaPlugin(it) == null) continue;
            boolean bl11 = false;
            boolean bl12 = false;
            IdeaPlugin it$iv$iv = ideaPlugin2;
            boolean bl13 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterator iterator2 = ((List)destination$iv$iv).iterator();
        while (iterator2.hasNext()) {
            IdeaPlugin descriptor;
            IdeaPlugin ideaPlugin3 = descriptor = (IdeaPlugin)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)ideaPlugin3, (String)"descriptor");
            Iterator<Dependency> iterator3 = ideaPlugin3.getDependencies().iterator();
            while (iterator3.hasNext()) {
                Dependency dependency;
                Dependency dependency2 = dependency = iterator3.next();
                Intrinsics.checkNotNullExpressionValue((Object)dependency2, (String)"dependency");
                GenericAttributeValue<Boolean> genericAttributeValue = dependency2.getOptional();
                Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"dependency.optional");
                if (!Intrinsics.areEqual((Object)((Boolean)genericAttributeValue.getValue()), (Object)true) || !Intrinsics.areEqual((Object)dependency.getValue(), (Object)ideaPlugin)) continue;
                IdeaPlugin depIdeaPlugin = this.resolvePluginDependency(dependency);
                if (depIdeaPlugin == null) {
                    GenericAttributeValue<PathReference> genericAttributeValue2 = dependency.getConfigFile();
                    Intrinsics.checkNotNullExpressionValue(genericAttributeValue2, (String)"dependency.configFile");
                    if (genericAttributeValue2.getStringValue() == null) continue;
                    StringBuilder stringBuilder = new StringBuilder().append("Failed to resolve dependency descriptor file ");
                    GenericAttributeValue<PathReference> genericAttributeValue3 = dependency.getConfigFile();
                    Intrinsics.checkNotNullExpressionValue(genericAttributeValue3, (String)"dependency.configFile");
                    analysisErrors.add(stringBuilder.append(genericAttributeValue3.getStringValue()).toString());
                    continue;
                }
                boolean bl14 = false;
                Set nonDynamicEPsInDependency = new LinkedHashSet();
                this.analyzePluginFile(depIdeaPlugin, analysisErrors, componentsInOptionalDependencies, nonDynamicEPsInDependency, nonDynamicEPsInDependency, serviceOverridesInDependencies, false);
                Collection collection = nonDynamicEPsInDependency;
                boolean bl15 = false;
                if (!(!collection.isEmpty())) continue;
                String string = descriptor.getPluginId();
                if (string == null) {
                    string = "<unknown>";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.pluginId ?: \"<unknown>\"");
                nonDynamicEPsInOptionalDependencies.put(string, nonDynamicEPsInDependency);
            }
        }
        String string = ideaPlugin.getPluginId();
        if (string == null) {
            string = "?";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ideaPlugin.pluginId ?: \"?\"");
        return new PluginUnloadabilityStatus(string, unspecifiedDynamicEPs, nonDynamicEPs, nonDynamicEPsInOptionalDependencies, components, serviceOverrides, analysisErrors);
    }

    private final IdeaPlugin resolvePluginDependency(Dependency dependency) {
        IdeaPlugin ideaPlugin;
        XmlFile xmlFile = dependency.getResolvedConfigFile();
        GenericAttributeValue<PathReference> genericAttributeValue = dependency.getConfigFile();
        Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"dependency.configFile");
        String configFileName = genericAttributeValue.getStringValue();
        if (xmlFile == null && configFileName != null) {
            DomManager domManager = dependency.getManager();
            Intrinsics.checkNotNullExpressionValue((Object)domManager, (String)"dependency.manager");
            Project project = domManager.getProject();
            Object[] objectArray = FilenameIndex.getFilesByName((Project)project, (String)configFileName, (GlobalSearchScope)GlobalSearchScopesCore.projectProductionScope((Project)project));
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"FilenameIndex.getFilesBy\u2026ProductionScope(project))");
            Object[] matchingFiles = objectArray;
            Object object = ArraysKt.singleOrNull((Object[])matchingFiles);
            if (!(object instanceof XmlFile)) {
                object = null;
            }
            xmlFile = (XmlFile)object;
        }
        XmlFile xmlFile2 = xmlFile;
        if (xmlFile2 != null) {
            XmlFile xmlFile3 = xmlFile2;
            boolean bl = false;
            boolean bl2 = false;
            XmlFile it = xmlFile3;
            boolean bl3 = false;
            ideaPlugin = DescriptorUtil.getIdeaPlugin(it);
        } else {
            ideaPlugin = null;
        }
        return ideaPlugin;
    }

    /*
     * WARNING - void declaration
     */
    private final void analyzePluginFile(IdeaPlugin ideaPlugin, List<String> analysisErrors, List<String> components, Set<String> nonDynamicEPs, Set<String> unspecifiedDynamicEPs, List<String> serviceOverrides, boolean allowOwnEPs) {
        String string;
        Collection collection;
        Iterable list$iv$iv;
        Object it;
        Object $this$flatMapTo$iv$iv;
        Object ep;
        void $this$flatMapTo$iv$iv2;
        List<Extensions> list = ideaPlugin.getExtensions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"ideaPlugin.extensions");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap2 = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            Extensions it2 = (Extensions)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv2 = it2.collectExtensions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
        }
        Iterator iterator = ((List)destination$iv$iv).iterator();
        while (iterator.hasNext()) {
            Extension extension;
            Extension extension2 = extension = (Extension)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)extension2, (String)"extension");
            ep = extension2.getExtensionPoint();
            if (ep == null) {
                analysisErrors.add("Cannot resolve EP " + extension.getXmlElementName());
                continue;
            }
            if (allowOwnEPs && (Intrinsics.areEqual((Object)ep.getModule(), (Object)ideaPlugin.getModule()) || Intrinsics.areEqual((Object)ep.getModule(), (Object)extension.getModule()))) continue;
            GenericAttributeValue<Boolean> genericAttributeValue = ep.getDynamic();
            Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"ep.dynamic");
            Boolean $i$f$flatMap2 = (Boolean)genericAttributeValue.getValue();
            if (Intrinsics.areEqual((Object)$i$f$flatMap2, (Object)false)) {
                String string2 = ep.getEffectiveQualifiedName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ep.effectiveQualifiedName");
                nonDynamicEPs.add(string2);
            } else if ($i$f$flatMap2 == null) {
                String string3 = ep.getEffectiveQualifiedName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ep.effectiveQualifiedName");
                unspecifiedDynamicEPs.add(string3);
            }
            if (!Intrinsics.areEqual((Object)ep.getEffectiveQualifiedName(), (Object)"com.intellij.applicationService") && !Intrinsics.areEqual((Object)ep.getEffectiveQualifiedName(), (Object)"com.intellij.projectService") && !Intrinsics.areEqual((Object)ep.getEffectiveQualifiedName(), (Object)"com.intellij.moduleService") || !Intrinsics.areEqual((Object)extension.getXmlTag().getAttributeValue("overrides"), (Object)"true")) continue;
            String string4 = extension.getXmlTag().getAttributeValue("serviceInterface");
            if (string4 == null) {
                string4 = "<unknown>";
            }
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"extension.xmlTag.getAttr\u2026nterface\") ?: \"<unknown>\"");
            serviceOverrides.add(string4);
        }
        List<ApplicationComponents> list2 = ideaPlugin.getApplicationComponents();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"ideaPlugin.applicationComponents");
        Iterable $this$flatMap$iv2 = list2;
        boolean $i$f$flatMap3 = false;
        ep = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        destination$iv$iv = $this$flatMapTo$iv$iv.iterator();
        while (destination$iv$iv.hasNext()) {
            Object element$iv$iv = destination$iv$iv.next();
            it = (ApplicationComponents)element$iv$iv;
            boolean bl = false;
            ApplicationComponents applicationComponents = it;
            Intrinsics.checkNotNullExpressionValue((Object)applicationComponents, (String)"it");
            list$iv$iv = applicationComponents.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Iterable $this$mapTo$iv = (List)destination$iv$iv2;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it3;
            Component.Application $i$f$flatMapTo22 = (Component.Application)item$iv;
            collection = components;
            boolean bl = false;
            void v8 = it3;
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"it");
            GenericDomValue<PsiClass> genericDomValue = v8.getImplementationClass();
            Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"it.implementationClass");
            String string5 = genericDomValue.getRawText();
            if (string5 == null) {
                string5 = "?";
            }
            string = string5;
            collection.add(string);
        }
        List<ProjectComponents> list3 = ideaPlugin.getProjectComponents();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"ideaPlugin.projectComponents");
        $this$flatMap$iv2 = list3;
        $i$f$flatMap3 = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo32 = false;
        Iterator bl = $this$flatMapTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = bl.next();
            it = (ProjectComponents)element$iv$iv;
            boolean bl2 = false;
            Object object = it;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it");
            list$iv$iv = object.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$mapTo$iv = (List)destination$iv$iv2;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it4;
            Component.Project $i$f$flatMapTo32 = (Component.Project)item$iv;
            collection = components;
            boolean bl3 = false;
            void v13 = it4;
            Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"it");
            GenericDomValue<PsiClass> genericDomValue = v13.getImplementationClass();
            Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"it.implementationClass");
            String string6 = genericDomValue.getRawText();
            if (string6 == null) {
                string6 = "?";
            }
            string = string6;
            collection.add(string);
        }
        List<ModuleComponents> list4 = ideaPlugin.getModuleComponents();
        Intrinsics.checkNotNullExpressionValue(list4, (String)"ideaPlugin.moduleComponents");
        $this$flatMap$iv2 = list4;
        $i$f$flatMap3 = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo42 = false;
        Iterator bl3 = $this$flatMapTo$iv$iv.iterator();
        while (bl3.hasNext()) {
            Object element$iv$iv = bl3.next();
            it = (ModuleComponents)element$iv$iv;
            boolean bl4 = false;
            Object object = it;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it");
            list$iv$iv = object.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$mapTo$iv = (List)destination$iv$iv2;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it5;
            Component.Module $i$f$flatMapTo42 = (Component.Module)item$iv;
            collection = components;
            boolean bl5 = false;
            void v18 = it5;
            Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"it");
            GenericDomValue<PsiClass> genericDomValue = v18.getImplementationClass();
            Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"it.implementationClass");
            String string7 = genericDomValue.getRawText();
            if (string7 == null) {
                string7 = "?";
            }
            string = string7;
            collection.add(string);
        }
    }

    public static final /* synthetic */ PluginUnloadabilityStatus access$analyzeUnloadable(AnalyzeUnloadablePluginsAction $this, IdeaPlugin ideaPlugin, List allPlugins) {
        return $this.analyzeUnloadable(ideaPlugin, allPlugins);
    }

    public static final /* synthetic */ IdeaPlugin access$resolvePluginDependency(AnalyzeUnloadablePluginsAction $this, Dependency dependency) {
        return $this.resolvePluginDependency(dependency);
    }

    public static final /* synthetic */ void access$analyzePluginFile(AnalyzeUnloadablePluginsAction $this, IdeaPlugin ideaPlugin, List analysisErrors, List components, Set nonDynamicEPs, Set unspecifiedDynamicEPs, List serviceOverrides, boolean allowOwnEPs) {
        $this.analyzePluginFile(ideaPlugin, analysisErrors, components, nonDynamicEPs, unspecifiedDynamicEPs, serviceOverrides, allowOwnEPs);
    }
}

