/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.FileSystem$WhenMappings;
import org.jetbrains.kotlin.daemon.common.FileSystemUtilsKt;
import org.jetbrains.kotlin.daemon.common.OSKind;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\r\u001a\u00020\u00042\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000f\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/daemon/common/FileSystem;", "", "()V", "logFilesPath", "", "getLogFilesPath", "()Ljava/lang/String;", "runtimeStateFilesBasePath", "getRuntimeStateFilesBasePath", "tempPath", "getTempPath", "userHomePath", "getUserHomePath", "getRuntimeStateFilesPath", "names", "", "([Ljava/lang/String;)Ljava/lang/String;", "daemon-common"})
public final class FileSystem {
    public static final FileSystem INSTANCE;

    @NotNull
    public final String getUserHomePath() {
        String string2 = System.getProperty("user.home");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"System.getProperty(\"user.home\")");
        return string2;
    }

    @NotNull
    public final String getTempPath() {
        String string2 = System.getProperty("java.io.tmpdir");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"System.getProperty(\"java.io.tmpdir\")");
        return string2;
    }

    @NotNull
    public final String getLogFilesPath() {
        return this.getTempPath();
    }

    @NotNull
    public final String getRuntimeStateFilesBasePath() {
        String string2;
        switch (FileSystem$WhenMappings.$EnumSwitchMapping$0[OSKind.Companion.getCurrent().ordinal()]) {
            case 1: {
                string2 = FileSystemUtilsKt.access$orDefault(System.getenv("LOCALAPPDATA"), this.getTempPath());
                break;
            }
            case 2: {
                string2 = this.getUserHomePath() + "/Library/Application Support";
                break;
            }
            case 3: {
                string2 = FileSystemUtilsKt.access$orDefault(System.getenv("XDG_DATA_HOME"), this.getUserHomePath() + "/.local/share");
                break;
            }
            case 4: {
                string2 = this.getTempPath();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getRuntimeStateFilesPath(String ... names) {
        String string2;
        File dir;
        File file2;
        String element$iv;
        Object $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        boolean bl = ArraysKt.any((Object[])names);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        File base = new File(this.getRuntimeStateFilesBasePath());
        if (base.exists() && base.isDirectory()) {
            $this$fold$iv = names;
            boolean $i$f$fold = false;
            File accumulator$iv = base;
            Object object = $this$fold$iv;
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                void p2;
                String string4 = element$iv = object[i];
                File p1 = accumulator$iv;
                boolean bl5 = false;
                accumulator$iv = new File(p1, (String)p2);
            }
            file2 = accumulator$iv;
        } else {
            void it;
            void var17_27;
            $this$fold$iv = ArraysKt.drop((Object[])names, (int)1);
            Object $i$f$fold = ArraysKt.first((Object[])names);
            boolean accumulator$iv = false;
            boolean bl6 = false;
            Object object = (String)$i$f$fold;
            String string5 = this.getUserHomePath();
            boolean bl7 = false;
            void var18_28 = var17_27 = StringsKt.startsWith$default((String)it, (String)".", (boolean)false, (int)2, null) ? it : '.' + (String)it;
            String string6 = string5;
            File initial$iv = new File(string6, (String)var18_28);
            boolean $i$f$fold2 = false;
            File accumulator$iv2 = initial$iv;
            object = $this$fold$iv.iterator();
            while (object.hasNext()) {
                void p2;
                Object element$iv2 = object.next();
                element$iv = (String)element$iv2;
                File p1 = accumulator$iv2;
                boolean bl8 = false;
                accumulator$iv2 = new File(p1, (String)p2);
            }
            file2 = dir = accumulator$iv2;
        }
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            String string7 = dir.getAbsolutePath();
            string2 = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"dir.absolutePath");
        } else {
            string2 = this.getTempPath();
        }
        return string2;
    }

    private FileSystem() {
    }

    static {
        FileSystem fileSystem;
        INSTANCE = fileSystem = new FileSystem();
    }
}

