/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.konan.gradle.execution;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskRunner;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.build.tasks.CidrCleanTask;
import com.jetbrains.konan.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.konan.gradle.GradleKonanWorkspace;
import org.jetbrains.konan.gradle.KonanModel;
import org.jetbrains.konan.gradle.KonanProjectResolver;
import org.jetbrains.konan.gradle.execution.GradleBuildTasks;
import org.jetbrains.konan.gradle.execution.GradleBuildTasksMap;
import org.jetbrains.konan.gradle.execution.GradleBuildTasksOrigin;
import org.jetbrains.konan.gradle.execution.GradleKonanConfiguration;
import org.jetbrains.konan.gradle.execution.ProjectTaskRunnerCompatibilityKt;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMapKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0018H\u0016J\u0014\u0010\u0019\u001a\u00020\u0012*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u0019\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u0019\u001a\u00020\u0012*\u00060\u001ej\u0002`\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/konan/gradle/execution/GradleKonanProjectTaskRunner;", "Lcom/intellij/task/ProjectTaskRunner;", "()V", "canRun", "", "project", "Lcom/intellij/openapi/project/Project;", "task", "Lcom/intellij/task/ProjectTask;", "guessExecutionName", "", "buildTasks", "Lorg/jetbrains/konan/gradle/execution/GradleBuildTasks;", "isNativeModule", "module", "Lcom/intellij/openapi/module/Module;", "isProjectWithNativeModules", "run", "", "context", "Lcom/intellij/task/ProjectTaskContext;", "notification", "Lcom/intellij/task/ProjectTaskNotification;", "tasks", "", "collectGradleTasks", "Lcom/intellij/task/ModuleBuildTask;", "buildTasksMap", "Lorg/jetbrains/konan/gradle/execution/GradleBuildTasksMap;", "Lcom/intellij/task/ProjectModelBuildTask;", "Lcom/jetbrains/cidr/execution/build/tasks/CidrCleanTask;", "Lorg/jetbrains/konan/gradle/execution/GradleKonanCleanTask;", "kotlin-ultimate.common-cidr-native"})
public final class GradleKonanProjectTaskRunner
extends ProjectTaskRunner {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canRun(@NotNull Project project, @NotNull ProjectTask task) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        GradleKonanWorkspace workspace = GradleKonanWorkspace.Companion.getInstance(project);
        if (!workspace.isInitialized()) {
            return false;
        }
        Function1<Module, Boolean> $fun$canBuildModule$1 = new Function1<Module, Boolean>(this){
            final /* synthetic */ GradleKonanProjectTaskRunner this$0;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull Module module) {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) return false;
                Project project = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
                if (!GradleKonanProjectTaskRunner.access$isProjectWithNativeModules(this.this$0, project)) return false;
                return true;
            }
            {
                this.this$0 = gradleKonanProjectTaskRunner;
                super(1);
            }
        };
        Function1<Object, Boolean> $fun$canBuildConfiguration$2 = new Function1<Object, Boolean>(workspace){
            final /* synthetic */ GradleKonanWorkspace $workspace;

            public final boolean invoke(@Nullable Object configuration) {
                Object object = configuration;
                if (!(object instanceof GradleKonanConfiguration)) {
                    object = null;
                }
                GradleKonanConfiguration gradleKonanConfiguration = (GradleKonanConfiguration)object;
                if (gradleKonanConfiguration == null) {
                    return false;
                }
                GradleKonanConfiguration buildConfiguration = gradleKonanConfiguration;
                GradleKonanConfiguration gradleKonanConfiguration2 = this.$workspace.getSelectedBuildConfiguration();
                if (gradleKonanConfiguration2 == null) {
                    return false;
                }
                GradleKonanConfiguration selectedBuildConfiguration = gradleKonanConfiguration2;
                return Intrinsics.areEqual((Object)buildConfiguration.getId(), (Object)selectedBuildConfiguration.getId());
            }
            {
                this.$workspace = gradleKonanWorkspace;
                super(1);
            }
        };
        ProjectTask projectTask = task;
        if (projectTask instanceof ModuleBuildTask) {
            if (!ProjectTaskRunnerCompatibilityKt.isSupported((ModuleBuildTask)task)) return false;
            Module module = ((ModuleBuildTask)task).getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"task.module");
            if (!$fun$canBuildModule$1.invoke(module)) return false;
            return true;
        }
        if (projectTask instanceof CidrCleanTask) {
            bl = $fun$canBuildConfiguration$2.invoke((Object)((CidrCleanTask)task).getBuildConfiguration());
            return bl;
        } else {
            if (!(projectTask instanceof ProjectModelBuildTask)) return false;
            bl = $fun$canBuildConfiguration$2.invoke((Object)((ProjectModelBuildTask)task).getBuildableElement());
        }
        return bl;
    }

    public boolean canRun(@NotNull ProjectTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void run(@NotNull Project project, @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification notification, @NotNull Collection<? extends ProjectTask> tasks) {
        void $this$mapNotNullTo$iv$iv;
        Object element$iv2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        if (tasks.isEmpty()) {
            return;
        }
        GradleBuildTasksMap buildTasksMap = new GradleBuildTasksMap();
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            ProjectTask task = (ProjectTask)element$iv2;
            boolean bl = false;
            ProjectTask projectTask = task;
            if (projectTask instanceof ModuleBuildTask) {
                this.collectGradleTasks((ModuleBuildTask)task, buildTasksMap);
                continue;
            }
            if (projectTask instanceof CidrCleanTask) {
                this.collectGradleTasks((CidrCleanTask)task, buildTasksMap);
                continue;
            }
            if (projectTask instanceof ProjectModelBuildTask) {
                this.collectGradleTasks((ProjectModelBuildTask)task, buildTasksMap);
                continue;
            }
            String string = "Unexpected task type: " + task;
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (buildTasksMap.isEmpty()) {
            return;
        }
        Iterable $this$mapNotNull$iv = buildTasksMap.getEntries();
        boolean $i$f$mapNotNull = false;
        element$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Triple triple;
            void projectPath;
            String executionName;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry $dstr$projectPath$buildTasks = (Map.Entry)element$iv$iv;
            boolean bl3 = false;
            Map.Entry entry = $dstr$projectPath$buildTasks;
            boolean bl4 = false;
            String string = (String)entry.getKey();
            entry = $dstr$projectPath$buildTasks;
            bl4 = false;
            GradleBuildTasks buildTasks = (GradleBuildTasks)entry.getValue();
            if ((this.guessExecutionName(buildTasks) == null ? null : new Triple((Object)executionName, buildTasks.getAllTasks(), (Object)projectPath)) == null) continue;
            triple = triple;
            boolean bl5 = false;
            boolean bl6 = false;
            Triple it$iv$iv = triple;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List toExecute = (List)destination$iv$iv;
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(toExecute, project){
            final /* synthetic */ List $toExecute;
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                Iterable $this$forEach$iv = this.$toExecute;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    void buildTasks;
                    void executionName;
                    Triple $dstr$executionName$buildTasks$projectPath = (Triple)element$iv;
                    boolean bl = false;
                    String string = (String)$dstr$executionName$buildTasks$projectPath.component1();
                    List list = (List)$dstr$executionName$buildTasks$projectPath.component2();
                    String projectPath = (String)$dstr$executionName$buildTasks$projectPath.component3();
                    UtilsKt.runBuildTasks$default((Project)this.$project, (String)executionName, (List)buildTasks, (String)projectPath, (boolean)true, null, (int)32, null);
                }
            }
            {
                this.$toExecute = list;
                this.$project = project;
            }
        });
    }

    private final boolean isProjectWithNativeModules(Project project) {
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, (CachedValueProvider)new CachedValueProvider<Boolean>(this, project){
            final /* synthetic */ GradleKonanProjectTaskRunner this$0;
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final CachedValueProvider.Result<Boolean> compute() {
                boolean bl;
                block1: {
                    void $this$any$iv;
                    ModuleManager moduleManager = ModuleManager.getInstance((Project)this.$project);
                    Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                    Module[] moduleArray = moduleManager.getModules();
                    Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
                    Module[] moduleArray2 = moduleArray;
                    GradleKonanProjectTaskRunner gradleKonanProjectTaskRunner = this.this$0;
                    boolean $i$f$any = false;
                    void var4_4 = $this$any$iv;
                    int n = ((void)var4_4).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void p1 = element$iv = var4_4[i];
                        boolean bl2 = false;
                        if (!GradleKonanProjectTaskRunner.access$isNativeModule(gradleKonanProjectTaskRunner, (Module)p1)) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                boolean bl3 = bl;
                Object[] objectArray = new Object[]{ProjectRootModificationTracker.getInstance((Project)this.$project)};
                Boolean bl4 = bl3;
                return new CachedValueProvider.Result((Object)bl4, objectArray);
            }
            {
                this.this$0 = gradleKonanProjectTaskRunner;
                this.$project = project;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CachedValuesManager.getM\u2026ce(project)\n      )\n    }");
        return (Boolean)object;
    }

    private final boolean isNativeModule(Module module) {
        KotlinFacet kotlinFacet = KotlinFacet.Companion.get(module);
        return kotlinFacet != null && (kotlinFacet = (KotlinFacetConfiguration)kotlinFacet.getConfiguration()) != null && (kotlinFacet = kotlinFacet.getSettings()) != null && (kotlinFacet = kotlinFacet.getTargetPlatform()) != null && NativePlatformKt.isNative((TargetPlatform)kotlinFacet);
    }

    /*
     * WARNING - void declaration
     */
    private final void collectGradleTasks(ModuleBuildTask $this$collectGradleTasks, GradleBuildTasksMap buildTasksMap) {
        void konanModel;
        Module module = $this$collectGradleTasks.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"module");
        String string = ModuleSourceRootMapKt.getExternalProjectPath((Module)module);
        if (string == null) {
            return;
        }
        String linkedExternalProjectPath = string;
        Module module2 = $this$collectGradleTasks.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        Project project2 = project;
        Map cache2 = (Map)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, (CachedValueProvider)new CachedValueProvider<Map<String, ? extends Pair<? extends KonanModel, ? extends String>>>(project2){
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final CachedValueProvider.Result<Map<String, Pair<KonanModel, String>>> compute() {
                boolean bl = false;
                Map map = new LinkedHashMap<K, V>();
                boolean bl2 = false;
                boolean bl3 = false;
                Map $this$apply = map;
                boolean bl4 = false;
                Project project$iv = this.$project;
                boolean $i$f$forEachKonanProject = false;
                Iterator<E> iterator = ProjectDataManager.getInstance().getExternalProjectsData(project$iv, GradleConstants.SYSTEM_ID).iterator();
                while (iterator.hasNext()) {
                    Collection modulesNodes$iv;
                    DataNode projectStructure$iv;
                    ExternalProjectInfo projectInfo$iv;
                    ExternalProjectInfo externalProjectInfo = projectInfo$iv = (ExternalProjectInfo)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)externalProjectInfo, (String)"projectInfo");
                    if (externalProjectInfo.getExternalProjectStructure() == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)projectStructure$iv, (String)"projectInfo.externalProjectStructure ?: continue");
                    Object object = projectStructure$iv.getData();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"projectStructure.data");
                    ProjectData projectData$iv = (ProjectData)object;
                    Intrinsics.checkNotNullExpressionValue((Object)projectData$iv.getLinkedExternalProjectPath(), (String)"projectData.linkedExternalProjectPath");
                    Intrinsics.checkNotNullExpressionValue((Object)ExternalSystemApiUtil.findAll((DataNode)projectStructure$iv, (Key)ProjectKeys.MODULE), (String)"ExternalSystemApiUtil.fi\u2026ture, ProjectKeys.MODULE)");
                    for (DataNode moduleNode$iv : modulesNodes$iv) {
                        void projectPath;
                        void moduleNode;
                        String rootProjectPath$iv;
                        DataNode projectNode$iv;
                        if (ExternalSystemApiUtil.find((DataNode)moduleNode$iv, KonanProjectResolver.Companion.getKONAN_MODEL_KEY()) == null) {
                            continue;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)projectNode$iv, (String)"ExternalSystemApiUtil.fi\u2026AN_MODEL_KEY) ?: continue");
                        Object object2 = projectNode$iv.getData();
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"projectNode.data");
                        KonanModel konanProject$iv = (KonanModel)object2;
                        Intrinsics.checkNotNullExpressionValue((Object)moduleNode$iv, (String)"moduleNode");
                        String string = rootProjectPath$iv;
                        KonanModel konanModel = konanProject$iv;
                        boolean bl5 = false;
                        Object object3 = moduleNode.getData();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"moduleNode.data");
                        String string2 = ((ModuleData)object3).getLinkedExternalProjectPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"moduleNode.data.linkedExternalProjectPath");
                        $this$apply.put(string2, TuplesKt.to((Object)konanModel, (Object)projectPath));
                    }
                }
                Unit unit = Unit.INSTANCE;
                Object[] objectArray = new Object[]{ProjectRootModificationTracker.getInstance((Project)this.$project)};
                Map map2 = map;
                return new CachedValueProvider.Result((Object)map2, objectArray);
            }
            {
                this.$project = project;
            }
        });
        Pair pair = (Pair)cache2.get(linkedExternalProjectPath);
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        KonanModel konanModel2 = (KonanModel)pair2.component1();
        String projectPath = (String)pair2.component2();
        String cleanupTask = !$this$collectGradleTasks.isIncrementalBuild() ? konanModel.getCleanTaskPath() : null;
        String compileTask = konanModel.getBuildTaskPath();
        buildTasksMap.consume(new GradleBuildTasksOrigin.FromProject(project2), projectPath, cleanupTask, compileTask);
    }

    private final void collectGradleTasks(CidrCleanTask $this$collectGradleTasks, GradleBuildTasksMap buildTasksMap) {
        block1: {
            CidrBuildConfiguration cidrBuildConfiguration = $this$collectGradleTasks.getBuildConfiguration();
            if (!(cidrBuildConfiguration instanceof GradleKonanConfiguration)) {
                cidrBuildConfiguration = null;
            }
            GradleKonanConfiguration gradleKonanConfiguration = (GradleKonanConfiguration)cidrBuildConfiguration;
            if (gradleKonanConfiguration == null) break block1;
            GradleKonanConfiguration gradleKonanConfiguration2 = gradleKonanConfiguration;
            boolean bl = false;
            boolean bl2 = false;
            GradleKonanConfiguration buildConfiguration = gradleKonanConfiguration2;
            boolean bl3 = false;
            String projectPath = buildConfiguration.getProjectPath();
            String cleanupTask = buildConfiguration.getArtifactCleanTaskPath();
            GradleBuildTasksMap.consume$default(buildTasksMap, new GradleBuildTasksOrigin.FromConfiguration(buildConfiguration), projectPath, cleanupTask, null, 8, null);
        }
    }

    private final void collectGradleTasks(ProjectModelBuildTask<?> $this$collectGradleTasks, GradleBuildTasksMap buildTasksMap) {
        block1: {
            ProjectModelBuildableElement projectModelBuildableElement = $this$collectGradleTasks.getBuildableElement();
            if (!(projectModelBuildableElement instanceof GradleKonanConfiguration)) {
                projectModelBuildableElement = null;
            }
            GradleKonanConfiguration gradleKonanConfiguration = (GradleKonanConfiguration)projectModelBuildableElement;
            if (gradleKonanConfiguration == null) break block1;
            GradleKonanConfiguration gradleKonanConfiguration2 = gradleKonanConfiguration;
            boolean bl = false;
            boolean bl2 = false;
            GradleKonanConfiguration buildConfiguration = gradleKonanConfiguration2;
            boolean bl3 = false;
            String projectPath = buildConfiguration.getProjectPath();
            String cleanupTask = !$this$collectGradleTasks.isIncrementalBuild() ? buildConfiguration.getArtifactCleanTaskPath() : null;
            String compileTask = buildConfiguration.getArtifactBuildTaskPath();
            buildTasksMap.consume(new GradleBuildTasksOrigin.FromConfiguration(buildConfiguration), projectPath, cleanupTask, compileTask);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String guessExecutionName(GradleBuildTasks buildTasks) {
        String string;
        boolean bl = buildTasks.getCompileTasks().isEmpty();
        if (bl) {
            boolean bl2 = buildTasks.getCleanupTasks().isEmpty();
            if (bl2) {
                return null;
            }
            string = ((GradleBuildTasksOrigin)CollectionsKt.first(buildTasks.getOrigins())).getCleanExecutionName();
            return string;
        } else {
            if (bl) throw new NoWhenBranchMatchedException();
            boolean bl3 = buildTasks.getCleanupTasks().isEmpty();
            if (bl3) {
                string = ((GradleBuildTasksOrigin)CollectionsKt.first(buildTasks.getOrigins())).getBuildExecutionName();
                return string;
            } else {
                if (bl3) throw new NoWhenBranchMatchedException();
                string = ((GradleBuildTasksOrigin)CollectionsKt.first(buildTasks.getOrigins())).getRebuildExecutionName();
            }
        }
        return string;
    }

    public static final /* synthetic */ boolean access$isProjectWithNativeModules(GradleKonanProjectTaskRunner $this, Project project) {
        return $this.isProjectWithNativeModules(project);
    }

    public static final /* synthetic */ boolean access$isNativeModule(GradleKonanProjectTaskRunner $this, Module module) {
        return $this.isNativeModule(module);
    }
}

