/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.patterns;

import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.util.ProcessingContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.patterns.KotlinPatternsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0006J\u001f\u0010\t\u001a\u00020\u00002\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000b\"\u00020\u0006\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/patterns/KotlinFunctionPattern;", "Lcom/intellij/patterns/PsiElementPattern;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "()V", "definedInClass", "fqName", "", "definedInPackage", "packageFqName", "withParameters", "parameterTypes", "", "([Ljava/lang/String;)Lorg/jetbrains/kotlin/idea/patterns/KotlinFunctionPattern;", "withReceiver", "receiverFqName", "DefinedInClassCondition", "kotlin.idea"})
public class KotlinFunctionPattern
extends PsiElementPattern<KtFunction, KotlinFunctionPattern> {
    @NotNull
    public final KotlinFunctionPattern withParameters(String ... parameterTypes2) {
        Intrinsics.checkNotNullParameter((Object)parameterTypes2, (String)"parameterTypes");
        return (KotlinFunctionPattern)KotlinPatternsKt.access$withPatternCondition(this, "kotlinFunctionPattern-withParameters", (Function2)new Function2<KtFunction, ProcessingContext, Boolean>(parameterTypes2){
            final /* synthetic */ String[] $parameterTypes;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull KtFunction function2, @Nullable ProcessingContext $noName_1) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                if (function2.getValueParameters().size() != this.$parameterTypes.length) {
                    return false;
                }
                DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtDeclaration)((KtDeclaration)function2), null, (int)1, null);
                if (!(declarationDescriptor instanceof FunctionDescriptor)) {
                    declarationDescriptor = null;
                }
                FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)declarationDescriptor;
                if (functionDescriptor2 == null) {
                    return false;
                }
                FunctionDescriptor descriptor2 = functionDescriptor2;
                List list = descriptor2.getValueParameters();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"descriptor.valueParameters");
                List valueParameters = list;
                if (valueParameters.size() != this.$parameterTypes.length) {
                    return false;
                }
                int n = 0;
                int n2 = valueParameters.size() - 1;
                if (n <= n2) {
                    while (true) {
                        ValueParameterDescriptor actualParameterDescriptor;
                        void i;
                        String expectedTypeString = this.$parameterTypes[i];
                        ValueParameterDescriptor valueParameterDescriptor = actualParameterDescriptor = (ValueParameterDescriptor)valueParameters.get((int)i);
                        Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"actualParameterDescriptor");
                        KotlinType kotlinType = valueParameterDescriptor.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"actualParameterDescriptor.type");
                        if (Intrinsics.areEqual((Object)DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(kotlinType), (Object)expectedTypeString) ^ true) {
                            return false;
                        }
                        if (i == n2) break;
                        ++i;
                    }
                }
                return true;
            }
            {
                this.$parameterTypes = stringArray;
                super(2);
            }
        });
    }

    @NotNull
    public final KotlinFunctionPattern withReceiver(@NotNull String receiverFqName) {
        Intrinsics.checkNotNullParameter((Object)receiverFqName, (String)"receiverFqName");
        return (KotlinFunctionPattern)KotlinPatternsKt.access$withPatternCondition(this, "kotlinFunctionPattern-withReceiver", (Function2)new Function2<KtFunction, ProcessingContext, Boolean>(receiverFqName){
            final /* synthetic */ String $receiverFqName;

            public final boolean invoke(@NotNull KtFunction function2, @Nullable ProcessingContext $noName_1) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                if (function2.getReceiverTypeReference() == null) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)this.$receiverFqName, (Object)"?")) {
                    return true;
                }
                DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtDeclaration)((KtDeclaration)function2), null, (int)1, null);
                if (!(declarationDescriptor instanceof FunctionDescriptor)) {
                    declarationDescriptor = null;
                }
                FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)declarationDescriptor;
                if (functionDescriptor2 == null) {
                    return false;
                }
                FunctionDescriptor descriptor2 = functionDescriptor2;
                ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
                if (receiverParameterDescriptor == null) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)receiverParameterDescriptor, (String)"descriptor.extensionRece\u2026ithPatternCondition false");
                ReceiverParameterDescriptor receiver = receiverParameterDescriptor;
                KotlinType kotlinType = receiver.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"receiver.type");
                return Intrinsics.areEqual((Object)DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(kotlinType), (Object)this.$receiverFqName);
            }
            {
                this.$receiverFqName = string;
                super(2);
            }
        });
    }

    @NotNull
    public final KotlinFunctionPattern definedInClass(@NotNull String fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        ObjectPattern objectPattern = this.with(new DefinedInClassCondition(fqName));
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(DefinedInClassCondition(fqName))");
        return (KotlinFunctionPattern)objectPattern;
    }

    @NotNull
    public final KotlinFunctionPattern definedInPackage(@NotNull String packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return (KotlinFunctionPattern)KotlinPatternsKt.access$withPatternCondition(this, "kotlinFunctionPattern-definedInPackage", (Function2)new Function2<KtFunction, ProcessingContext, Boolean>(packageFqName){
            final /* synthetic */ String $packageFqName;

            public final boolean invoke(@NotNull KtFunction function2, @Nullable ProcessingContext $noName_1) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                if (!(function2.getParent() instanceof KtFile)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)function2.getContainingKtFile().getPackageFqName().asString(), (Object)this.$packageFqName);
            }
            {
                this.$packageFqName = string;
                super(2);
            }
        });
    }

    public KotlinFunctionPattern() {
        super(KtFunction.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/patterns/KotlinFunctionPattern$DefinedInClassCondition;", "Lcom/intellij/patterns/PatternCondition;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "fqName", "", "(Ljava/lang/String;)V", "getFqName", "()Ljava/lang/String;", "accepts", "", "element", "context", "Lcom/intellij/util/ProcessingContext;", "kotlin.idea"})
    public static final class DefinedInClassCondition
    extends PatternCondition<KtFunction> {
        @NotNull
        private final String fqName;

        public boolean accepts(@NotNull KtFunction element3, @Nullable ProcessingContext context2) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            if (element3.getParent() instanceof KtFile) {
                return false;
            }
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)element3));
            return Intrinsics.areEqual((Object)(ktClassOrObject != null && (ktClassOrObject = ktClassOrObject.getFqName()) != null ? ktClassOrObject.asString() : null), (Object)this.fqName);
        }

        @NotNull
        public final String getFqName() {
            return this.fqName;
        }

        public DefinedInClassCondition(@NotNull String fqName) {
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            super("kotlinFunctionPattern-definedInClass");
            this.fqName = fqName;
        }
    }
}

