/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.segments;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;

public class SegmentReader {
    @NonNls
    private final String myString;
    private final char[] myChars;
    private int myPosition = 0;

    public SegmentReader(@NonNls String packet) {
        this.myString = packet;
        this.myChars = packet.toCharArray();
    }

    public String upTo(char symbol) {
        int position;
        for (position = this.myPosition; position < this.myChars.length && this.myChars[position] != symbol; ++position) {
        }
        String result = this.advanceTo(position);
        this.skip(1);
        return result;
    }

    public void skip(int count) {
        this.myPosition = Math.min(this.myChars.length, this.myPosition + count);
    }

    public String upToEnd() {
        return this.advanceTo(this.myChars.length);
    }

    private String advanceTo(int position) {
        String result = this.myString.substring(this.myPosition, position);
        this.myPosition = position;
        return result;
    }

    @NlsSafe
    public String readLimitedString() {
        int symbolCount = this.readInt();
        return this.advanceTo(this.myPosition + symbolCount);
    }

    public int readInt() {
        String intString = this.upTo(' ');
        return Integer.parseInt(intString);
    }

    public long readLong() {
        String longString = this.upTo(' ');
        return Long.parseLong(longString);
    }

    public char readChar() {
        ++this.myPosition;
        return this.myChars[this.myPosition - 1];
    }

    public boolean isAtEnd() {
        return this.myPosition == this.myChars.length;
    }

    public String[] readStringArray() {
        int count = this.readInt();
        if (count == 0) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> strings = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            strings.add(this.readLimitedString());
        }
        return strings.toArray(new String[count]);
    }
}

