/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.indices.impl;

import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsExcludePattern;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

public final class ModuleExcludeIndexImpl
implements ModuleExcludeIndex {
    private final Set<File> myExcludedRoots = FileCollectionFactory.createCanonicalFileSet();
    private final Set<File> myTopLevelContentRoots = FileCollectionFactory.createCanonicalFileSet();
    private final Map<JpsModule, ArrayList<File>> myModuleToExcludesMap = new HashMap<JpsModule, ArrayList<File>>();
    private final Map<JpsModule, List<File>> myModuleToContentMap = new HashMap<JpsModule, List<File>>();
    private final Map<File, FileTypeAssocTable<Boolean>> myExcludeFromContentRootTables = FileCollectionFactory.createCanonicalFileMap();

    public ModuleExcludeIndexImpl(JpsModel model) {
        String url;
        List allModules = model.getProject().getModules();
        Map contentToModule = FileCollectionFactory.createCanonicalFileMap();
        MultiMap excludePatterns = MultiMap.createLinked();
        for (Object module : allModules) {
            ArrayList<File> moduleExcludes = new ArrayList<File>();
            for (String url2 : module.getExcludeRootsList().getUrls()) {
                moduleExcludes.add(JpsPathUtil.urlToFile((String)url2));
            }
            JpsJavaModuleExtension moduleExtension = JpsJavaExtensionService.getInstance().getModuleExtension((JpsModule)module);
            if (moduleExtension != null && !moduleExtension.isInheritOutput() && moduleExtension.isExcludeOutput()) {
                String string;
                String outputUrl = moduleExtension.getOutputUrl();
                if (outputUrl != null) {
                    moduleExcludes.add(JpsPathUtil.urlToFile((String)outputUrl));
                }
                if ((string = moduleExtension.getTestOutputUrl()) != null) {
                    moduleExcludes.add(JpsPathUtil.urlToFile((String)string));
                }
            }
            for (JpsExcludePattern jpsExcludePattern : module.getExcludePatterns()) {
                excludePatterns.putValue((Object)jpsExcludePattern.getBaseDirUrl(), (Object)jpsExcludePattern.getPattern());
            }
            List contentUrls = module.getContentRootsList().getUrls();
            ArrayList<File> arrayList = new ArrayList<File>(contentUrls.size());
            Iterator<File> iterator = contentUrls.iterator();
            while (iterator.hasNext()) {
                String contentUrl = (String)((Object)iterator.next());
                File contentRoot = JpsPathUtil.urlToFile((String)contentUrl);
                arrayList.add(contentRoot);
                contentToModule.put(contentRoot, module);
            }
            for (JpsModuleSourceRoot root : module.getSourceRoots()) {
                File sourceRoot = root.getFile();
                arrayList.add(sourceRoot);
                contentToModule.put(sourceRoot, module);
            }
            this.myModuleToExcludesMap.put((JpsModule)module, moduleExcludes);
            this.myModuleToContentMap.put((JpsModule)module, arrayList);
            this.myExcludedRoots.addAll(moduleExcludes);
        }
        FileNameMatcherFactory factory = FileNameMatcherFactory.getInstance();
        for (Map.Entry entry : excludePatterns.entrySet()) {
            FileTypeAssocTable table = new FileTypeAssocTable();
            for (String string : (Collection)entry.getValue()) {
                table.addAssociation(factory.createMatcher(string), (Object)Boolean.TRUE);
            }
            this.myExcludeFromContentRootTables.put(JpsPathUtil.urlToFile((String)((String)entry.getKey())), (FileTypeAssocTable<Boolean>)table);
        }
        JpsJavaProjectExtension projectExtension = JpsJavaExtensionService.getInstance().getProjectExtension(model.getProject());
        if (projectExtension != null && !Strings.isEmpty((String)(url = projectExtension.getOutputUrl()))) {
            File excluded;
            File parent = excluded = JpsPathUtil.urlToFile((String)url);
            while (parent != null) {
                JpsModule jpsModule = (JpsModule)contentToModule.get(parent);
                if (jpsModule != null) {
                    this.myModuleToExcludesMap.get(jpsModule).add(excluded);
                }
                parent = FileUtilRt.getParentFile((File)parent);
            }
            this.myExcludedRoots.add(excluded);
        }
        ArrayList<File> parents = new ArrayList<File>();
        Set notUnderExcludedCache = FileCollectionFactory.createCanonicalFileSet();
        for (JpsModule jpsModule : allModules) {
            for (File contentRoot : this.myModuleToContentMap.get(jpsModule)) {
                Object parentModule = null;
                parents.clear();
                for (File parent = contentRoot.getParentFile(); parent != null; parent = parent.getParentFile()) {
                    parents.add(parent);
                    if (!contentToModule.containsKey(parent)) continue;
                    parentModule = (JpsModule)contentToModule.get(parent);
                    break;
                }
                if (parentModule != null) {
                    if (!parentModule.equals(jpsModule)) {
                        this.myModuleToExcludesMap.get(parentModule).add(contentRoot);
                    }
                    if (ModuleExcludeIndexImpl.isUnderExcluded(contentRoot, this.myExcludedRoots, notUnderExcludedCache)) {
                        this.myTopLevelContentRoots.add(contentRoot);
                    }
                } else {
                    this.myTopLevelContentRoots.add(contentRoot);
                }
                for (File file : parents) {
                    contentToModule.put(file, parentModule);
                }
            }
        }
        for (List list : this.myModuleToExcludesMap.values()) {
            ((ArrayList)list).trimToSize();
        }
    }

    private static boolean isUnderExcluded(File root, Set<? extends File> excluded, Set<? super File> notUnderExcludedCache) {
        ArrayList<File> parents = new ArrayList<File>();
        for (File parent = root; parent != null; parent = parent.getParentFile()) {
            if (notUnderExcludedCache.contains(parent)) {
                return false;
            }
            if (excluded.contains(parent)) {
                return true;
            }
            parents.add(parent);
        }
        notUnderExcludedCache.addAll(parents);
        return false;
    }

    @Override
    public boolean isExcluded(File file) {
        return this.determineFileLocation(file, this.myTopLevelContentRoots, this.myExcludedRoots) == FileLocation.EXCLUDED;
    }

    @Override
    public boolean isExcludedFromModule(File file, JpsModule module) {
        return this.determineFileLocation(file, (Collection<File>)this.myModuleToContentMap.get(module), (Collection<File>)this.myModuleToExcludesMap.get(module)) == FileLocation.EXCLUDED;
    }

    @Override
    public boolean isInContent(File file) {
        return this.determineFileLocation(file, this.myTopLevelContentRoots, this.myExcludedRoots) == FileLocation.IN_CONTENT;
    }

    private FileLocation determineFileLocation(File file, Collection<File> roots, Collection<File> excluded) {
        if (roots.isEmpty() && excluded.isEmpty()) {
            return FileLocation.NOT_IN_PROJECT;
        }
        File current = file;
        while (current != null) {
            if (excluded.contains(current)) {
                return FileLocation.EXCLUDED;
            }
            FileTypeAssocTable<Boolean> table = this.myExcludeFromContentRootTables.get(current);
            if (table != null && ModuleExcludeIndexImpl.isExcludedByPattern(file, current, table)) {
                return FileLocation.EXCLUDED;
            }
            if (roots.contains(current)) {
                return FileLocation.IN_CONTENT;
            }
            current = FileUtilRt.getParentFile((File)current);
        }
        return FileLocation.NOT_IN_PROJECT;
    }

    private static boolean isExcludedByPattern(File file, File root, FileTypeAssocTable<Boolean> table) {
        File current = file;
        while (current != null && !current.equals(root)) {
            if (table.findAssociatedFileType((CharSequence)current.getName()) != null) {
                return true;
            }
            current = FileUtilRt.getParentFile((File)current);
        }
        return false;
    }

    @Override
    public Collection<File> getModuleExcludes(JpsModule module) {
        return this.myModuleToExcludesMap.get(module);
    }

    private static enum FileLocation {
        IN_CONTENT,
        EXCLUDED,
        NOT_IN_PROJECT;

    }
}

