/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.local;

import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import org.jetbrains.annotations.NotNull;

public class SetDefault
implements ChangeListCommand {
    private final String myNewDefaultName;
    private final boolean myAutomatic;
    private boolean myResult;
    private LocalChangeList myOldDefaultListCopy;
    private LocalChangeList myNewDefaultListCopy;

    public SetDefault(@NotNull String newDefaultName, boolean automatic) {
        if (newDefaultName == null) {
            SetDefault.$$$reportNull$$$0(0);
        }
        this.myNewDefaultName = newDefaultName;
        this.myAutomatic = automatic;
    }

    @Override
    public void apply(ChangeListWorker worker) {
        LocalChangeList list = worker.getChangeListByName(this.myNewDefaultName);
        if (list == null || list.isDefault()) {
            this.myOldDefaultListCopy = null;
            this.myNewDefaultListCopy = null;
            this.myResult = false;
            return;
        }
        String oldDefaultName = worker.setDefaultList(this.myNewDefaultName);
        this.myOldDefaultListCopy = worker.getChangeListByName(oldDefaultName);
        this.myNewDefaultListCopy = worker.getChangeListByName(this.myNewDefaultName);
        this.myResult = oldDefaultName != null;
    }

    @Override
    public void doNotify(ChangeListListener listener2) {
        if (this.myOldDefaultListCopy != null && this.myNewDefaultListCopy != null && this.myResult) {
            listener2.defaultListChanged((ChangeList)this.myOldDefaultListCopy, (ChangeList)this.myNewDefaultListCopy, this.myAutomatic);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDefaultName", "com/intellij/openapi/vcs/changes/local/SetDefault", "<init>"));
    }
}

