/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.HttpRequests;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.project.actions.UseWrapperAction;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenWrapperMapping;
import org.jetbrains.idea.maven.server.MavenWrapperSupport;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0013H\u0002J\u001a\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001a\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/idea/maven/server/MavenWrapperSupport;", "", "()V", "DISTS_DIR", "", "getDISTS_DIR", "()Ljava/lang/String;", "myMapping", "Lorg/jetbrains/idea/maven/server/MavenWrapperMapping;", "downloadAndInstallMaven", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "urlString", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getDistName", "distUrl", "getMd5Hash", "string", "getZipFile", "Ljava/io/File;", "distributionUrl", "makeMavenBinRunnable", "", "mavenHome", "unpackZipFile", "zipFile", "unzip", "zip", "Companion", "intellij.maven"})
public final class MavenWrapperSupport {
    private final MavenWrapperMapping myMapping = MavenWrapperMapping.Companion.getInstance();
    @NotNull
    private final String DISTS_DIR;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getDISTS_DIR() {
        return this.DISTS_DIR;
    }

    @NotNull
    public final MavenDistribution downloadAndInstallMaven(@NotNull String urlString, @Nullable ProgressIndicator indicator) throws IOException {
        File zipFile;
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        String cachedHome = this.myMapping.getMyState$intellij_maven().getMapping().get(urlString);
        if (cachedHome != null) {
            File file = new File(cachedHome);
            if (file.isDirectory()) {
                return new MavenDistribution(file, urlString);
            }
            this.myMapping.getMyState$intellij_maven().getMapping().remove(urlString);
        }
        if (!(zipFile = this.getZipFile(urlString)).isFile()) {
            File partFile = new File(zipFile.getParentFile(), zipFile.getName() + ".part-" + System.currentTimeMillis());
            ProgressIndicator progressIndicator = indicator;
            if (progressIndicator != null) {
                ProgressIndicator progressIndicator2 = progressIndicator;
                boolean bl = false;
                boolean bl2 = false;
                ProgressIndicator $this$apply = progressIndicator2;
                boolean bl3 = false;
                $this$apply.setText(SyncBundle.message("maven.sync.wrapper.dowloading.from", urlString));
            }
            HttpRequests.request((String)urlString).forceHttps(true).connectTimeout(30000).readTimeout(30000).saveToFile(partFile, indicator);
            FileUtil.rename((File)partFile, (File)zipFile);
        }
        if (!zipFile.isFile()) {
            throw (Throwable)new RuntimeException(SyncBundle.message("cannot.download.zip.from", urlString));
        }
        File home = this.unpackZipFile(zipFile, indicator).getCanonicalFile();
        Map map = this.myMapping.getMyState$intellij_maven().getMapping();
        File file = home;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"home");
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"home.absolutePath");
        map.put(urlString, string);
        return new MavenDistribution(home, urlString);
    }

    private final File unpackZipFile(File zipFile, ProgressIndicator indicator) {
        this.unzip(zipFile, indicator);
        Object[] dirs2 = zipFile.getParentFile().listFiles(unpackZipFile.dirs.1.INSTANCE);
        if (dirs2 == null || dirs2.length != 1) {
            MavenLog.LOG.warn("Expected exactly 1 top level dir in Maven distribution, found: " + (dirs2 != null ? ArraysKt.asList((Object[])dirs2) : null));
            throw (Throwable)new IllegalStateException(SyncBundle.message("zip.is.not.correct", zipFile.getAbsoluteFile()));
        }
        File mavenHome = dirs2[0];
        if (!SystemInfo.isWindows) {
            this.makeMavenBinRunnable(mavenHome);
        }
        File file = mavenHome;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"mavenHome");
        return file;
    }

    private final void makeMavenBinRunnable(File mavenHome) {
        File mvnExe = new File(mavenHome, "bin/mvn").getCanonicalFile();
        Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwxr-xr-x");
        Files.setPosixFilePermissions(mvnExe.toPath(), permissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unzip(File zip, ProgressIndicator indicator) {
        File unpackDir;
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            ProgressIndicator progressIndicator2 = progressIndicator;
            boolean bl = false;
            boolean bl2 = false;
            ProgressIndicator $this$apply = progressIndicator2;
            boolean bl3 = false;
            $this$apply.setText(SyncBundle.message("maven.sync.wrapper.unpacking", new Object[0]));
        }
        File file = unpackDir = zip.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"unpackDir");
        String destinationCanonicalPath = file.getCanonicalPath();
        boolean errorUnpacking = false;
        Closeable closeable = new ZipFile(zip);
        boolean bl = false;
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl5 = false;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"zipFile.entries()");
            Enumeration<? extends ZipEntry> entries = enumeration;
            while (entries.hasMoreElements()) {
                String canonicalPath;
                ZipEntry entry;
                if (entries.nextElement() == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.util.zip.ZipEntry");
                }
                File destFile = new File(unpackDir, entry.getName());
                String string = canonicalPath = destFile.getCanonicalPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"canonicalPath");
                String string2 = destinationCanonicalPath;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"destinationCanonicalPath");
                if (!StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                    FileUtil.delete((File)zip);
                    throw (Throwable)new RuntimeException("Directory traversal attack detected, zip file is malicious and IDEA dropped it");
                }
                if (entry.isDirectory()) {
                    destFile.mkdirs();
                    continue;
                }
                destFile.getParentFile().mkdirs();
                Closeable closeable2 = new BufferedOutputStream(new FileOutputStream(destFile));
                boolean bl6 = false;
                boolean bl7 = false;
                Throwable throwable2 = null;
                try {
                    BufferedOutputStream it = (BufferedOutputStream)closeable2;
                    boolean bl8 = false;
                    int n = StreamUtil.copy((InputStream)zipFile.getInputStream(entry), (OutputStream)it);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            zipFile = Unit.INSTANCE;
        }
        catch (Throwable zipFile) {
            throwable = zipFile;
            throw zipFile;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        errorUnpacking = false;
        ProgressIndicator progressIndicator3 = indicator;
        if (progressIndicator3 != null) {
            closeable = progressIndicator3;
            bl = false;
            boolean bl9 = false;
            Closeable $this$apply = closeable;
            boolean bl10 = false;
            $this$apply.setText(SyncBundle.message("maven.sync.wrapper.unpacked.into", destinationCanonicalPath));
        }
    }

    @NotNull
    public final File getZipFile(@NotNull String distributionUrl) {
        Intrinsics.checkNotNullParameter((Object)distributionUrl, (String)"distributionUrl");
        String baseName = this.getDistName(distributionUrl);
        String string = FileUtil.getNameWithoutExtension((String)baseName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.getNameWithoutExtension(baseName)");
        String distName = string;
        String md5Hash = this.getMd5Hash(distributionUrl);
        File file = MavenUtil.resolveM2Dir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"MavenUtil.resolveM2Dir()");
        File m2dir = file;
        File distsDir = new File(m2dir, this.DISTS_DIR);
        File file2 = new File(new File(new File(distsDir, distName), md5Hash), baseName).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"File(File(File(distsDir,\u2026), baseName).absoluteFile");
        return file2;
    }

    private final String getDistName(String distUrl) {
        String string;
        int p = StringsKt.lastIndexOf$default((CharSequence)distUrl, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (p < 0) {
            string = distUrl;
        } else {
            String string2 = distUrl;
            int n = p + 1;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        }
        return string;
    }

    private final String getMd5Hash(String string) {
        String string2;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            String string3 = string;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string4.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] bytes = byArray;
            messageDigest.update(bytes);
            String string5 = new BigInteger(1, messageDigest.digest()).toString(32);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"BigInteger(1, messageDigest.digest()).toString(32)");
            string2 = string5;
        }
        catch (Exception var4) {
            throw (Throwable)new RuntimeException("Could not hash input string.", var4);
        }
        return string2;
    }

    public MavenWrapperSupport() {
        this.DISTS_DIR = "wrapper/dists";
    }

    @JvmStatic
    public static final boolean hasWrapperConfigured(@NotNull VirtualFile baseDir) {
        return Companion.hasWrapperConfigured(baseDir);
    }

    @JvmStatic
    @Nullable
    public static final String getWrapperDistributionUrl(@Nullable VirtualFile baseDir) {
        return Companion.getWrapperDistributionUrl(baseDir);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/maven/server/MavenWrapperSupport$Companion;", "", "()V", "getWrapperDistributionUrl", "", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "hasWrapperConfigured", "", "intellij.maven"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean hasWrapperConfigured(@NotNull VirtualFile baseDir) {
            Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
            if (!UseWrapperAction.canUseWrapper()) return false;
            CharSequence charSequence = this.getWrapperDistributionUrl(baseDir);
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null) return false;
            if (charSequence.length() != 0) return true;
            return false;
        }

        @JvmStatic
        @Nullable
        public final String getWrapperDistributionUrl(@Nullable VirtualFile baseDir) {
            if (UseWrapperAction.canUseWrapper()) {
                return null;
            }
            VirtualFile virtualFile = baseDir;
            if (virtualFile == null || (virtualFile = virtualFile.findChild(".mvn")) == null || (virtualFile = virtualFile.findChild("wrapper")) == null || (virtualFile = virtualFile.findChild("maven-wrapper.properties")) == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"baseDir?.findChild(\".mvn\u2026operties\") ?: return null");
            VirtualFile wrapperProperties = virtualFile;
            Properties properties = new Properties();
            ByteArrayInputStream stream = new ByteArrayInputStream(wrapperProperties.contentsToByteArray(true));
            properties.load(stream);
            return properties.getProperty("distributionUrl");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

