/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiType;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleLog;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;

public class GradleResolverUtil {
    public static int getGrMethodArumentsCount(@NotNull GrArgumentList args) {
        if (args == null) {
            GradleResolverUtil.$$$reportNull$$$0(0);
        }
        int argsCount = 0;
        boolean namedArgProcessed = false;
        for (GroovyPsiElement arg : args.getAllArguments()) {
            if (arg instanceof GrNamedArgument) {
                if (namedArgProcessed) continue;
                namedArgProcessed = true;
                ++argsCount;
                continue;
            }
            ++argsCount;
        }
        return argsCount;
    }

    @Nullable
    public static GrLightMethodBuilder createMethodWithClosure(@NotNull String name, @Nullable String returnType, @Nullable String closureTypeParameter, @NotNull PsiElement place) {
        PsiClassType closureType;
        PsiClassType closureClassTypeParameter;
        PsiClass closureClass;
        if (name == null) {
            GradleResolverUtil.$$$reportNull$$$0(1);
        }
        if (place == null) {
            GradleResolverUtil.$$$reportNull$$$0(2);
        }
        if ((closureClass = JavaPsiFacade.getInstance((Project)place.getProject()).findClass("groovy.lang.Closure", place.getResolveScope())) == null) {
            return null;
        }
        if (closureClass.getTypeParameters().length != 1) {
            GradleLog.LOG.debug(String.format("Unexpected type parameters found for closureClass(%s) : (%s)", closureClass, Arrays.toString(closureClass.getTypeParameters())));
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)place.getManager().getProject());
        if (closureTypeParameter != null) {
            closureClassTypeParameter = factory.createTypeByFQClassName(closureTypeParameter, place.getResolveScope());
            closureType = factory.createType(closureClass, (PsiType)closureClassTypeParameter);
        } else {
            closureClassTypeParameter = factory.createTypeByFQClassName("java.lang.Object", place.getResolveScope());
            closureType = factory.createType(closureClass, (PsiType)closureClassTypeParameter);
        }
        GrLightMethodBuilder methodWithClosure = new GrLightMethodBuilder(place.getManager(), name);
        GrLightParameter closureParameter = new GrLightParameter("closure", (PsiType)closureType, (PsiElement)methodWithClosure);
        methodWithClosure.addParameter((GrParameter)closureParameter);
        PsiClassType retType = factory.createTypeByFQClassName(returnType != null ? returnType : "java.lang.Object", place.getResolveScope());
        methodWithClosure.setReturnType((PsiType)retType);
        methodWithClosure.setContainingClass(retType.resolve());
        return methodWithClosure;
    }

    @Nullable
    public static PsiElement findParent(@NotNull PsiElement element, int level) {
        if (element == null) {
            GradleResolverUtil.$$$reportNull$$$0(3);
        }
        PsiElement parent = element;
        while ((parent = parent.getParent()) != null && --level > 0) {
        }
        return parent;
    }

    @Nullable
    public static <T extends PsiElement> T findParent(@NotNull PsiElement element, Class<T> clazz) {
        if (element == null) {
            GradleResolverUtil.$$$reportNull$$$0(4);
        }
        PsiElement parent = element;
        do {
            if (!clazz.isInstance(parent = parent.getParent())) continue;
            return (T)parent;
        } while (parent != null && !(parent instanceof GroovyFile));
        return null;
    }

    public static boolean canBeMethodOf(@Nullable String methodName, @Nullable PsiClass aClass) {
        return methodName != null && aClass != null && aClass.findMethodsByName(methodName, true).length != 0;
    }

    @Nullable
    public static PsiType getTypeOf(@Nullable GrExpression expression) {
        if (expression == null) {
            return null;
        }
        return (PsiType)RecursionManager.doPreventingRecursion((Object)expression, (boolean)true, () -> expression.getNominalType());
    }

    public static boolean isLShiftElement(@Nullable PsiElement psiElement) {
        return psiElement instanceof GrBinaryExpression && GroovyElementTypes.COMPOSITE_LSHIFT_SIGN.equals(((GrBinaryExpression)psiElement).getOperationTokenType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getGrMethodArumentsCount";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createMethodWithClosure";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findParent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

