/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.execution.Location;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J.\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0007J\"\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0015\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J$\u0010\u0016\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0004*\u00020\u000eH\u0002J\f\u0010\u001b\u001a\u00020\n*\u00020\u000eH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/gradle/util/GradleExecutionSettingsUtil;", "", "()V", "createLocationName", "", "aClass", "method", "createTestFilter", "filter", "hasSuffix", "", "createTestFilterFrom", "location", "Lcom/intellij/execution/Location;", "Lcom/intellij/psi/PsiClass;", "Lcom/intellij/psi/PsiMethod;", "psiMethod", "psiClass", "methodName", "psiPackage", "Lcom/intellij/psi/PsiPackage;", "createTestFilterFromClass", "createTestFilterFromMethod", "createTestFilterFromPackage", "aPackage", "createTestWildcardFilter", "getRuntimeQualifiedName", "isParameterized", "intellij.gradle.java"})
@ApiStatus.Experimental
public final class GradleExecutionSettingsUtil {
    public static final GradleExecutionSettingsUtil INSTANCE;

    private final String createTestFilter(String filter, boolean hasSuffix) {
        String string;
        if (hasSuffix) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "--tests %s ";
            Object[] objectArray = new Object[]{filter};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        } else {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string4 = "--tests %s";
            Object[] objectArray = new Object[]{filter};
            boolean bl = false;
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
        }
        return string;
    }

    private final String createTestFilterFrom(String filter, boolean hasSuffix) {
        String escaped = StringsKt.replace$default((String)filter, (char)'\"', (char)'*', (boolean)false, (int)4, null);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "\"%s\"";
        Object[] objectArray = new Object[]{escaped};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String wrapped = string2;
        return this.createTestFilter(wrapped, hasSuffix);
    }

    private final String createLocationName(String aClass, String method) {
        if (aClass == null) {
            return "";
        }
        String string = method;
        String escapedMethod = string != null ? StringsKt.replace$default((String)string, (char)'.', (char)'*', (boolean)false, (int)4, null) : null;
        return aClass + (escapedMethod == null ? "" : '.' + escapedMethod);
    }

    @JvmStatic
    @NotNull
    public static final String createTestFilterFromMethod(@Nullable String aClass, @Nullable String method, boolean hasSuffix) {
        return INSTANCE.createTestFilterFrom(INSTANCE.createLocationName(aClass, method), hasSuffix);
    }

    @JvmStatic
    @NotNull
    public static final String createTestFilterFromClass(@Nullable String aClass, boolean hasSuffix) {
        if (aClass == null) {
            return "";
        }
        return INSTANCE.createTestFilterFrom(aClass, hasSuffix);
    }

    @JvmStatic
    @NotNull
    public static final String createTestWildcardFilter(boolean hasSuffix) {
        return INSTANCE.createTestFilter("*", hasSuffix);
    }

    @JvmStatic
    @NotNull
    public static final String createTestFilterFromPackage(@NotNull String aPackage, boolean hasSuffix) {
        Intrinsics.checkNotNullParameter((Object)aPackage, (String)"aPackage");
        CharSequence charSequence = aPackage;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return GradleExecutionSettingsUtil.createTestWildcardFilter(hasSuffix);
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s.*";
        Object[] objectArray = new Object[]{aPackage};
        boolean bl2 = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String packageFilter = string2;
        return INSTANCE.createTestFilterFrom(packageFilter, hasSuffix);
    }

    @JvmStatic
    @NotNull
    public static final String createTestFilterFrom(@NotNull PsiClass psiClass, boolean hasSuffix) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return GradleExecutionSettingsUtil.createTestFilterFromClass(INSTANCE.getRuntimeQualifiedName(psiClass), hasSuffix);
    }

    @JvmStatic
    @NotNull
    public static final String createTestFilterFrom(@NotNull PsiClass psiClass, @Nullable String methodName, boolean hasSuffix) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return GradleExecutionSettingsUtil.createTestFilterFromMethod(INSTANCE.getRuntimeQualifiedName(psiClass), methodName, hasSuffix);
    }

    @JvmStatic
    @NotNull
    public static final String createTestFilterFrom(@NotNull PsiClass aClass, @NotNull PsiMethod psiMethod, boolean hasSuffix) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        return GradleExecutionSettingsUtil.createTestFilterFrom(aClass, psiMethod.getName(), hasSuffix);
    }

    @JvmStatic
    @NotNull
    public static final String createTestFilterFrom(@NotNull PsiPackage psiPackage, boolean hasSuffix) {
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        String string = psiPackage.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"psiPackage.qualifiedName");
        return GradleExecutionSettingsUtil.createTestFilterFromPackage(string, hasSuffix);
    }

    @JvmStatic
    @NotNull
    public static final String createTestFilterFrom(@Nullable Location<?> location, @NotNull PsiClass aClass, @NotNull PsiMethod method, boolean hasSuffix) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String locationName = INSTANCE.createLocationName(INSTANCE.getRuntimeQualifiedName(aClass), method.getName());
        if (location instanceof PsiMemberParameterizedLocation) {
            String wrappedParamSetName;
            String string = wrappedParamSetName = ((PsiMemberParameterizedLocation)location).getParamSetName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrappedParamSetName");
            CharSequence charSequence = string;
            boolean bl = false;
            if (charSequence.length() > 0) {
                String paramSetName = StringsKt.removeSurrounding((String)wrappedParamSetName, (CharSequence)"[", (CharSequence)"]");
                locationName = locationName + "[*" + paramSetName + "*]";
            }
        } else if (INSTANCE.isParameterized(aClass)) {
            locationName = locationName + "[*]";
        }
        return INSTANCE.createTestFilterFrom(locationName, hasSuffix);
    }

    private final String getRuntimeQualifiedName(PsiClass $this$getRuntimeQualifiedName) {
        PsiElement parent = $this$getRuntimeQualifiedName.getParent();
        PsiElement psiElement = parent;
        return psiElement instanceof PsiClass ? this.getRuntimeQualifiedName((PsiClass)parent) + "$" + $this$getRuntimeQualifiedName.getName() : $this$getRuntimeQualifiedName.getQualifiedName();
    }

    private final boolean isParameterized(PsiClass $this$isParameterized) {
        PsiAnnotation annotation = JUnitUtil.getRunWithAnnotation((PsiClass)$this$isParameterized);
        return annotation != null && JUnitUtil.isParameterized((PsiAnnotation)annotation);
    }

    private GradleExecutionSettingsUtil() {
    }

    static {
        GradleExecutionSettingsUtil gradleExecutionSettingsUtil;
        INSTANCE = gradleExecutionSettingsUtil = new GradleExecutionSettingsUtil();
    }
}

