/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.Platform;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShStringUtil;
import com.intellij.sh.run.ShBeforeRunProviderDelegate;
import com.intellij.sh.run.ShRunConfiguration;
import com.intellij.sh.run.ShRunner;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShRunConfigurationProfileState
implements RunProfileState {
    private final Project myProject;
    private final ShRunConfiguration myRunConfiguration;

    public ShRunConfigurationProfileState(@NotNull Project project, @NotNull ShRunConfiguration runConfiguration) {
        if (project == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        ShRunner shRunner;
        if (runner == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(2);
        }
        if ((shRunner = (ShRunner)ServiceManager.getService((Project)this.myProject, ShRunner.class)) == null || !this.myRunConfiguration.isExecuteInTerminal() || !shRunner.isAvailable(this.myProject) || this.isRunBeforeConfig()) {
            return this.buildExecutionResult();
        }
        shRunner.run(this.buildCommand(), this.myRunConfiguration.getScriptWorkingDirectory(), this.myRunConfiguration.getName(), this.isActivateToolWindow());
        return null;
    }

    private boolean isActivateToolWindow() {
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)this.myProject).findSettings((RunConfiguration)this.myRunConfiguration);
        if (settings == null) {
            return true;
        }
        return settings.isActivateToolWindowBeforeRun();
    }

    private ExecutionResult buildExecutionResult() throws ExecutionException {
        GeneralCommandLine commandLine = this.createCommandLine();
        ProcessHandler processHandler = ShRunConfigurationProfileState.createProcessHandler(commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        TerminalExecutionConsole console = new TerminalExecutionConsole(this.myProject, processHandler);
        console.attachToProcess(processHandler);
        return new DefaultExecutionResult((ExecutionConsole)console, processHandler);
    }

    @NotNull
    private static ProcessHandler createProcessHandler(GeneralCommandLine commandLine) throws ExecutionException {
        return new KillableProcessHandler(commandLine){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                return new BaseOutputReader.Options(){

                    public BaseDataReader.SleepingPolicy policy() {
                        return BaseDataReader.SleepingPolicy.BLOCKING;
                    }

                    public boolean splitToLines() {
                        return false;
                    }

                    public boolean withSeparators() {
                        return true;
                    }
                };
            }
        };
    }

    @NotNull
    private GeneralCommandLine createCommandLine() throws ExecutionException {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(this.myRunConfiguration.getScriptPath());
        if (virtualFile == null || virtualFile.getParent() == null) {
            throw new ExecutionException(ShBundle.message("error.message.cannot.determine.shell.script.parent.directory", new Object[0]));
        }
        WSLDistribution wslDistribution = ShRunConfiguration.getWSLDistributionIfNeeded(this.myRunConfiguration.getInterpreterPath(), this.myRunConfiguration.getScriptPath());
        PtyCommandLine commandLine = new PtyCommandLine();
        if (!SystemInfo.isWindows || wslDistribution != null) {
            commandLine.getEnvironment().put("TERM", "xterm-256color");
        }
        commandLine.withConsoleMode(false);
        commandLine.withInitialColumns(120);
        commandLine.withEnvironment(this.myRunConfiguration.getEnvData().getEnvs());
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.setWorkDirectory(ShRunConfigurationProfileState.convertToWslIfNeeded(this.myRunConfiguration.getScriptWorkingDirectory(), wslDistribution));
        commandLine.setExePath(this.myRunConfiguration.getInterpreterPath());
        if (StringUtil.isNotEmpty((String)this.myRunConfiguration.getInterpreterOptions())) {
            commandLine.addParameters(ParametersListUtil.parse((String)this.myRunConfiguration.getInterpreterOptions()));
        }
        commandLine.addParameter(ShRunConfigurationProfileState.convertToWslIfNeeded(this.myRunConfiguration.getScriptPath(), wslDistribution));
        if (StringUtil.isNotEmpty((String)this.myRunConfiguration.getScriptOptions())) {
            commandLine.addParameters(ParametersListUtil.parse((String)this.myRunConfiguration.getScriptOptions()));
        }
        if (wslDistribution != null) {
            commandLine = (PtyCommandLine)wslDistribution.patchCommandLine((GeneralCommandLine)commandLine, this.myProject, null, false);
        }
        PtyCommandLine ptyCommandLine = commandLine;
        if (ptyCommandLine == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(3);
        }
        return ptyCommandLine;
    }

    private boolean isRunBeforeConfig() {
        Key<Boolean> userDataKey = ShBeforeRunProviderDelegate.getRunBeforeUserDataKey((RunConfiguration)this.myRunConfiguration);
        Boolean userDataValue = (Boolean)this.myProject.getUserData(userDataKey);
        boolean isRunBeforeConfig = userDataValue != null && userDataValue != false;
        this.myRunConfiguration.getProject().putUserData(userDataKey, (Object)false);
        return isRunBeforeConfig;
    }

    @NotNull
    private String buildCommand() {
        WSLDistribution wslDistribution = ShRunConfiguration.getWSLDistributionIfNeeded(this.myRunConfiguration.getInterpreterPath(), this.myRunConfiguration.getScriptPath());
        ArrayList<String> commandLine = new ArrayList<String>();
        ShRunConfigurationProfileState.addIfPresent(commandLine, this.myRunConfiguration.getEnvData().getEnvs());
        ShRunConfigurationProfileState.addIfPresent(commandLine, ShRunConfigurationProfileState.adaptPathForExecution(this.myRunConfiguration.getInterpreterPath(), null));
        ShRunConfigurationProfileState.addIfPresent(commandLine, this.myRunConfiguration.getInterpreterOptions());
        commandLine.add(ShRunConfigurationProfileState.adaptPathForExecution(this.myRunConfiguration.getScriptPath(), wslDistribution));
        ShRunConfigurationProfileState.addIfPresent(commandLine, this.myRunConfiguration.getScriptOptions());
        if (wslDistribution != null) {
            String string = wslDistribution.patchCommandLine(new GeneralCommandLine(commandLine), this.myProject, wslDistribution.getWslPath(this.myRunConfiguration.getScriptWorkingDirectory()), false).getCommandLineString();
            if (string == null) {
                ShRunConfigurationProfileState.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = String.join((CharSequence)" ", commandLine);
        if (string == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static void addIfPresent(@NotNull List<String> commandLine, @Nullable String options) {
        if (commandLine == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(6);
        }
        ContainerUtil.addIfNotNull(commandLine, (Object)StringUtil.nullize((String)options));
    }

    private static void addIfPresent(@NotNull List<String> commandLine, @NotNull Map<String, String> envs) {
        if (commandLine == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(7);
        }
        if (envs == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(8);
        }
        envs.forEach((key, value) -> {
            String quotedString;
            if (Platform.current() != Platform.WINDOWS) {
                quotedString = ShStringUtil.quote(value);
            } else {
                String escapedValue = StringUtil.escapeQuotes((String)value);
                quotedString = StringUtil.containsWhitespaces((CharSequence)value) ? (String)StringUtil.QUOTER.fun((Object)escapedValue) : escapedValue;
            }
            commandLine.add(key + "=" + quotedString);
        });
    }

    private static String adaptPathForExecution(@NotNull String systemDependentPath, @Nullable WSLDistribution wslDistribution) {
        if (systemDependentPath == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(9);
        }
        if (wslDistribution != null) {
            return ShStringUtil.quote(wslDistribution.getWslPath(systemDependentPath));
        }
        if (Platform.current() != Platform.WINDOWS) {
            return ShStringUtil.quote(systemDependentPath);
        }
        String escapedPath = StringUtil.escapeQuotes((String)systemDependentPath);
        return StringUtil.containsWhitespaces((CharSequence)systemDependentPath) ? (String)StringUtil.QUOTER.fun((Object)escapedPath) : escapedPath;
    }

    private static String convertToWslIfNeeded(@NotNull String path, @Nullable WSLDistribution wslDistribution) {
        if (path == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(10);
        }
        return wslDistribution != null ? wslDistribution.getWslPath(path) : path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/run/ShRunConfigurationProfileState";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemDependentPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/run/ShRunConfigurationProfileState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addIfPresent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "adaptPathForExecution";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "convertToWslIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

