/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.interpolation.StringSearchModelInterpolator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.SingleResponseValueSource;
import org.codehaus.plexus.interpolation.ValueSource;

@Component(role=ModelInterpolator.class, hint="ide")
public class CustomMaven3ModelInterpolator2
extends StringSearchModelInterpolator {
    public static final String SHA1_PROPERTY = "sha1";
    public static final String CHANGELIST_PROPERTY = "changelist";
    public static final String REVISION_PROPERTY = "revision";
    private String localRepository;

    public void interpolateObject(Object obj, Model model, File projectDir, ModelBuildingRequest config, ModelProblemCollector problems) {
        String mavenVersion = System.getProperty("idea.maven.embedder.version");
        if (VersionComparatorUtil.compare((String)mavenVersion, (String)"3.6.2") >= 0) {
            this.interpolateObjectFor362(obj, model, projectDir, config, problems);
        } else {
            super.interpolateObject(obj, model, projectDir, config, problems);
        }
    }

    private void interpolateObjectFor362(Object obj, Model model, File projectDir, ModelBuildingRequest config, ModelProblemCollector problems) {
        try {
            Method interpolateObjectMethod = StringSearchModelInterpolator.class.getDeclaredMethod("interpolateObject", Object.class, Model.class, File.class, ModelBuildingRequest.class, ModelProblemCollector.class);
            interpolateObjectMethod.setAccessible(true);
            interpolateObjectMethod.invoke((Object)this, obj, model, projectDir, config, problems);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<ValueSource> createValueSources(Model model, File projectDir, ModelBuildingRequest config, ModelProblemCollector problems) {
        List sources = super.createValueSources(model, projectDir, config, problems);
        if (this.localRepository != null) {
            sources.add(new SingleResponseValueSource("settings.localRepository", (Object)this.localRepository));
        }
        int firstMapIndex = -1;
        for (int i = 0; i < sources.size(); ++i) {
            if (!(sources.get(i) instanceof MapBasedValueSource)) continue;
            firstMapIndex = i;
            break;
        }
        HashMap<String, String> rightOrderProperties = new HashMap<String, String>(3);
        if (config.getSystemProperties().containsKey(REVISION_PROPERTY)) {
            rightOrderProperties.put(REVISION_PROPERTY, config.getSystemProperties().getProperty(REVISION_PROPERTY));
        }
        if (config.getSystemProperties().containsKey(CHANGELIST_PROPERTY)) {
            rightOrderProperties.put(CHANGELIST_PROPERTY, config.getSystemProperties().getProperty(CHANGELIST_PROPERTY));
        }
        if (config.getSystemProperties().containsKey(SHA1_PROPERTY)) {
            rightOrderProperties.put(SHA1_PROPERTY, config.getSystemProperties().getProperty(SHA1_PROPERTY));
        }
        sources.add(firstMapIndex + 1, new MapBasedValueSource(rightOrderProperties));
        return sources;
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(String localRepository) {
        this.localRepository = localRepository;
    }
}

