/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.DecHelper;
import org.jetbrains.java.decompiler.modules.decompiler.MergeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

public class ExitHelper {
    public static boolean condenseExits(RootStatement root) {
        int changed = ExitHelper.integrateExits(root);
        if (changed > 0) {
            ExitHelper.cleanUpUnreachableBlocks(root);
            SequenceHelper.condenseSequences(root);
        }
        return changed > 0;
    }

    private static void cleanUpUnreachableBlocks(Statement stat) {
        boolean found;
        block0: do {
            found = false;
            for (int i = 0; i < stat.getStats().size(); ++i) {
                Statement st = (Statement)stat.getStats().get(i);
                ExitHelper.cleanUpUnreachableBlocks(st);
                if (st.type != 15 || st.getStats().size() <= 1) continue;
                Statement last = st.getStats().getLast();
                Statement secondlast = (Statement)st.getStats().get(st.getStats().size() - 2);
                if (last.getExprents() != null && last.getExprents().isEmpty() || secondlast.hasBasicSuccEdge()) continue;
                Set<Statement> set = last.getNeighboursSet(0x40000000, 0);
                set.remove(secondlast);
                if (!set.isEmpty()) continue;
                last.setExprents(new ArrayList<Exprent>());
                found = true;
                continue block0;
            }
        } while (found);
    }

    private static int integrateExits(Statement stat) {
        StatEdge destedge;
        Statement parent;
        BasicBlockStatement bstat;
        Statement dest;
        int ret = 0;
        if (stat.getExprents() == null) {
            StatEdge ifedge;
            IfStatement ifst;
            int changed;
            block0: do {
                changed = 0;
                for (Statement st : stat.getStats()) {
                    changed = ExitHelper.integrateExits(st);
                    if (changed <= 0) continue;
                    ret = 1;
                    continue block0;
                }
            } while (changed != 0);
            if (stat.type == 2 && (ifst = (IfStatement)stat).getIfstat() == null && (dest = ExitHelper.isExitEdge(ifedge = ifst.getIfEdge())) != null) {
                bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
                bstat.setExprents(DecHelper.copyExprentList(dest.getExprents()));
                ifst.getFirst().removeSuccessor(ifedge);
                StatEdge newedge = new StatEdge(1, ifst.getFirst(), bstat);
                ifst.getFirst().addSuccessor(newedge);
                ifst.setIfEdge(newedge);
                ifst.setIfstat(bstat);
                ifst.getStats().addWithKey(bstat, bstat.id);
                bstat.setParent(ifst);
                StatEdge oldexitedge = dest.getAllSuccessorEdges().get(0);
                StatEdge newexitedge = new StatEdge(4, (Statement)bstat, oldexitedge.getDestination());
                bstat.addSuccessor(newexitedge);
                oldexitedge.closure.addLabeledEdge(newexitedge);
                ret = 1;
            }
        }
        if (stat.getAllSuccessorEdges().size() == 1 && stat.getAllSuccessorEdges().get(0).getType() == 4 && stat.getLabelEdges().isEmpty() && (stat != (parent = stat.getParent()).getFirst() || parent.type != 2 && parent.type != 6) && (dest = ExitHelper.isExitEdge(destedge = stat.getAllSuccessorEdges().get(0))) != null) {
            stat.removeSuccessor(destedge);
            bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
            bstat.setExprents(DecHelper.copyExprentList(dest.getExprents()));
            StatEdge oldexitedge = dest.getAllSuccessorEdges().get(0);
            StatEdge newexitedge = new StatEdge(4, (Statement)bstat, oldexitedge.getDestination());
            bstat.addSuccessor(newexitedge);
            oldexitedge.closure.addLabeledEdge(newexitedge);
            SequenceStatement block = new SequenceStatement(Arrays.asList(stat, bstat));
            block.setAllParent();
            parent.replaceStatement(stat, block);
            for (StatEdge prededge : block.getPredecessorEdges(8)) {
                block.removePredecessor(prededge);
                prededge.getSource().changeEdgeNode(1, prededge, stat);
                stat.addPredecessor(prededge);
                stat.addLabeledEdge(prededge);
            }
            stat.addSuccessor(new StatEdge(1, stat, bstat));
            for (StatEdge edge : dest.getAllPredecessorEdges()) {
                if (edge.explicit || !stat.containsStatementStrict(edge.getSource()) || !MergeHelper.isDirectPath(edge.getSource().getParent(), bstat)) continue;
                dest.removePredecessor(edge);
                edge.getSource().changeEdgeNode(1, edge, bstat);
                bstat.addPredecessor(edge);
                if (stat.containsStatementStrict(edge.closure)) continue;
                stat.addLabeledEdge(edge);
            }
            ret = 2;
        }
        return ret;
    }

    private static Statement isExitEdge(StatEdge edge) {
        List<Exprent> data;
        Statement dest = edge.getDestination();
        if (edge.getType() == 4 && dest.type == 8 && edge.explicit && (edge.labeled || ExitHelper.isOnlyEdge(edge)) && (data = dest.getExprents()) != null && data.size() == 1 && data.get((int)0).type == 4) {
            return dest;
        }
        return null;
    }

    private static boolean isOnlyEdge(StatEdge edge) {
        Statement stat = edge.getDestination();
        for (StatEdge ed : stat.getAllPredecessorEdges()) {
            if (ed == edge) continue;
            if (ed.getType() == 1) {
                Statement source = ed.getSource();
                if (source.type != 8 && (source.type != 2 || ((IfStatement)source).iftype != 0) && (source.type != 5 || ((DoStatement)source).getLooptype() == 0)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static void removeRedundantReturns(RootStatement root) {
        DummyExitStatement dummyExit = root.getDummyExit();
        for (StatEdge edge : dummyExit.getAllPredecessorEdges()) {
            ExitExprent ex;
            Statement source;
            List<Exprent> lstExpr;
            if (edge.explicit || (lstExpr = (source = edge.getSource()).getExprents()) == null || lstExpr.isEmpty()) continue;
            Exprent expr = lstExpr.get(lstExpr.size() - 1);
            if (expr.type != 4 || (ex = (ExitExprent)expr).getExitType() != 0 || ex.getValue() != null) continue;
            dummyExit.addBytecodeOffsets(ex.bytecode);
            lstExpr.remove(lstExpr.size() - 1);
        }
    }
}

