/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AbstractResolverForProject;
import org.jetbrains.kotlin.analyzer.ModuleContent;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.ModuleInfoKt;
import org.jetbrains.kotlin.analyzer.PackageOracleFactory;
import org.jetbrains.kotlin.analyzer.PlatformAnalysisParameters;
import org.jetbrains.kotlin.analyzer.ResolverForModule;
import org.jetbrains.kotlin.analyzer.ResolverForModuleFactory;
import org.jetbrains.kotlin.analyzer.ResolverForProject;
import org.jetbrains.kotlin.analyzer.common.CommonAnalysisParameters;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.jvm.JvmBuiltIns;
import org.jetbrains.kotlin.caches.resolve.CompositeAnalyzerServices;
import org.jetbrains.kotlin.caches.resolve.CompositeResolverForModuleFactory;
import org.jetbrains.kotlin.caches.resolve.IdePlatformKindResolutionKt;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.caches.resolve.BuiltInsCacheKey;
import org.jetbrains.kotlin.idea.caches.resolve.IdePackageOracleFactory;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaResolverForProject;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheServiceImplKt;
import org.jetbrains.kotlin.idea.compiler.IDELanguageSettingsProvider;
import org.jetbrains.kotlin.idea.project.AnalyzerServicesKt;
import org.jetbrains.kotlin.idea.project.IdeaEnvironment;
import org.jetbrains.kotlin.idea.project.KotlinMultiplatformAnalysisModeComponentKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.ResolutionAnchorProvider;
import org.jetbrains.kotlin.resolve.jvm.JvmPlatformParameters;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001)Bo\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u0002H\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010\u001c2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0002H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020&2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010\u001c2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0002H\u0002R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/IdeaResolverForProject;", "Lorg/jetbrains/kotlin/analyzer/AbstractResolverForProject;", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "debugName", "", "projectContext", "Lorg/jetbrains/kotlin/context/ProjectContext;", "modules", "", "syntheticFilesByModule", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "delegateResolver", "Lorg/jetbrains/kotlin/analyzer/ResolverForProject;", "fallbackModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "isReleaseCoroutines", "", "constantSdkDependencyIfAny", "Lorg/jetbrains/kotlin/idea/caches/project/SdkInfo;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/context/ProjectContext;Ljava/util/Collection;Ljava/util/Map;Lorg/jetbrains/kotlin/analyzer/ResolverForProject;Lcom/intellij/openapi/util/ModificationTracker;Ljava/lang/Boolean;Lorg/jetbrains/kotlin/idea/caches/project/SdkInfo;)V", "builtInsCache", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdeaResolverForProject$BuiltInsCache;", "Ljava/lang/Boolean;", "builtInsForModule", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "module", "createResolverForModule", "Lorg/jetbrains/kotlin/analyzer/ResolverForModule;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleInfo", "getResolverForModuleFactory", "Lorg/jetbrains/kotlin/analyzer/ResolverForModuleFactory;", "getResolverForProjectUsingResolutionAnchor", "targetModuleInfo", "referencingModuleInfo", "modulesContent", "Lorg/jetbrains/kotlin/analyzer/ModuleContent;", "sdkDependency", "tryGetResolverForModuleWithResolutionAnchorFallback", "BuiltInsCache", "kotlin.core"})
public final class IdeaResolverForProject
extends AbstractResolverForProject<IdeaModuleInfo> {
    private final BuiltInsCache builtInsCache;
    private final Map<IdeaModuleInfo, Collection<KtFile>> syntheticFilesByModule;
    private final Boolean isReleaseCoroutines;
    private final SdkInfo constantSdkDependencyIfAny;

    @Nullable
    public SdkInfo sdkDependency(@NotNull IdeaModuleInfo module) {
        SdkInfo sdkInfo;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (KotlinMultiplatformAnalysisModeComponentKt.getUseCompositeAnalysis(this.getProjectContext().getProject())) {
            boolean bl = this.constantSdkDependencyIfAny == null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Shouldn't pass SDK dependency manually for composite analysis mode";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        if ((sdkInfo = this.constantSdkDependencyIfAny) == null) {
            sdkInfo = GetModuleInfoKt.findSdkAcrossDependencies(module);
        }
        return sdkInfo;
    }

    @NotNull
    public ModuleContent<IdeaModuleInfo> modulesContent(@NotNull IdeaModuleInfo module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ModuleInfo moduleInfo = module;
        Collection collection = this.syntheticFilesByModule.get(module);
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        return new ModuleContent(moduleInfo, collection, module.contentScope());
    }

    @NotNull
    public KotlinBuiltIns builtInsForModule(@NotNull IdeaModuleInfo module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.builtInsCache.getOrCreateIfNeeded(module);
    }

    @NotNull
    public ResolverForModule createResolverForModule(@NotNull ModuleDescriptor descriptor, @NotNull IdeaModuleInfo moduleInfo) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        ModuleInfo moduleInfo2 = moduleInfo;
        Collection collection = this.syntheticFilesByModule.get(moduleInfo);
        if (collection == null) {
            boolean bl = false;
            collection = CollectionsKt.emptyList();
        }
        ModuleContent moduleContent = new ModuleContent(moduleInfo2, collection, moduleInfo.contentScope());
        LanguageVersionSettings languageVersionSettings = IDELanguageSettingsProvider.INSTANCE.getLanguageVersionSettings(moduleInfo, this.getProjectContext().getProject(), this.isReleaseCoroutines);
        ResolverForModuleFactory resolverForModuleFactory = this.getResolverForModuleFactory(moduleInfo);
        return resolverForModuleFactory.createResolverForModule((ModuleDescriptorImpl)descriptor, ContextKt.withModule((ProjectContext)this.getProjectContext(), (ModuleDescriptor)descriptor), moduleContent, (ResolverForProject)this, languageVersionSettings);
    }

    /*
     * WARNING - void declaration
     */
    private final ResolverForModuleFactory getResolverForModuleFactory(IdeaModuleInfo moduleInfo) {
        ResolverForModuleFactory resolverForModuleFactory;
        TargetPlatform platform = moduleInfo.getPlatform();
        JvmPlatformParameters jvmPlatformParameters2 = new JvmPlatformParameters((Function1)getResolverForModuleFactory.jvmPlatformParameters.1.INSTANCE, (Function1)getResolverForModuleFactory.jvmPlatformParameters.2.INSTANCE, (Function2)new Function2<ModuleInfo, ModuleInfo, ResolverForModule>(this){
            final /* synthetic */ IdeaResolverForProject this$0;

            @Nullable
            public final ResolverForModule invoke(@NotNull ModuleInfo targetModuleInfo, @NotNull ModuleInfo referencingModuleInfo) {
                Intrinsics.checkNotNullParameter((Object)targetModuleInfo, (String)"targetModuleInfo");
                Intrinsics.checkNotNullParameter((Object)referencingModuleInfo, (String)"referencingModuleInfo");
                boolean bl = targetModuleInfo instanceof IdeaModuleInfo && referencingModuleInfo instanceof IdeaModuleInfo;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Unexpected modules passed through JvmPlatformParameters to IDE resolver (" + targetModuleInfo + ", " + referencingModuleInfo + ')';
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                return IdeaResolverForProject.access$tryGetResolverForModuleWithResolutionAnchorFallback(this.this$0, (IdeaModuleInfo)targetModuleInfo, (IdeaModuleInfo)referencingModuleInfo);
            }
            {
                this.this$0 = ideaResolverForProject;
                super(2);
            }
        });
        CommonAnalysisParameters commonPlatformParameters2 = new CommonAnalysisParameters((Function1)getResolverForModuleFactory.commonPlatformParameters.1.INSTANCE);
        if (!KotlinMultiplatformAnalysisModeComponentKt.getUseCompositeAnalysis(this.getProjectContext().getProject())) {
            PlatformAnalysisParameters parameters = JvmPlatformKt.isJvm((TargetPlatform)platform) ? (PlatformAnalysisParameters)jvmPlatformParameters2 : (TargetPlatformKt.isCommon((TargetPlatform)platform) ? (PlatformAnalysisParameters)commonPlatformParameters2 : (PlatformAnalysisParameters)PlatformAnalysisParameters.Empty.INSTANCE);
            resolverForModuleFactory = IdePlatformKindResolutionKt.getResolution(IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)platform)).createResolverForModuleFactory(parameters, IdeaEnvironment.INSTANCE, platform);
        } else {
            Collection<PlatformDependentAnalyzerServices> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable parameters = platform.getComponentPlatforms();
            TargetPlatform targetPlatform = platform;
            JvmPlatformParameters jvmPlatformParameters3 = jvmPlatformParameters2;
            CommonAnalysisParameters commonAnalysisParameters = commonPlatformParameters2;
            boolean $i$f$map = false;
            void var7_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SimplePlatform simplePlatform = (SimplePlatform)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                PlatformDependentAnalyzerServices platformDependentAnalyzerServices = AnalyzerServicesKt.findAnalyzerServices((SimplePlatform)it);
                collection.add(platformDependentAnalyzerServices);
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            CompositeAnalyzerServices compositeAnalyzerServices = new CompositeAnalyzerServices(list);
            TargetPlatform targetPlatform2 = targetPlatform;
            JvmPlatformParameters jvmPlatformParameters4 = jvmPlatformParameters3;
            CommonAnalysisParameters commonAnalysisParameters2 = commonAnalysisParameters;
            resolverForModuleFactory = new CompositeResolverForModuleFactory(commonAnalysisParameters2, jvmPlatformParameters4, targetPlatform2, compositeAnalyzerServices);
        }
        return resolverForModuleFactory;
    }

    private final ResolverForModule tryGetResolverForModuleWithResolutionAnchorFallback(IdeaModuleInfo targetModuleInfo, IdeaModuleInfo referencingModuleInfo) {
        ResolverForModule resolverForModule = this.tryGetResolverForModule(targetModuleInfo);
        if (resolverForModule != null) {
            ResolverForModule resolverForModule2 = resolverForModule;
            boolean bl = false;
            boolean bl2 = false;
            ResolverForModule it = resolverForModule2;
            boolean bl3 = false;
            return it;
        }
        return this.getResolverForProjectUsingResolutionAnchor(targetModuleInfo, referencingModuleInfo);
    }

    private final ResolverForModule getResolverForProjectUsingResolutionAnchor(IdeaModuleInfo targetModuleInfo, IdeaModuleInfo referencingModuleInfo) {
        AbstractResolverForProject.ModuleData moduleData = (AbstractResolverForProject.ModuleData)this.getDescriptorByModule().get(referencingModuleInfo);
        if (moduleData == null || (moduleData = moduleData.getModuleDescriptor()) == null) {
            String string = referencingModuleInfo + " is not contained in this resolver, which means incorrect use of anchor-aware search";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        AbstractResolverForProject.ModuleData moduleDescriptorOfReferencingModule = moduleData;
        ModuleDescriptor moduleDescriptor = this.getResolutionAnchorProvider().getResolutionAnchor((ModuleDescriptor)moduleDescriptorOfReferencingModule);
        if (moduleDescriptor == null || (moduleDescriptor = ModuleInfoKt.getModuleInfo((ModuleDescriptor)moduleDescriptor)) == null) {
            return null;
        }
        ModuleDescriptor anchorModuleInfo = moduleDescriptor;
        ResolutionFacade resolutionFacade = KotlinCacheService.Companion.getInstance(this.getProjectContext().getProject()).getResolutionFacadeByModuleInfo((ModuleInfo)anchorModuleInfo, anchorModuleInfo.getPlatform());
        if (resolutionFacade == null || (resolutionFacade = resolutionFacade.getResolverForProject()) == null) {
            return null;
        }
        ResolutionFacade resolverForProjectFromAnchorModule = resolutionFacade;
        boolean bl = resolverForProjectFromAnchorModule instanceof IdeaResolverForProject;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Resolution via anchor modules is expected to be used only from IDE resolvers";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return ((IdeaResolverForProject)resolverForProjectFromAnchorModule).tryGetResolverForModule(targetModuleInfo);
    }

    public IdeaResolverForProject(@NotNull String debugName, @NotNull ProjectContext projectContext, @NotNull Collection<? extends IdeaModuleInfo> modules, @NotNull Map<IdeaModuleInfo, ? extends Collection<? extends KtFile>> syntheticFilesByModule, @NotNull ResolverForProject<IdeaModuleInfo> delegateResolver, @Nullable ModificationTracker fallbackModificationTracker, @Nullable Boolean isReleaseCoroutines, @Nullable SdkInfo constantSdkDependencyIfAny) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        Intrinsics.checkNotNullParameter((Object)projectContext, (String)"projectContext");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter(syntheticFilesByModule, (String)"syntheticFilesByModule");
        Intrinsics.checkNotNullParameter(delegateResolver, (String)"delegateResolver");
        Object object2 = ServiceManager.getService((Project)projectContext.getProject(), IdePackageOracleFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ServiceManager.getServic\u2026racleFactory::class.java)");
        PackageOracleFactory packageOracleFactory = (PackageOracleFactory)object2;
        Object object3 = ServiceManager.getService((Project)projectContext.getProject(), ResolutionAnchorProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"ServiceManager.getServic\u2026chorProvider::class.java)");
        super(debugName, projectContext, modules, fallbackModificationTracker, delegateResolver, packageOracleFactory, (ResolutionAnchorProvider)object3);
        this.syntheticFilesByModule = syntheticFilesByModule;
        this.isReleaseCoroutines = isReleaseCoroutines;
        this.constantSdkDependencyIfAny = constantSdkDependencyIfAny;
        ResolverForProject<IdeaModuleInfo> resolverForProject = delegateResolver;
        if (!(resolverForProject instanceof IdeaResolverForProject)) {
            resolverForProject = null;
        }
        if ((object = (IdeaResolverForProject)resolverForProject) == null || (object = object.builtInsCache) == null) {
            object = new BuiltInsCache(projectContext, this);
        }
        this.builtInsCache = object;
    }

    public /* synthetic */ IdeaResolverForProject(String string, ProjectContext projectContext, Collection collection, Map map2, ResolverForProject resolverForProject, ModificationTracker modificationTracker, Boolean bl, SdkInfo sdkInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            modificationTracker = null;
        }
        if ((n & 0x40) != 0) {
            bl = null;
        }
        if ((n & 0x80) != 0) {
            sdkInfo = null;
        }
        this(string, projectContext, collection, map2, (ResolverForProject<IdeaModuleInfo>)resolverForProject, modificationTracker, bl, sdkInfo);
    }

    public static final /* synthetic */ ResolverForModule access$tryGetResolverForModuleWithResolutionAnchorFallback(IdeaResolverForProject $this, IdeaModuleInfo targetModuleInfo, IdeaModuleInfo referencingModuleInfo) {
        return $this.tryGetResolverForModuleWithResolutionAnchorFallback(targetModuleInfo, referencingModuleInfo);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/IdeaResolverForProject$BuiltInsCache;", "", "projectContextFromSdkResolver", "Lorg/jetbrains/kotlin/context/ProjectContext;", "resolverForSdk", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdeaResolverForProject;", "(Lorg/jetbrains/kotlin/context/ProjectContext;Lorg/jetbrains/kotlin/idea/caches/resolve/IdeaResolverForProject;)V", "cache", "", "Lorg/jetbrains/kotlin/idea/caches/resolve/BuiltInsCacheKey;", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getOrCreateIfNeeded", "module", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "kotlin.core"})
    public static final class BuiltInsCache {
        private final Map<BuiltInsCacheKey, KotlinBuiltIns> cache;
        private final ProjectContext projectContextFromSdkResolver;
        private final IdeaResolverForProject resolverForSdk;

        @NotNull
        public final KotlinBuiltIns getOrCreateIfNeeded(@NotNull IdeaModuleInfo module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return (KotlinBuiltIns)this.projectContextFromSdkResolver.getStorageManager().compute((Function0)new Function0<KotlinBuiltIns>(this, module){
                final /* synthetic */ BuiltInsCache this$0;
                final /* synthetic */ IdeaModuleInfo $module;

                @NotNull
                public final KotlinBuiltIns invoke() {
                    SdkInfo sdk = BuiltInsCache.access$getResolverForSdk$p(this.this$0).sdkDependency(this.$module);
                    BuiltInsCacheKey key = IdePlatformKindResolutionKt.getResolution(IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)this.$module.getPlatform())).getKeyForBuiltIns(this.$module, sdk);
                    KotlinBuiltIns cachedBuiltIns = (KotlinBuiltIns)BuiltInsCache.access$getCache$p(this.this$0).get(key);
                    if (cachedBuiltIns != null) {
                        return cachedBuiltIns;
                    }
                    KotlinBuiltIns newBuiltIns = IdePlatformKindResolutionKt.getResolution(IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)this.$module.getPlatform())).createBuiltIns(this.$module, BuiltInsCache.access$getProjectContextFromSdkResolver$p(this.this$0), sdk);
                    BuiltInsCache.access$getCache$p(this.this$0).put(key, newBuiltIns);
                    if (newBuiltIns instanceof JvmBuiltIns) {
                        IdeaResolverForProject ideaResolverForProject = BuiltInsCache.access$getResolverForSdk$p(this.this$0);
                        SdkInfo sdkInfo = sdk;
                        Intrinsics.checkNotNull((Object)sdkInfo);
                        ModuleDescriptorImpl sdkDescriptor = ideaResolverForProject.descriptorForModule(sdkInfo);
                        boolean isAdditionalBuiltInsFeaturesSupported = KotlinCacheServiceImplKt.supportsAdditionalBuiltInsMembers(this.$module, BuiltInsCache.access$getProjectContextFromSdkResolver$p(this.this$0).getProject());
                        ((JvmBuiltIns)newBuiltIns).initialize((ModuleDescriptor)sdkDescriptor, isAdditionalBuiltInsFeaturesSupported);
                    }
                    return newBuiltIns;
                }
                {
                    this.this$0 = builtInsCache;
                    this.$module = ideaModuleInfo;
                    super(0);
                }
            });
        }

        public BuiltInsCache(@NotNull ProjectContext projectContextFromSdkResolver, @NotNull IdeaResolverForProject resolverForSdk) {
            Intrinsics.checkNotNullParameter((Object)projectContextFromSdkResolver, (String)"projectContextFromSdkResolver");
            Intrinsics.checkNotNullParameter((Object)((Object)resolverForSdk), (String)"resolverForSdk");
            this.projectContextFromSdkResolver = projectContextFromSdkResolver;
            this.resolverForSdk = resolverForSdk;
            boolean bl = false;
            this.cache = new LinkedHashMap();
        }

        public static final /* synthetic */ IdeaResolverForProject access$getResolverForSdk$p(BuiltInsCache $this) {
            return $this.resolverForSdk;
        }

        public static final /* synthetic */ Map access$getCache$p(BuiltInsCache $this) {
            return $this.cache;
        }

        public static final /* synthetic */ ProjectContext access$getProjectContextFromSdkResolver$p(BuiltInsCache $this) {
            return $this.projectContextFromSdkResolver;
        }
    }
}

