/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.psi.PsiElement;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointChecker;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/InspectBreakpointApplicabilityAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getData", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/InspectBreakpointApplicabilityAction$ActionData;", "ActionData", "BreakpointsGutterProvider", "kotlin.jvm-debugger.core"})
public final class InspectBreakpointApplicabilityAction
extends AnAction {
    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ActionData actionData = this.getData(e);
        if (actionData == null) {
            return;
        }
        ActionData data = actionData;
        EditorGutter editorGutter = data.getEditor().getGutter();
        Intrinsics.checkNotNullExpressionValue((Object)editorGutter, (String)"data.editor.gutter");
        if (editorGutter.isAnnotationsShown()) {
            data.getEditor().getGutter().closeAllAnnotations();
        }
        BreakpointChecker checker = new BreakpointChecker();
        int lineCount = PsiLinesUtilsKt.getLineCount((PsiElement)((PsiElement)data.getFile()));
        int n = 0;
        Iterable $this$map$iv = (Iterable)new IntRange(n, lineCount);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void line;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            EnumSet<BreakpointChecker.BreakpointType> enumSet = checker.check(data.getFile(), (int)line);
            collection.add(enumSet);
        }
        List breakpoints = (List)destination$iv$iv;
        BreakpointsGutterProvider gutterProvider = new BreakpointsGutterProvider(breakpoints);
        data.getEditor().getGutter().registerTextAnnotation((TextAnnotationGutterProvider)gutterProvider);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        presentation.setVisible(application.isInternal());
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabled(this.getData(e) != null);
    }

    private final ActionData getData(AnActionEvent $this$getData) {
        Editor editor = (Editor)$this$getData.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getData(CommonDataKeys.EDITOR) ?: return null");
        Editor editor2 = editor;
        Object object = $this$getData.getData(CommonDataKeys.PSI_FILE);
        if (!(object instanceof KtFile)) {
            object = null;
        }
        KtFile ktFile = (KtFile)object;
        if (ktFile == null) {
            return null;
        }
        KtFile file = ktFile;
        return new ActionData(editor2, file);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/InspectBreakpointApplicabilityAction$BreakpointsGutterProvider;", "Lcom/intellij/openapi/editor/TextAnnotationGutterProvider;", "breakpoints", "", "Ljava/util/EnumSet;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/BreakpointChecker$BreakpointType;", "(Ljava/util/List;)V", "getBgColor", "Ljava/awt/Color;", "line", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getColor", "Lcom/intellij/openapi/editor/colors/ColorKey;", "getLineText", "", "getPopupActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "getStyle", "Lcom/intellij/openapi/editor/colors/EditorFontType;", "getToolTip", "gutterClosed", "", "kotlin.jvm-debugger.core"})
    private static final class BreakpointsGutterProvider
    implements TextAnnotationGutterProvider {
        private final List<EnumSet<BreakpointChecker.BreakpointType>> breakpoints;

        /*
         * WARNING - void declaration
         */
        @Nullable
        public String getLineText(int line, @Nullable Editor editor) {
            void $this$mapTo$iv$iv;
            EnumSet enumSet = (EnumSet)CollectionsKt.getOrNull(this.breakpoints, (int)line);
            if (enumSet == null) {
                return null;
            }
            EnumSet breakpoints = enumSet;
            Iterable $this$map$iv = breakpoints;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BreakpointChecker.BreakpointType breakpointType = (BreakpointChecker.BreakpointType)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getPrefix();
                collection.add(string);
            }
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
        }

        @Nullable
        public String getToolTip(int line, @Nullable Editor editor) {
            return null;
        }

        @NotNull
        public EditorFontType getStyle(int line, @Nullable Editor editor) {
            return EditorFontType.PLAIN;
        }

        @NotNull
        public List<AnAction> getPopupActions(int line, @Nullable Editor editor) {
            return CollectionsKt.emptyList();
        }

        @Nullable
        public ColorKey getColor(int line, @Nullable Editor editor) {
            return null;
        }

        @Nullable
        public Color getBgColor(int line, @Nullable Editor editor) {
            return null;
        }

        public void gutterClosed() {
        }

        public BreakpointsGutterProvider(@NotNull List<? extends EnumSet<BreakpointChecker.BreakpointType>> breakpoints) {
            Intrinsics.checkNotNullParameter(breakpoints, (String)"breakpoints");
            this.breakpoints = breakpoints;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/InspectBreakpointApplicabilityAction$ActionData;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtFile;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.jvm-debugger.core"})
    public static final class ActionData {
        @NotNull
        private final Editor editor;
        @NotNull
        private final KtFile file;

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        @NotNull
        public final KtFile getFile() {
            return this.file;
        }

        public ActionData(@NotNull Editor editor, @NotNull KtFile file) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.editor = editor;
            this.file = file;
        }
    }
}

