/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactDependencySpecImpl
implements ArtifactDependencySpec {
    static final Map<String, Function<ArtifactDependencySpec, String>> COMPONENT_MAP = new LinkedHashMap<String, Function<ArtifactDependencySpec, String>>();
    @NotNull
    private String name;
    @Nullable
    private String group;
    @Nullable
    private String version;
    @Nullable
    private String classifier;
    @Nullable
    private String extension;

    @Nullable
    public static ArtifactDependencySpec create(@NotNull String notation) {
        List segments;
        int segmentCount;
        if (notation == null) {
            ArtifactDependencySpecImpl.$$$reportNull$$$0(0);
        }
        if ((segmentCount = (segments = Splitter.on((String)":").trimResults().omitEmptyStrings().splitToList((CharSequence)notation)).size()) > 0) {
            segments = Lists.newArrayList((Iterable)segments);
            String lastSegment = (String)segments.remove(segmentCount - 1);
            String extension = null;
            int indexOfAt = lastSegment.indexOf(64);
            if (indexOfAt != -1) {
                extension = lastSegment.substring(indexOfAt + 1);
                lastSegment = lastSegment.substring(0, indexOfAt);
            }
            segments.add(lastSegment);
            segmentCount = segments.size();
            String group = null;
            String name = null;
            String version = null;
            String classifier = null;
            if (segmentCount == 2) {
                if (!lastSegment.isEmpty() && Character.isDigit(lastSegment.charAt(0))) {
                    name = (String)segments.get(0);
                    version = lastSegment;
                } else {
                    group = (String)segments.get(0);
                    name = (String)segments.get(1);
                }
            } else if (segmentCount == 3 || segmentCount == 4) {
                group = (String)segments.get(0);
                name = (String)segments.get(1);
                version = (String)segments.get(2);
                if (segmentCount == 4) {
                    classifier = (String)segments.get(3);
                }
            }
            if (StringUtil.isNotEmpty(name)) {
                return new ArtifactDependencySpecImpl(name, group, version, classifier, extension);
            }
        }
        return null;
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            ArtifactDependencySpecImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Nullable
    public String getExtension() {
        return this.extension;
    }

    public void setName(@NotNull String newName) {
        if (newName == null) {
            ArtifactDependencySpecImpl.$$$reportNull$$$0(2);
        }
        this.name = newName;
    }

    public void setGroup(@Nullable String newGroup) {
        this.group = newGroup;
    }

    public void setVersion(@Nullable String newVersion) {
        this.version = newVersion;
    }

    public void setClassifier(@Nullable String newClassifier) {
        this.classifier = newClassifier;
    }

    public void setExtension(@Nullable String newExtension) {
        this.extension = newExtension;
    }

    @NotNull
    public static ArtifactDependencySpec create(@NotNull ArtifactDependencyModel dependency) {
        if (dependency == null) {
            ArtifactDependencySpecImpl.$$$reportNull$$$0(3);
        }
        String name = dependency.name().toString();
        assert (name != null);
        return new ArtifactDependencySpecImpl(name, dependency.group().toString(), dependency.version().toString(), dependency.classifier().toString(), dependency.extension().toString());
    }

    public ArtifactDependencySpecImpl(@NotNull String name, @Nullable String group, @Nullable String version) {
        if (name == null) {
            ArtifactDependencySpecImpl.$$$reportNull$$$0(4);
        }
        this(name, group, version, null, null);
    }

    public ArtifactDependencySpecImpl(@NotNull String name, @Nullable String group, @Nullable String version, @Nullable String classifier, @Nullable String extension) {
        if (name == null) {
            ArtifactDependencySpecImpl.$$$reportNull$$$0(5);
        }
        this.name = name;
        this.group = Strings.emptyToNull((String)group);
        this.version = Strings.emptyToNull((String)version);
        this.classifier = Strings.emptyToNull((String)classifier);
        this.extension = Strings.emptyToNull((String)extension);
    }

    public boolean equalsIgnoreVersion(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactDependencySpecImpl that = (ArtifactDependencySpecImpl)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.classifier, (Object)that.classifier) && Objects.equal((Object)this.extension, (Object)that.extension);
    }

    public boolean equals(Object o) {
        if (this.equalsIgnoreVersion(o)) {
            ArtifactDependencySpecImpl that = (ArtifactDependencySpecImpl)o;
            return Objects.equal((Object)this.version, (Object)that.version);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.group, this.version, this.classifier, this.extension});
    }

    public String toString() {
        return this.compactNotation();
    }

    @NotNull
    public String compactNotation() {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{this.group, this.name, this.version, this.classifier});
        Object s = Joiner.on((String)":").skipNulls().join((Iterable)segments);
        if (this.extension != null) {
            s = (String)s + "@" + this.extension;
        }
        String string = s;
        if (string == null) {
            ArtifactDependencySpecImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    static {
        COMPONENT_MAP.put("name", (Function<ArtifactDependencySpec, String>)((Function)ArtifactDependencySpec::getName));
        COMPONENT_MAP.put("group", (Function<ArtifactDependencySpec, String>)((Function)ArtifactDependencySpec::getGroup));
        COMPONENT_MAP.put("version", (Function<ArtifactDependencySpec, String>)((Function)ArtifactDependencySpec::getVersion));
        COMPONENT_MAP.put("ext", (Function<ArtifactDependencySpec, String>)((Function)ArtifactDependencySpec::getExtension));
        COMPONENT_MAP.put("classifier", (Function<ArtifactDependencySpec, String>)((Function)ArtifactDependencySpec::getClassifier));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notation";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencySpecImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencySpecImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "compactNotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

