/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.repositories;

import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoryModel;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.repositories.FlatDirRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.GoogleDefaultRepositoryModelImpl;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterDefaultRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenCentralRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenRepositoryModelImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.FlatDirRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.MavenRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepositoriesModelImpl
extends GradleDslBlockModel
implements RepositoriesModel {
    public RepositoriesModelImpl(@NotNull RepositoriesDslElement dslElement) {
        if (dslElement == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(0);
        }
        super(dslElement);
    }

    @NotNull
    public List<RepositoryModel> repositories() {
        ArrayList<RepositoryModel> result = new ArrayList<RepositoryModel>();
        for (GradleDslElement element : this.myDslElement.getAllPropertyElements()) {
            if (element instanceof GradleDslMethodCall) {
                String methodName = ((GradleDslMethodCall)element).getMethodName();
                if ("mavenCentral".equals(methodName)) {
                    result.add(new MavenCentralRepositoryModel(this.myDslElement, element));
                    continue;
                }
                if ("jcenter".equals(methodName)) {
                    result.add(new JCenterDefaultRepositoryModel(this.myDslElement, element));
                    continue;
                }
                if (!"google".equals(methodName)) continue;
                result.add(new GoogleDefaultRepositoryModelImpl(this.myDslElement, element));
                continue;
            }
            if (element instanceof MavenRepositoryDslElement) {
                if (MavenRepositoryDslElement.MAVEN.name.equals(element.getName())) {
                    result.add(new MavenRepositoryModelImpl(this.myDslElement, (MavenRepositoryDslElement)element));
                    continue;
                }
                if (!MavenRepositoryDslElement.JCENTER.name.equals(element.getName())) continue;
                result.add(new JCenterRepositoryModel(this.myDslElement, (MavenRepositoryDslElement)element));
                continue;
            }
            if (element instanceof FlatDirRepositoryDslElement) {
                result.add(new FlatDirRepositoryModel(this.myDslElement, (FlatDirRepositoryDslElement)element));
                continue;
            }
            if (!(element instanceof GradleDslExpressionMap)) continue;
            if ("mavenCentral".equals(element.getName())) {
                result.add(new MavenCentralRepositoryModel(this.myDslElement, element));
                continue;
            }
            if (!"flatDir".equals(element.getName())) continue;
            result.add(new FlatDirRepositoryModel(this.myDslElement, (GradlePropertiesDslElement)element));
        }
        ArrayList<RepositoryModel> arrayList = result;
        if (arrayList == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public void addRepositoryByMethodName(@NotNull String methodName) {
        if (methodName == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(2);
        }
        if (this.containsMethodCall(methodName)) {
            return;
        }
        this.myDslElement.setNewElement(new GradleDslMethodCall((GradleDslElement)this.myDslElement, GradleNameElement.empty(), methodName));
    }

    public void addFlatDirRepository(@NotNull String dirName) {
        List<FlatDirRepositoryDslElement> flatDirElements;
        if (dirName == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(3);
        }
        if (!(flatDirElements = this.myDslElement.getPropertyElements(FlatDirRepositoryDslElement.class)).isEmpty()) {
            new FlatDirRepositoryModel(this.myDslElement, flatDirElements.get(0)).dirs().addListValue().setValue((Object)dirName);
        } else {
            FlatDirRepositoryDslElement gradleDslElement = new FlatDirRepositoryDslElement(this.myDslElement, GradleNameElement.fake(FlatDirRepositoryDslElement.FLAT_DIR.name));
            this.myDslElement.setNewElement(gradleDslElement);
            new FlatDirRepositoryModel(this.myDslElement, gradleDslElement).dirs().addListValue().setValue((Object)dirName);
        }
    }

    public boolean containsMethodCall(@NotNull String methodName) {
        if (methodName == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(4);
        }
        List<GradleDslMethodCall> elements = this.myDslElement.getPropertyElements(GradleDslMethodCall.class);
        for (GradleDslMethodCall element : elements) {
            if (!methodName.equals(element.getName())) continue;
            return true;
        }
        return false;
    }

    public void addMavenRepositoryByUrl(@NotNull String url, @Nullable String name) {
        if (url == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(5);
        }
        if (this.containsMavenRepositoryByUrl(url)) {
            return;
        }
        GradleNameElement nameElement = GradleNameElement.fake(MavenRepositoryDslElement.MAVEN.name);
        MavenRepositoryDslElement newElement = new MavenRepositoryDslElement(this.myDslElement, nameElement);
        newElement.setNewLiteral("url", url);
        if (name != null) {
            newElement.setNewLiteral("name", name);
        }
        this.myDslElement.setNewElement(newElement);
    }

    public boolean containsMavenRepositoryByUrl(@NotNull String repositoryUrl) {
        if (repositoryUrl == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(6);
        }
        List<MavenRepositoryDslElement> elements = this.myDslElement.getPropertyElements(MavenRepositoryDslElement.class);
        for (MavenRepositoryDslElement element : elements) {
            String urlElement = element.getLiteral("url", String.class);
            if (!repositoryUrl.equalsIgnoreCase(urlElement)) continue;
            return true;
        }
        return false;
    }

    public boolean removeRepositoryByUrl(@NotNull String repositoryUrl) {
        if (repositoryUrl == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(7);
        }
        List<MavenRepositoryDslElement> elements = this.myDslElement.getPropertyElements(MavenRepositoryDslElement.class);
        for (MavenRepositoryDslElement element : elements) {
            String urlElement = element.getLiteral("url", String.class);
            if (!repositoryUrl.equalsIgnoreCase(urlElement)) continue;
            this.myDslElement.removeProperty(element);
            return true;
        }
        return false;
    }

    public boolean hasGoogleMavenRepository() {
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return false;
        }
        if (this.containsMethodCall("google")) {
            return true;
        }
        return this.containsMavenRepositoryByUrl("https://maven.google.com/");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/repositories/RepositoriesModelImpl";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/repositories/RepositoriesModelImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "repositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addRepositoryByMethodName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFlatDirRepository";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsMethodCall";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addMavenRepositoryByUrl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsMavenRepositoryByUrl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeRepositoryByUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

