/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.util.ui.TimerUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.ui.GlassHighlightComponent;
import training.ui.LearningUiHighlightingManager;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020'J\b\u0010)\u001a\u00020'H\u0016J\b\u0010*\u001a\u00020\u001dH\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006+"}, d2={"Ltraining/ui/RepaintByTimer;", "T", "Ljava/awt/Component;", "", "original", "glassPane", "Ljavax/swing/JComponent;", "options", "Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;", "(Ljava/awt/Component;Ljavax/swing/JComponent;Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;)V", "getGlassPane", "()Ljavax/swing/JComponent;", "highlightComponent", "Ltraining/ui/GlassHighlightComponent;", "getHighlightComponent", "()Ltraining/ui/GlassHighlightComponent;", "setHighlightComponent", "(Ltraining/ui/GlassHighlightComponent;)V", "getOptions", "()Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;", "getOriginal", "()Ljava/awt/Component;", "Ljava/awt/Component;", "rectangle", "Lkotlin/Function0;", "Ljava/awt/Rectangle;", "getRectangle", "()Lkotlin/jvm/functions/Function0;", "removed", "", "getRemoved", "()Z", "setRemoved", "(Z)V", "startDate", "Ljava/util/Date;", "getStartDate", "()Ljava/util/Date;", "cleanup", "", "initTimer", "reinitHighlightComponent", "shouldReinit", "intellij.featuresTrainer"})
public class RepaintByTimer<T extends Component> {
    private boolean removed;
    @NotNull
    private final Date startDate;
    @Nullable
    private GlassHighlightComponent highlightComponent;
    @NotNull
    private final Function0<Rectangle> rectangle;
    @NotNull
    private final T original;
    @NotNull
    private final JComponent glassPane;
    @NotNull
    private final LearningUiHighlightingManager.HighlightingOptions options;

    public final boolean getRemoved() {
        return this.removed;
    }

    public final void setRemoved(boolean bl) {
        this.removed = bl;
    }

    @NotNull
    protected final Date getStartDate() {
        return this.startDate;
    }

    @Nullable
    protected final GlassHighlightComponent getHighlightComponent() {
        return this.highlightComponent;
    }

    protected final void setHighlightComponent(@Nullable GlassHighlightComponent glassHighlightComponent) {
        this.highlightComponent = glassHighlightComponent;
    }

    @NotNull
    public Function0<Rectangle> getRectangle() {
        return this.rectangle;
    }

    public void reinitHighlightComponent() {
        GlassHighlightComponent newHighlightComponent = new GlassHighlightComponent(this.startDate, this.options);
        Point pt = SwingUtilities.convertPoint(this.original, new Point(0, 0), this.glassPane);
        Rectangle bounds = new Rectangle(pt.x, pt.y, ((Component)this.original).getWidth(), ((Component)this.original).getHeight());
        newHighlightComponent.setBounds(bounds);
        this.glassPane.add(newHighlightComponent);
        this.highlightComponent = newHighlightComponent;
    }

    public final void initTimer() {
        Timer timer = TimerUtil.createNamedTimer((String)"IFT item", (int)50);
        Intrinsics.checkNotNullExpressionValue((Object)timer, (String)"TimerUtil.createNamedTimer(\"IFT item\", 50)");
        Timer timer2 = timer;
        timer2.addActionListener(new ActionListener(this, timer2){
            final /* synthetic */ RepaintByTimer this$0;
            final /* synthetic */ Timer $timer;

            public final void actionPerformed(ActionEvent it) {
                if (!((Component)this.this$0.getOriginal()).isShowing()) {
                    LearningUiHighlightingManager.INSTANCE.removeIt$intellij_featuresTrainer(this.this$0);
                }
                if (this.this$0.getRemoved()) {
                    this.$timer.stop();
                    return;
                }
                if (this.this$0.shouldReinit()) {
                    this.this$0.cleanup();
                    this.this$0.setHighlightComponent(null);
                    this.this$0.reinitHighlightComponent();
                }
                this.this$0.getGlassPane().repaint();
            }
            {
                this.this$0 = repaintByTimer;
                this.$timer = timer;
            }
        });
        timer2.start();
    }

    protected boolean shouldReinit() {
        GlassHighlightComponent component2 = this.highlightComponent;
        return component2 == null || Intrinsics.areEqual((Object)((Component)this.original).getLocationOnScreen(), (Object)component2.getLocationOnScreen()) ^ true || Intrinsics.areEqual((Object)((Component)this.original).getSize(), (Object)component2.getSize()) ^ true;
    }

    public final void cleanup() {
        GlassHighlightComponent glassHighlightComponent = this.highlightComponent;
        if (glassHighlightComponent != null) {
            GlassHighlightComponent glassHighlightComponent2 = glassHighlightComponent;
            boolean bl = false;
            boolean bl2 = false;
            GlassHighlightComponent it = glassHighlightComponent2;
            boolean bl3 = false;
            this.glassPane.remove(it);
        }
        if (this.glassPane.isValid()) {
            this.glassPane.revalidate();
            this.glassPane.repaint();
        }
    }

    @NotNull
    public final T getOriginal() {
        return this.original;
    }

    @NotNull
    public final JComponent getGlassPane() {
        return this.glassPane;
    }

    @NotNull
    public final LearningUiHighlightingManager.HighlightingOptions getOptions() {
        return this.options;
    }

    public RepaintByTimer(@NotNull T original, @NotNull JComponent glassPane, @NotNull LearningUiHighlightingManager.HighlightingOptions options) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)glassPane, (String)"glassPane");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.original = original;
        this.glassPane = glassPane;
        this.options = options;
        this.startDate = new Date();
        this.rectangle = (Function0)new Function0<Rectangle>(this){
            final /* synthetic */ RepaintByTimer this$0;

            @NotNull
            public final Rectangle invoke() {
                return new Rectangle(0, 0, ((Component)this.this$0.getOriginal()).getWidth(), ((Component)this.this$0.getOriginal()).getHeight());
            }
            {
                this.this$0 = repaintByTimer;
                super(0);
            }
        };
    }
}

