/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.art;

import org.roaringbitmap.art.Art;
import org.roaringbitmap.art.Containers;
import org.roaringbitmap.art.LeafNode;
import org.roaringbitmap.art.Node;
import org.roaringbitmap.art.NodeType;
import org.roaringbitmap.art.Shuttle;

public abstract class AbstractShuttle
implements Shuttle {
    protected static final int MAX_DEPTH = 6;
    protected NodeEntry[] stack = new NodeEntry[6];
    protected int depth = -1;
    protected boolean hasRun = false;
    protected Art art;
    protected Containers containers;

    public AbstractShuttle(Art art, Containers containers) {
        this.art = art;
        this.containers = containers;
    }

    @Override
    public void initShuttle() {
        this.visitToLeaf(this.art.getRoot());
    }

    @Override
    public boolean moveToNextLeaf() {
        if (!this.hasRun) {
            this.hasRun = true;
            Node node = this.stack[this.depth].node;
            return node.nodeType == NodeType.LEAF_NODE;
        }
        if (this.depth < 0) {
            return false;
        }
        Node node = this.stack[this.depth].node;
        if (node.nodeType == NodeType.LEAF_NODE) {
            --this.depth;
        }
        while (this.depth >= 0) {
            int nextPos;
            int pos;
            NodeEntry currentNodeEntry = this.stack[this.depth];
            if (currentNodeEntry.node.nodeType == NodeType.LEAF_NODE) {
                return true;
            }
            if (!currentNodeEntry.visited) {
                currentNodeEntry.position = pos = currentNodeEntry.node.getMinPos();
                nextPos = pos;
                currentNodeEntry.visited = true;
            } else {
                pos = currentNodeEntry.position;
                nextPos = this.visitedNodeNextPosition(currentNodeEntry.node, pos);
            }
            if (nextPos != -1) {
                this.stack[this.depth].position = nextPos;
                ++this.depth;
                NodeEntry freshEntry = new NodeEntry();
                freshEntry.node = currentNodeEntry.node.getChild(nextPos);
                this.stack[this.depth] = freshEntry;
                continue;
            }
            --this.depth;
        }
        return false;
    }

    protected abstract int visitedNodeNextPosition(Node var1, int var2);

    @Override
    public LeafNode getCurrentLeafNode() {
        NodeEntry currentNode = this.stack[this.depth];
        return (LeafNode)currentNode.node;
    }

    @Override
    public void remove() {
        byte[] currentLeafKey = this.getCurrentLeafNode().getKeyBytes();
        Art.Toolkit toolkit = this.art.removeSpecifyKey(this.art.getRoot(), currentLeafKey, 0);
        if (this.containers != null) {
            this.containers.remove(toolkit.matchedContainerId);
        }
        Node node = toolkit.matchedParentNode;
        if (this.depth - 1 >= 0) {
            NodeEntry oldEntry = this.stack[this.depth - 1];
            oldEntry.node = node;
        }
    }

    private void visitToLeaf(Node node) {
        int pos;
        if (node == null) {
            return;
        }
        if (node == this.art.getRoot()) {
            NodeEntry nodeEntry = new NodeEntry();
            nodeEntry.node = node;
            this.depth = 0;
            this.stack[this.depth] = nodeEntry;
        }
        if (node.nodeType == NodeType.LEAF_NODE) {
            return;
        }
        if (this.depth == 6) {
            return;
        }
        this.stack[this.depth].position = pos = this.boundaryNodePosition(node);
        this.stack[this.depth].visited = true;
        Node child = node.getChild(pos);
        NodeEntry childNodeEntry = new NodeEntry();
        childNodeEntry.node = child;
        ++this.depth;
        this.stack[this.depth] = childNodeEntry;
        this.visitToLeaf(child);
    }

    protected abstract int boundaryNodePosition(Node var1);

    class NodeEntry {
        Node node = null;
        int position = -1;
        boolean visited = false;

        NodeEntry() {
        }
    }
}

