/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.UnmodifiableHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class HtmlChunk {
    @Contract(pure=true)
    @NotNull
    public Element wrapWith(@NotNull @NonNls String tagName) {
        if (tagName == null) {
            HtmlChunk.$$$reportNull$$$0(0);
        }
        return new Element(tagName, UnmodifiableHashMap.empty(), Collections.singletonList(this));
    }

    @Contract(pure=true)
    @NotNull
    public Element wrapWith(@NotNull Element element) {
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(1);
        }
        Element element2 = element.child(this);
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(2);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public Element code() {
        Element element = this.wrapWith("code");
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(3);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public Element bold() {
        Element element = this.wrapWith("b");
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(4);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public Element italic() {
        Element element = this.wrapWith("i");
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(5);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public Element strikethrough() {
        Element element = this.wrapWith("s");
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(6);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element tag(@NotNull @NonNls String tagName) {
        if (tagName == null) {
            HtmlChunk.$$$reportNull$$$0(7);
        }
        return new Element(tagName, UnmodifiableHashMap.empty(), Collections.emptyList());
    }

    @Contract(pure=true)
    @NotNull
    public static Element div() {
        Element element = Element.DIV;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(8);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element div(@NotNull @NonNls String style) {
        if (style == null) {
            HtmlChunk.$$$reportNull$$$0(9);
        }
        Element element = Element.DIV.style(style);
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(10);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element span() {
        Element element = Element.SPAN;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(11);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element span(@NonNls @NotNull String style) {
        if (style == null) {
            HtmlChunk.$$$reportNull$$$0(12);
        }
        Element element = Element.SPAN.style(style);
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(13);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element br() {
        Element element = Element.BR;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(14);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element li() {
        Element element = Element.LI;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(15);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element ul() {
        Element element = Element.UL;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(16);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element hr() {
        Element element = Element.HR;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(17);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element p() {
        Element element = Element.P;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(18);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element head() {
        Element element = Element.HEAD;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(19);
        }
        return element;
    }

    @NotNull
    public static Element styleTag(@NonNls @NotNull String style) {
        if (style == null) {
            HtmlChunk.$$$reportNull$$$0(20);
        }
        Element element = HtmlChunk.tag("style").addRaw(style);
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(21);
        }
        return element;
    }

    @NotNull
    public static Element font(@NonNls @NotNull String color) {
        if (color == null) {
            HtmlChunk.$$$reportNull$$$0(22);
        }
        Element element = HtmlChunk.tag("font").attr("color", color);
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(23);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element body() {
        Element element = Element.BODY;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(24);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element html() {
        Element element = Element.HTML;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(25);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk nbsp() {
        HtmlChunk htmlChunk = Nbsp.ONE;
        if (htmlChunk == null) {
            HtmlChunk.$$$reportNull$$$0(26);
        }
        return htmlChunk;
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk nbsp(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        return new Nbsp(count);
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk text(@NotNull @Nls String text) {
        if (text == null) {
            HtmlChunk.$$$reportNull$$$0(27);
        }
        return text.isEmpty() ? HtmlChunk.empty() : new Text(text);
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk empty() {
        Empty empty = Empty.INSTANCE;
        if (empty == null) {
            HtmlChunk.$$$reportNull$$$0(28);
        }
        return empty;
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk raw(@NotNull @Nls String rawHtml) {
        if (rawHtml == null) {
            HtmlChunk.$$$reportNull$$$0(29);
        }
        return rawHtml.isEmpty() ? HtmlChunk.empty() : new Raw(rawHtml);
    }

    @Contract(pure=true)
    @NotNull
    public static Element link(@NotNull @NonNls String target, @NotNull @Nls String text) {
        if (target == null) {
            HtmlChunk.$$$reportNull$$$0(30);
        }
        if (text == null) {
            HtmlChunk.$$$reportNull$$$0(31);
        }
        return new Element("a", UnmodifiableHashMap.empty().with("href", target), Collections.singletonList(HtmlChunk.text(text)));
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk htmlEntity(@NotNull @NlsSafe String htmlEntity) {
        if (htmlEntity == null) {
            HtmlChunk.$$$reportNull$$$0(32);
        }
        return HtmlChunk.raw(htmlEntity);
    }

    @Contract(pure=true)
    public boolean isEmpty() {
        return false;
    }

    public abstract void appendTo(@NotNull StringBuilder var1);

    @Contract(pure=true)
    @NlsSafe
    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendTo(builder);
        String string = builder.toString();
        if (string == null) {
            HtmlChunk.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static Collector<HtmlChunk, ?, HtmlChunk> toFragment() {
        Collector<HtmlChunk, HtmlBuilder, HtmlChunk> collector = Collector.of(HtmlBuilder::new, HtmlBuilder::append, HtmlBuilder::append, HtmlBuilder::toFragment, new Collector.Characteristics[0]);
        if (collector == null) {
            HtmlChunk.$$$reportNull$$$0(34);
        }
        return collector;
    }

    @Contract(pure=true)
    @NotNull
    public static Collector<HtmlChunk, ?, HtmlChunk> toFragment(HtmlChunk separator) {
        Collector<HtmlChunk, HtmlBuilder, HtmlChunk> collector = Collector.of(HtmlBuilder::new, (hb, c) -> {
            if (!hb.isEmpty()) {
                hb.append(separator);
            }
            hb.append((HtmlChunk)c);
        }, (hb1, hb2) -> {
            if (!hb1.isEmpty()) {
                hb1.append(separator);
            }
            return hb1.append((HtmlBuilder)hb2);
        }, HtmlBuilder::toFragment, new Collector.Characteristics[0]);
        if (collector == null) {
            HtmlChunk.$$$reportNull$$$0(35);
        }
        return collector;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 33: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/HtmlChunk";
                break;
            }
            case 9: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawHtml";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlEntity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/HtmlChunk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWith";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "code";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "bold";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "italic";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "strikethrough";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "div";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "span";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "br";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "li";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "ul";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "hr";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "p";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "head";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "styleTag";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "font";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "body";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "html";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "nbsp";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "toFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapWith";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tag";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "div";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "span";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "styleTag";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "font";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "text";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "raw";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "link";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "htmlEntity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Element
    extends HtmlChunk {
        private static final Element HEAD = Element.tag("head");
        private static final Element BODY = Element.tag("body");
        private static final Element HTML = Element.tag("html");
        private static final Element BR = Element.tag("br");
        private static final Element UL = Element.tag("ul");
        private static final Element LI = Element.tag("li");
        private static final Element HR = Element.tag("hr");
        private static final Element P = Element.tag("p");
        private static final Element DIV = Element.tag("div");
        private static final Element SPAN = Element.tag("span");
        private final String myTagName;
        private final UnmodifiableHashMap<String, String> myAttributes;
        private final List<HtmlChunk> myChildren;

        private Element(String name, UnmodifiableHashMap<String, String> attributes, List<HtmlChunk> children) {
            this.myTagName = name;
            this.myAttributes = attributes;
            this.myChildren = children;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            if (builder == null) {
                Element.$$$reportNull$$$0(0);
            }
            builder.append('<').append(this.myTagName);
            this.myAttributes.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> builder.append(' ').append((String)entry.getKey()).append("=\"").append(StringUtil.escapeXmlEntities((String)entry.getValue())).append('\"'));
            if (this.myChildren.isEmpty()) {
                builder.append("/>");
            } else {
                builder.append(">");
                for (HtmlChunk child : this.myChildren) {
                    child.appendTo(builder);
                }
                builder.append("</").append(this.myTagName).append(">");
            }
        }

        @Contract(pure=true)
        @NotNull
        public Element attr(@NonNls String name, String value) {
            return new Element(this.myTagName, this.myAttributes.with(name, value), this.myChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element attr(@NonNls String name, int value) {
            return new Element(this.myTagName, this.myAttributes.with(name, Integer.toString(value)), this.myChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element style(@NonNls String style) {
            Element element = this.attr("style", style);
            if (element == null) {
                Element.$$$reportNull$$$0(1);
            }
            return element;
        }

        @Contract(pure=true)
        @NotNull
        public Element addText(@NotNull @Nls String text) {
            if (text == null) {
                Element.$$$reportNull$$$0(2);
            }
            Element element = this.child(Element.text(text));
            if (element == null) {
                Element.$$$reportNull$$$0(3);
            }
            return element;
        }

        @Contract(pure=true)
        @NotNull
        public Element addRaw(@NotNull @Nls String text) {
            if (text == null) {
                Element.$$$reportNull$$$0(4);
            }
            Element element = this.child(Element.raw(text));
            if (element == null) {
                Element.$$$reportNull$$$0(5);
            }
            return element;
        }

        @Contract(pure=true)
        @NotNull
        public Element children(HtmlChunk ... chunks) {
            if (chunks == null) {
                Element.$$$reportNull$$$0(6);
            }
            if (this.myChildren.isEmpty()) {
                return new Element(this.myTagName, this.myAttributes, Arrays.asList(chunks));
            }
            ArrayList<HtmlChunk> newChildren = new ArrayList<HtmlChunk>(this.myChildren.size() + chunks.length);
            newChildren.addAll(this.myChildren);
            Collections.addAll(newChildren, chunks);
            return new Element(this.myTagName, this.myAttributes, newChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element children(@NotNull List<HtmlChunk> chunks) {
            if (chunks == null) {
                Element.$$$reportNull$$$0(7);
            }
            if (this.myChildren.isEmpty()) {
                return new Element(this.myTagName, this.myAttributes, new ArrayList<HtmlChunk>(chunks));
            }
            ArrayList<HtmlChunk> newChildren = new ArrayList<HtmlChunk>(this.myChildren.size() + chunks.size());
            newChildren.addAll(this.myChildren);
            newChildren.addAll(chunks);
            return new Element(this.myTagName, this.myAttributes, newChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element child(@NotNull HtmlChunk chunk) {
            if (chunk == null) {
                Element.$$$reportNull$$$0(8);
            }
            if (this.myChildren.isEmpty()) {
                return new Element(this.myTagName, this.myAttributes, Collections.singletonList(chunk));
            }
            ArrayList<HtmlChunk> newChildren = new ArrayList<HtmlChunk>(this.myChildren.size() + 1);
            newChildren.addAll(this.myChildren);
            newChildren.add(chunk);
            return new Element(this.myTagName, this.myAttributes, newChildren);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/text/HtmlChunk$Element";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunks";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/text/HtmlChunk$Element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "style";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addRaw";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "appendTo";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addText";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addRaw";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "children";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "child";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Nbsp
    extends HtmlChunk {
        private static final HtmlChunk ONE = new Nbsp(1);
        private final int myCount;

        private Nbsp(int count) {
            this.myCount = count;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            if (builder == null) {
                Nbsp.$$$reportNull$$$0(0);
            }
            builder.append(StringUtil.repeat("&nbsp;", this.myCount));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/util/text/HtmlChunk$Nbsp", "appendTo"));
        }
    }

    static class Fragment
    extends HtmlChunk {
        private final List<HtmlChunk> myContent;

        Fragment(List<HtmlChunk> content) {
            this.myContent = content;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            if (builder == null) {
                Fragment.$$$reportNull$$$0(0);
            }
            for (HtmlChunk chunk : this.myContent) {
                chunk.appendTo(builder);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/util/text/HtmlChunk$Fragment", "appendTo"));
        }
    }

    private static class Raw
    extends HtmlChunk {
        private final String myContent;

        private Raw(String content) {
            this.myContent = content;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            if (builder == null) {
                Raw.$$$reportNull$$$0(0);
            }
            builder.append(this.myContent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/util/text/HtmlChunk$Raw", "appendTo"));
        }
    }

    private static class Text
    extends HtmlChunk {
        private final String myContent;

        private Text(String content) {
            this.myContent = content;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            if (builder == null) {
                Text.$$$reportNull$$$0(0);
            }
            builder.append(StringUtil.escapeXmlEntities(this.myContent).replaceAll("\n", "<br/>"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/util/text/HtmlChunk$Text", "appendTo"));
        }
    }

    private static class Empty
    extends HtmlChunk {
        private static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            if (builder == null) {
                Empty.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/util/text/HtmlChunk$Empty", "appendTo"));
        }
    }
}

