/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Preconditions;

final class JTableContentsQuery {
    @Nonnull
    @RunsInEDT
    static String[][] tableContents(final @Nonnull JTable table, final @Nonnull JTableCellReader cellReader) {
        String[][] result = GuiActionRunner.execute(new GuiQuery<String[][]>(){

            @Override
            @Nonnull
            protected String[][] executeInEDT() {
                int rCount = table.getRowCount();
                int cCount = table.getColumnCount();
                String[][] contents = new String[rCount][cCount];
                for (int r = 0; r < rCount; ++r) {
                    for (int c = 0; c < cCount; ++c) {
                        contents[r][c] = cellReader.valueAt(table, r, c);
                    }
                }
                return contents;
            }
        });
        return (String[][])Preconditions.checkNotNull((Object)result);
    }

    private JTableContentsQuery() {
    }
}

