/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Container;
import javax.annotation.Nonnull;
import javax.swing.JFrame;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.fixture.FrameFixture;
import org.fest.util.Preconditions;

public final class Containers {
    public static final String CREATED_FRAME_NAME = "org.fest.swing.CreatedFrameForContainer";

    @Nonnull
    @RunsInEDT
    public static FrameFixture showInFrame(@Nonnull Robot robot, @Nonnull Container contentPane) {
        FrameFixture frameFixture = Containers.frameFixtureFor(robot, contentPane);
        frameFixture.show();
        return frameFixture;
    }

    @Nonnull
    @RunsInEDT
    public static FrameFixture frameFixtureFor(@Nonnull Robot robot, @Nonnull Container contentPane) {
        return new FrameFixture(robot, Containers.frameFor(contentPane));
    }

    @Nonnull
    @RunsInEDT
    public static JFrame frameFor(final @Nonnull Container contentPane) {
        JFrame result = GuiActionRunner.execute(new GuiQuery<JFrame>(){

            @Override
            protected JFrame executeInEDT() throws Throwable {
                JFrame frame = new JFrame("Created by FEST");
                frame.setName(Containers.CREATED_FRAME_NAME);
                frame.setContentPane(contentPane);
                return frame;
            }
        });
        return (JFrame)Preconditions.checkNotNull((Object)result);
    }

    private Containers() {
    }
}

