/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.image;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.FocusOwnerFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.image.ImageException;
import org.fest.swing.image.ImageFileWriter;
import org.fest.swing.query.ComponentLocationOnScreenQuery;
import org.fest.swing.query.ComponentSizeQuery;
import org.fest.swing.util.RobotFactory;
import org.fest.util.IORuntimeException;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

public class ScreenshotTaker {
    private final Robot robot;
    private final ImageFileWriter writer;

    public ScreenshotTaker() {
        this(new ImageFileWriter(), new RobotFactory());
    }

    @VisibleForTesting
    ScreenshotTaker(@Nonnull ImageFileWriter writer, @Nonnull RobotFactory robotFactory) {
        this.writer = writer;
        try {
            this.robot = robotFactory.newRobotInPrimaryScreen();
        }
        catch (AWTException e) {
            throw new ImageException("Unable to create AWT Robot", e);
        }
    }

    public void saveDesktopAsPng(String imageFilePath) {
        BufferedImage image = this.takeDesktopScreenshot();
        ScreenshotTaker.indicatePointerLocation(image);
        this.saveImage(image, imageFilePath);
    }

    private static void indicatePointerLocation(BufferedImage image) {
        Point mouse = MouseInfo.getPointerInfo().getLocation();
        Graphics g = image.getGraphics();
        g.setColor(Color.RED);
        g.fillRect(mouse.x - 10, mouse.y, 20, 1);
        g.fillRect(mouse.x, mouse.y - 10, 1, 20);
        g.dispose();
    }

    public BufferedImage takeDesktopScreenshot() {
        Rectangle r = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        return this.takeScreenshot(r);
    }

    public void saveComponentAsPng(@Nonnull Component c, @Nonnull String imageFilePath) {
        this.saveImage(this.takeScreenshotOf(c), imageFilePath);
    }

    @Nonnull
    public BufferedImage takeScreenshotOf(@Nonnull Component c) {
        Point locationOnScreen = ComponentLocationOnScreenQuery.locationOnScreen(c);
        Dimension size = ComponentSizeQuery.sizeOf(c);
        Rectangle r = new Rectangle(locationOnScreen.x, locationOnScreen.y, size.width, size.height);
        return this.takeScreenshot(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private BufferedImage takeScreenshot(Rectangle r) {
        JTextComponent textComponent = ScreenshotTaker.findFocusOwnerAndHideItsCaret();
        this.robot.waitForIdle();
        try {
            BufferedImage bufferedImage = ScreenshotTaker.takeScreenshot(this.robot, r);
            return bufferedImage;
        }
        finally {
            this.showCaretIfPossible(textComponent);
        }
    }

    @RunsInEDT
    private static JTextComponent findFocusOwnerAndHideItsCaret() {
        return GuiActionRunner.execute(new GuiQuery<JTextComponent>(){

            @Override
            protected JTextComponent executeInEDT() {
                Component focusOwner = FocusOwnerFinder.focusOwner();
                if (!(focusOwner instanceof JTextComponent)) {
                    return null;
                }
                JTextComponent textComponent = (JTextComponent)focusOwner;
                Caret caret = textComponent.getCaret();
                if (caret == null || !caret.isVisible()) {
                    return null;
                }
                caret.setVisible(false);
                return textComponent;
            }
        });
    }

    @Nonnull
    private static BufferedImage takeScreenshot(final @Nonnull Robot robot, final @Nonnull Rectangle r) {
        BufferedImage result = GuiActionRunner.execute(new GuiQuery<BufferedImage>(){

            @Override
            @Nullable
            protected BufferedImage executeInEDT() {
                return robot.createScreenCapture(r);
            }
        });
        return (BufferedImage)Preconditions.checkNotNull((Object)result);
    }

    private void showCaretIfPossible(@Nullable JTextComponent textComponent) {
        if (textComponent == null) {
            return;
        }
        ScreenshotTaker.showCaretOf(textComponent);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void showCaretOf(final @Nonnull JTextComponent textComponent) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                Caret caret = textComponent.getCaret();
                if (caret != null) {
                    caret.setVisible(true);
                }
            }
        });
    }

    public void saveImage(@Nonnull BufferedImage image, @Nonnull String filePath) {
        Preconditions.checkNotNullOrEmpty((String)filePath);
        if (!filePath.endsWith("png")) {
            String format = String.format("The file in path '%s' should have extension 'png'", filePath);
            throw new IllegalArgumentException(format);
        }
        try {
            this.writer.writeAsPng(image, filePath);
        }
        catch (IOException e) {
            String msg = String.format("Unable to save image as '%s'", filePath);
            throw new IORuntimeException(msg, e);
        }
    }
}

