/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.FilePosition;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class FileNavigatable
implements Navigatable {
    private final Project myProject;
    private final NullableLazyValue<OpenFileDescriptor> myValue;
    private final FilePosition myFilePosition;

    public FileNavigatable(Project project, FilePosition filePosition) {
        this.myProject = project;
        this.myFilePosition = filePosition;
        this.myValue = new NullableLazyValue<OpenFileDescriptor>(){

            @Nullable
            protected OpenFileDescriptor compute() {
                return FileNavigatable.this.createDescriptor();
            }
        };
    }

    public void navigate(boolean requestFocus) {
        OpenFileDescriptor descriptor2 = this.getFileDescriptor();
        if (descriptor2 != null) {
            descriptor2.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        OpenFileDescriptor descriptor2 = this.getFileDescriptor();
        if (descriptor2 != null) {
            return descriptor2.canNavigate();
        }
        return false;
    }

    public boolean canNavigateToSource() {
        OpenFileDescriptor descriptor2 = this.getFileDescriptor();
        if (descriptor2 != null) {
            return descriptor2.canNavigateToSource();
        }
        return false;
    }

    @Nullable
    public OpenFileDescriptor getFileDescriptor() {
        return (OpenFileDescriptor)this.myValue.getValue();
    }

    @Nullable
    private OpenFileDescriptor createDescriptor() {
        OpenFileDescriptor descriptor2 = null;
        VirtualFile file2 = VfsUtil.findFileByIoFile((File)this.myFilePosition.getFile(), (boolean)false);
        if (file2 != null) {
            descriptor2 = new OpenFileDescriptor(this.myProject, file2, this.myFilePosition.getStartLine(), this.myFilePosition.getStartColumn());
        }
        return descriptor2;
    }
}

