/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

@Service
public final class DocRenderItemUpdater
implements Runnable {
    private static final long MAX_UPDATE_DURATION_MS = 50L;
    private final Map<Inlay<DocRenderer>, Boolean> myQueue = new HashMap<Inlay<DocRenderer>, Boolean>();

    static DocRenderItemUpdater getInstance() {
        return (DocRenderItemUpdater)ApplicationManager.getApplication().getService(DocRenderItemUpdater.class);
    }

    void updateInlays(@NotNull Collection<Inlay<DocRenderer>> inlays, boolean recreateContent) {
        if (inlays == null) {
            DocRenderItemUpdater.$$$reportNull$$$0(0);
        }
        if (inlays.isEmpty()) {
            return;
        }
        boolean wasEmpty = this.myQueue.isEmpty();
        for (Inlay<DocRenderer> inlay : inlays) {
            this.myQueue.merge(inlay, recreateContent, (oldValue, newValue2) -> newValue2 | oldValue);
        }
        if (wasEmpty) {
            this.processChunk();
        }
    }

    @Override
    public void run() {
        this.processChunk();
    }

    private void processChunk() {
        long deadline = System.currentTimeMillis() + 50L;
        HashMap<Editor, EditorScrollingPositionKeeper> keepers = new HashMap<Editor, EditorScrollingPositionKeeper>();
        ArrayList<Inlay<DocRenderer>> toProcess2 = new ArrayList<Inlay<DocRenderer>>(this.myQueue.keySet());
        Object2IntOpenHashMap memoMap = new Object2IntOpenHashMap();
        toProcess2.sort(Comparator.comparingInt(arg_0 -> DocRenderItemUpdater.lambda$processChunk$1((Object2IntMap)memoMap, arg_0)));
        do {
            Inlay inlay = (Inlay)toProcess2.remove(toProcess2.size() - 1);
            boolean updateContent = this.myQueue.remove(inlay);
            if (!inlay.isValid()) continue;
            Editor editor = inlay.getEditor();
            keepers.computeIfAbsent(editor, e -> {
                EditorScrollingPositionKeeper keeper = new EditorScrollingPositionKeeper(editor);
                keeper.savePosition();
                return keeper;
            });
            ((DocRenderer)inlay.getRenderer()).update(true, updateContent);
        } while (!toProcess2.isEmpty() && System.currentTimeMillis() < deadline);
        keepers.values().forEach(k -> k.restorePosition(false));
        if (!this.myQueue.isEmpty()) {
            SwingUtilities.invokeLater(this);
        }
    }

    private static int getVisibleOffset(Editor editor, Object2IntMap<Editor> memoMap) {
        return memoMap.computeIntIfAbsent((Object)editor, e -> {
            Rectangle visibleArea = e.getScrollingModel().getVisibleAreaOnScrollingFinished();
            if (editor.isDisposed() || visibleArea.height <= 0) {
                return e.getCaretModel().getOffset();
            }
            int y = visibleArea.y + visibleArea.height / 2;
            int visualLine = e.yToVisualLine(y);
            return e.visualPositionToOffset(new VisualPosition(visualLine, 0));
        });
    }

    private static /* synthetic */ int lambda$processChunk$1(Object2IntMap memoMap, Inlay i2) {
        return -Math.abs(i2.getOffset() - DocRenderItemUpdater.getVisibleOffset(i2.getEditor(), (Object2IntMap<Editor>)memoMap));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlays", "com/intellij/codeInsight/documentation/render/DocRenderItemUpdater", "updateInlays"));
    }
}

