/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.UIBundle;
import com.intellij.util.messages.MessageBusConnection;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurationTypeRunDashboardAdvertiserBase
implements RunManagerListener,
Disposable {
    private static final String DASHBOARD_NOTIFICATION_GROUP_ID = "Run Dashboard";
    private static final String SHOW_RUN_DASHBOARD_NOTIFICATION = "show.run.dashboard.notification";
    private final Project myProject;
    private Notification myNotification;

    public ConfigurationTypeRunDashboardAdvertiserBase(@NotNull Project project) {
        if (project == null) {
            ConfigurationTypeRunDashboardAdvertiserBase.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    protected abstract ConfigurationType getType();

    public void dispose() {
        if (this.myNotification != null) {
            this.myNotification.expire();
            this.myNotification = null;
        }
    }

    public final void subscribe() {
        if (this.myProject.isDefault() || ApplicationManager.getApplication().isUnitTestMode() || this.myProject.isDisposed()) {
            return;
        }
        if (!ConfigurationTypeRunDashboardAdvertiserBase.isEnabled(this.myProject)) {
            return;
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        Disposer.register((Disposable)connection, (Disposable)this);
        connection.subscribe(RunManagerListener.TOPIC, (Object)this);
        this.checkRunDashboardAvailability();
    }

    @Override
    public final void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            ConfigurationTypeRunDashboardAdvertiserBase.$$$reportNull$$$0(1);
        }
        if (!ConfigurationTypeRunDashboardAdvertiserBase.isEnabled(this.myProject)) {
            return;
        }
        if (settings.getType().equals(this.getType())) {
            ApplicationManager.getApplication().invokeLater(() -> this.checkRunDashboardAvailability(), o -> Disposer.isDisposed((Disposable)this));
        }
    }

    private void checkRunDashboardAvailability() {
        ConfigurationType type = this.getType();
        List settings = RunManager.getInstance((Project)this.myProject).getConfigurationSettingsList(type);
        if (settings.size() <= 1) {
            return;
        }
        if (RunDashboardManager.getInstance((Project)this.myProject).getTypes().contains(type.getId())) {
            return;
        }
        if (this.myNotification != null && !this.myNotification.isExpired()) {
            return;
        }
        String toolWindowName = UIBundle.message((String)"tool.window.name.services", (Object[])new Object[0]);
        this.myNotification = NotificationGroupManager.getInstance().getNotificationGroup(DASHBOARD_NOTIFICATION_GROUP_ID).createNotification(toolWindowName, ExecutionBundle.message((String)"run.dashboard.multiple.run.config.notification", (Object[])new Object[]{type.getDisplayName(), toolWindowName}), NotificationType.INFORMATION, (NotificationListener)new AdvertiserNotificationListener(this.myProject, type.getId()));
        this.myNotification.notify(this.myProject);
    }

    private static boolean isEnabled(Project project) {
        return PropertiesComponent.getInstance((Project)project).getBoolean(SHOW_RUN_DASHBOARD_NOTIFICATION, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/dashboard/ConfigurationTypeRunDashboardAdvertiserBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runConfigurationAdded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AdvertiserNotificationListener
    implements NotificationListener {
        private final Project myProject;
        private final String myTypeId;

        private AdvertiserNotificationListener(Project project, String typeId) {
            this.myProject = project;
            this.myTypeId = typeId;
        }

        public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
            if (notification2 == null) {
                AdvertiserNotificationListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                AdvertiserNotificationListener.$$$reportNull$$$0(1);
            }
            if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            String description = event.getDescription();
            if ("ignore".equals(description)) {
                PropertiesComponent.getInstance((Project)this.myProject).setValue(ConfigurationTypeRunDashboardAdvertiserBase.SHOW_RUN_DASHBOARD_NOTIFICATION, false, true);
                notification2.expire();
            } else if ("show".equals(description)) {
                notification2.hideBalloon();
                this.showInRunDashboard();
            }
        }

        private void showInRunDashboard() {
            RunDashboardManager dashboardManager = RunDashboardManager.getInstance((Project)this.myProject);
            HashSet<String> types = new HashSet<String>(dashboardManager.getTypes());
            types.add(this.myTypeId);
            dashboardManager.setTypes(types);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/dashboard/ConfigurationTypeRunDashboardAdvertiserBase$AdvertiserNotificationListener";
            objectArray[2] = "hyperlinkUpdate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

