/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.UIPluginGroup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PluginsGroup {
    @Nls
    protected final String myTitlePrefix;
    @Nls
    public String title;
    public JLabel titleLabel;
    public LinkLabel<Object> rightAction;
    public List<JComponent> rightActions;
    public final List<IdeaPluginDescriptor> descriptors;
    public UIPluginGroup ui;
    public Runnable clearCallback;

    public PluginsGroup(@NotNull @Nls String title) {
        if (title == null) {
            PluginsGroup.$$$reportNull$$$0(0);
        }
        this.descriptors = new ArrayList<IdeaPluginDescriptor>();
        this.myTitlePrefix = title;
        this.title = title;
    }

    public void clear() {
        this.ui = null;
        this.descriptors.clear();
        this.titleLabel = null;
        this.rightAction = null;
        this.rightActions = null;
        if (this.clearCallback != null) {
            this.clearCallback.run();
            this.clearCallback = null;
        }
    }

    public void addRightAction(@NotNull JComponent component2) {
        if (component2 == null) {
            PluginsGroup.$$$reportNull$$$0(1);
        }
        if (this.rightActions == null) {
            this.rightActions = new ArrayList<JComponent>();
        }
        this.rightActions.add(component2);
    }

    public void titleWithCount() {
        this.title = this.myTitlePrefix + " (" + this.descriptors.size() + ")";
        this.updateTitle();
    }

    public void titleWithEnabled(@NotNull MyPluginModel pluginModel) {
        if (pluginModel == null) {
            PluginsGroup.$$$reportNull$$$0(2);
        }
        int enabled = 0;
        for (IdeaPluginDescriptor descriptor2 : this.descriptors) {
            if (!pluginModel.isLoaded(descriptor2.getPluginId()) || !pluginModel.isEnabled(descriptor2) || PluginManagerCore.isIncompatible(descriptor2)) continue;
            ++enabled;
        }
        this.titleWithCount(enabled);
    }

    public void titleWithCount(int enabled) {
        this.title = IdeBundle.message((String)"plugins.configurable.title.with.count", (Object[])new Object[]{this.myTitlePrefix, enabled, this.descriptors.size()});
        this.updateTitle();
    }

    protected void updateTitle() {
        if (this.titleLabel != null) {
            this.titleLabel.setText(this.title);
        }
    }

    public int addWithIndex(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginsGroup.$$$reportNull$$$0(3);
        }
        this.descriptors.add(descriptor2);
        this.sortByName();
        return this.descriptors.indexOf(descriptor2);
    }

    public void sortByName() {
        PluginsGroup.sortByName(this.descriptors);
    }

    public static void sortByName(@NotNull List<? extends IdeaPluginDescriptor> descriptors2) {
        if (descriptors2 == null) {
            PluginsGroup.$$$reportNull$$$0(4);
        }
        ContainerUtil.sort(descriptors2, (o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/newui/PluginsGroup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addRightAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "titleWithEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addWithIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "sortByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

