/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml;

import com.intellij.internal.ml.InconsistentMetadataException;
import com.intellij.internal.ml.ModelMetadataReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/ml/ResourcesModelMetadataReader;", "Lcom/intellij/internal/ml/ModelMetadataReader;", "metadataHolder", "Ljava/lang/Class;", "featuresDirectory", "", "(Ljava/lang/Class;Ljava/lang/String;)V", "getMetadataHolder", "()Ljava/lang/Class;", "allKnown", "binaryFeatures", "categoricalFeatures", "extractVersion", "featureOrderDirect", "", "floatFeatures", "resourceContent", "fileName", "intellij.platform.ide.impl"})
public class ResourcesModelMetadataReader
implements ModelMetadataReader {
    @NotNull
    private final Class<?> metadataHolder;
    private final String featuresDirectory;

    @Override
    @NotNull
    public String binaryFeatures() {
        return this.resourceContent("binary.json");
    }

    @Override
    @NotNull
    public String floatFeatures() {
        return this.resourceContent("float.json");
    }

    @Override
    @NotNull
    public String categoricalFeatures() {
        return this.resourceContent("categorical.json");
    }

    @Override
    @NotNull
    public String allKnown() {
        return this.resourceContent("all_features.json");
    }

    @Override
    @NotNull
    public List<String> featureOrderDirect() {
        return StringsKt.lines((CharSequence)this.resourceContent("features_order.txt"));
    }

    @Override
    @Nullable
    public String extractVersion() {
        URL uRL = this.metadataHolder.getClassLoader().getResource(this.featuresDirectory + "/binary.json");
        if (uRL == null) {
            return null;
        }
        URL resource = uRL;
        String string = resource.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resource.file");
        String result2 = StringsKt.substringAfterLast((String)StringsKt.substringBeforeLast((String)string, (String)".jar!", (String)""), (String)"-", (String)"");
        return StringsKt.isBlank((CharSequence)result2) ? null : result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String resourceContent(String fileName) {
        InputStream fileStream;
        String resource = this.featuresDirectory + '/' + fileName;
        InputStream inputStream2 = this.metadataHolder.getClassLoader().getResourceAsStream(resource);
        if (inputStream2 == null) {
            throw (Throwable)new InconsistentMetadataException("Metadata file not found: " + resource + ". Resources holder: " + this.metadataHolder.getName());
        }
        Closeable closeable = fileStream = inputStream2;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Object object = closeable;
        int n = 0;
        object = new InputStreamReader((InputStream)object, charset);
        n = 8192;
        boolean bl2 = false;
        closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        boolean bl3 = false;
        bl = false;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl4 = false;
            object = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return object;
    }

    @NotNull
    protected final Class<?> getMetadataHolder() {
        return this.metadataHolder;
    }

    public ResourcesModelMetadataReader(@NotNull Class<?> metadataHolder, @NotNull String featuresDirectory) {
        Intrinsics.checkNotNullParameter(metadataHolder, (String)"metadataHolder");
        Intrinsics.checkNotNullParameter((Object)featuresDirectory, (String)"featuresDirectory");
        this.metadataHolder = metadataHolder;
        this.featuresDirectory = featuresDirectory;
    }
}

