/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorTabColorProvider;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorTabPresentationUtil {
    @NotNull
    @NlsContexts.TabTitle
    public static String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file2, @Nullable EditorWindow editorWindow) {
        if (project == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(1);
        }
        for (EditorTabTitleProvider provider2 : DumbService.getDumbAwareExtensions((Project)project, EditorTabTitleProvider.EP_NAME)) {
            String result2 = provider2.getEditorTabTitle(project, file2, editorWindow);
            if (!StringUtil.isNotEmpty((String)result2)) continue;
            String string = result2;
            if (string == null) {
                EditorTabPresentationUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = file2.getPresentableName();
        if (string == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getUniqueEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file2, @Nullable EditorWindow editorWindow) {
        String name;
        if (project == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(5);
        }
        if ((name = EditorTabPresentationUtil.getEditorTabTitle(project, file2, editorWindow)).equals(file2.getPresentableName())) {
            String string = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file2);
            if (string == null) {
                EditorTabPresentationUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static Color getEditorTabBackgroundColor(@NotNull Project project, @NotNull VirtualFile file2, @Nullable EditorWindow editorWindow) {
        if (project == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(9);
        }
        for (EditorTabColorProvider provider2 : DumbService.getDumbAwareExtensions((Project)project, EditorTabColorProvider.EP_NAME)) {
            Color result2 = provider2.getEditorTabColor(project, file2, editorWindow);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public static Color getFileBackgroundColor(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(11);
        }
        for (EditorTabColorProvider provider2 : DumbService.getDumbAwareExtensions((Project)project, EditorTabColorProvider.EP_NAME)) {
            Color result2 = provider2.getProjectViewColor(project, file2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @NotNull
    public static Color getFileForegroundColor(@NotNull Project project, @NotNull VirtualFile file2) {
        FileEditorManager manager;
        if (project == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(13);
        }
        if ((manager = FileEditorManager.getInstance((Project)project)) instanceof FileEditorManagerImpl) {
            Color color = ((FileEditorManagerImpl)manager).getFileColor(file2);
            if (color == null) {
                EditorTabPresentationUtil.$$$reportNull$$$0(14);
            }
            return color;
        }
        Color color = UIUtil.getLabelForeground();
        if (color == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(15);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorTabPresentationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorTabPresentationUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorTabTitle";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueEditorTabTitle";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileForegroundColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTabTitle";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueEditorTabTitle";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTabBackgroundColor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileBackgroundColor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFileForegroundColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

