/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.BundledKeymapBean;
import com.intellij.openapi.keymap.impl.DefaultKeymapImpl;
import com.intellij.openapi.keymap.impl.DefaultKeymapKt;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.MacOSDefaultKeymap;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0016H\u0016J+\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00042\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001fR\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/keymap/impl/DefaultKeymap;", "", "()V", "defaultKeymapName", "", "getDefaultKeymapName", "()Ljava/lang/String;", "keymaps", "Ljava/util/ArrayList;", "Lcom/intellij/openapi/keymap/Keymap;", "getKeymaps$intellij_platform_ide_impl", "()Ljava/util/ArrayList;", "nameToScheme", "Ljava/util/HashMap;", "addKeymap", "", "keymap", "Lcom/intellij/openapi/keymap/impl/DefaultKeymapImpl;", "findScheme", "name", "findScheme$intellij_platform_ide_impl", "getKeymapPresentableName", "Lcom/intellij/openapi/keymap/impl/KeymapImpl;", "loadKeymap", "keymapName", "dataHolder", "Lcom/intellij/configurationStore/SchemeDataHolder;", "plugin", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "loadKeymap$intellij_platform_ide_impl", "removeKeymap", "removeKeymap$intellij_platform_ide_impl", "Companion", "intellij.platform.ide.impl"})
public class DefaultKeymap {
    @NotNull
    private final ArrayList<Keymap> keymaps = new ArrayList<E>();
    private final HashMap<String, Keymap> nameToScheme = new HashMap<K, V>();
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ArrayList<Keymap> getKeymaps$intellij_platform_ide_impl() {
        return this.keymaps;
    }

    @NotNull
    public final DefaultKeymapImpl loadKeymap$intellij_platform_ide_impl(@NotNull String keymapName, @NotNull SchemeDataHolder<? super KeymapImpl> dataHolder, @NotNull PluginDescriptor plugin2) {
        Intrinsics.checkNotNullParameter((Object)keymapName, (String)"keymapName");
        Intrinsics.checkNotNullParameter(dataHolder, (String)"dataHolder");
        Intrinsics.checkNotNullParameter((Object)plugin2, (String)"plugin");
        DefaultKeymapImpl keymap2 = StringsKt.startsWith$default((String)keymapName, (String)"Mac OS X", (boolean)false, (int)2, null) ? (DefaultKeymapImpl)new MacOSDefaultKeymap(dataHolder, this, plugin2) : new DefaultKeymapImpl(dataHolder, this, plugin2);
        keymap2.setName(keymapName);
        this.addKeymap(keymap2);
        return keymap2;
    }

    private final void addKeymap(DefaultKeymapImpl keymap2) {
        this.keymaps.add(keymap2);
        ((Map)this.nameToScheme).put(keymap2.getName(), keymap2);
    }

    public final void removeKeymap$intellij_platform_ide_impl(@NotNull String keymapName) {
        Intrinsics.checkNotNullParameter((Object)keymapName, (String)"keymapName");
        Keymap removed = this.nameToScheme.remove(keymapName);
        Collection collection = this.keymaps;
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        TypeIntrinsics.asMutableCollection((Object)collection2).remove(removed);
    }

    @Nullable
    public final Keymap findScheme$intellij_platform_ide_impl(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.nameToScheme.get(name);
    }

    @NotNull
    public String getDefaultKeymapName() {
        return SystemInfo.isMac ? "Mac OS X 10.5+" : (SystemInfo.isGNOME ? "Default for GNOME" : (SystemInfo.isKDE ? "Default for KDE" : (SystemInfo.isXWindow ? "Default for XWin" : "$default")));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getKeymapPresentableName(@NotNull KeymapImpl keymap2) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)keymap2, (String)"keymap");
        switch (string2 = keymap2.getName()) {
            case "Mac OS X 10.5+": {
                string = "macOS";
                break;
            }
            case "$default": {
                string = "Windows";
                break;
            }
            case "Default for GNOME": {
                string = "GNOME";
                break;
            }
            case "Default for KDE": {
                string = "KDE";
                break;
            }
            case "Default for XWin": {
                string = "XWin";
                break;
            }
            case "Mac OS X": {
                string = "IntelliJ IDEA Classic" + (SystemInfo.isMac ? "" : " (macOS)");
                break;
            }
            case "NetBeans 6.5": {
                string = "NetBeans";
                break;
            }
            default: {
                void name;
                String newName2 = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)name, (CharSequence)" (Mac OS X)"), (CharSequence)" OSX");
                string = StringsKt.removePrefix((String)(newName2 == name ? name : newName2 + " (macOS)"), (CharSequence)(DefaultKeymapKt.access$osName() + '/'));
            }
        }
        return string;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public DefaultKeymap() {
        super();
        v0 = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ApplicationManager.getApplication()");
        if (v0.isHeadlessEnvironment()) ** GOTO lbl-1000
        var2_1 = System.getProperty("keymap.current.os.only", "true");
        var3_2 = false;
        if (Boolean.parseBoolean(var2_1)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        filterKeymaps = v1;
        var3_2 = false;
        filteredBeans = new ArrayList<E>();
        macosParentKeymapFound = false;
        if (SystemInfo.isMac) {
            v2 = null;
        } else {
            var5_4 = false;
            v2 = new ArrayList<E>();
        }
        macosBeans = v2;
        v3 = BundledKeymapBean.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(v3, (String)"BundledKeymapBean.EP_NAME");
        var6_8 = v3.getExtensionList().iterator();
        while (var6_8.hasNext()) {
            v4 = bean = (BundledKeymapBean)var6_8.next();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"bean");
            if (v4.getPluginDescriptor() == null) {
                continue;
            }
            keymapName = DefaultKeymapKt.getKeymapName(bean);
            if (filterKeymaps && plugin.isBundled() && DefaultKeymap.Companion.isBundledKeymapHidden(keymapName)) continue;
            if (filterKeymaps && macosBeans != null && !plugin.isBundled() && DefaultKeymapKt.access$isKnownMacOSKeymap(keymapName)) {
                macosParentKeymapFound = macosParentKeymapFound != false || Intrinsics.areEqual((Object)keymapName, (Object)"Mac OS X 10.5+") != false;
                macosBeans.add(bean);
                continue;
            }
            filteredBeans.add(bean);
        }
        if (macosParentKeymapFound && macosBeans != null) {
            filteredBeans.addAll(macosBeans);
        }
        for (BundledKeymapBean bean : filteredBeans) {
            $this$runAndLogException$iv = DefaultKeymapKt.access$getLOG$p();
            $i$f$runAndLogException = false;
            var9_12 = false;
            try {
                var10_13 /* !! */  = Result.Companion;
                $i$a$-runCatching-LoggerKt$runAndLogException$1$iv = false;
                $i$a$-runAndLogException-DefaultKeymap$1 = false;
                v5 = DefaultKeymapKt.getKeymapName(bean);
                v6 = new SchemeDataHolder<KeymapImpl>(this, bean){
                    final /* synthetic */ DefaultKeymap this$0;
                    final /* synthetic */ BundledKeymapBean $bean$inlined;
                    {
                        this.this$0 = defaultKeymap;
                        this.$bean$inlined = bundledKeymapBean;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @NotNull
                    public Element read() {
                        Element element2;
                        PluginDescriptor pluginDescriptor = this.$bean$inlined.getPluginDescriptor();
                        Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"bean.pluginDescriptor");
                        Closeable closeable = pluginDescriptor.getPluginClassLoader().getResourceAsStream(DefaultKeymapKt.getEffectiveFile(this.$bean$inlined));
                        boolean bl = false;
                        boolean bl2 = false;
                        Throwable throwable = null;
                        try {
                            InputStream it = (InputStream)closeable;
                            boolean bl3 = false;
                            Element element3 = JDOMUtil.load((InputStream)it);
                            element2 = element3;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"bean.pluginDescriptor.pl\u2026il.load(it)\n            }");
                        return element2;
                    }

                    public void updateDigest(@NotNull KeymapImpl scheme) {
                        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                        SchemeDataHolder.DefaultImpls.updateDigest(this, scheme);
                    }

                    public void updateDigest(@Nullable Element data2) {
                        SchemeDataHolder.DefaultImpls.updateDigest(this, data2);
                    }
                };
                v7 = bean.getPluginDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"bean.pluginDescriptor");
                var11_14 = this.loadKeymap$intellij_platform_ide_impl(v5, v6, v7);
                var13_18 = false;
                var10_13 /* !! */  = Result.constructor-impl((Object)var11_14);
            }
            catch (Throwable var11_16) {
                var13_19 = Result.Companion;
                var14_20 = false;
                var10_13 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var11_16));
            }
            LoggerKt.getOrLogException((Object)var10_13 /* !! */ , (Logger)$this$runAndLogException$iv);
        }
    }

    @NotNull
    public static final DefaultKeymap getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    public static final boolean isBundledKeymapHidden(@Nullable String keymapName) {
        return Companion.isBundledKeymapHidden(keymapName);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/keymap/impl/DefaultKeymap$Companion;", "", "()V", "instance", "Lcom/intellij/openapi/keymap/impl/DefaultKeymap;", "getInstance$annotations", "getInstance", "()Lcom/intellij/openapi/keymap/impl/DefaultKeymap;", "isBundledKeymapHidden", "", "keymapName", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final DefaultKeymap getInstance() {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(DefaultKeymap.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            return (DefaultKeymap)object;
        }

        @JvmStatic
        public final boolean isBundledKeymapHidden(@Nullable String keymapName) {
            return (SystemInfo.isWindows || SystemInfo.isMac) && DefaultKeymapKt.access$isKnownLinuxKeymap(keymapName) || !SystemInfo.isMac && DefaultKeymapKt.access$isKnownMacOSKeymap(keymapName);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

